/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.ProductTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.mdm.MdmProductException;
import com.biz.crm.nebular.mdm.product.req.MdmProductMaterialReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductMediaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductIntroductionRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.product.mapper.MdmProductIntroductionMapper;
import com.biz.crm.product.mapper.MdmProductMapper;
import com.biz.crm.product.mapper.MdmProductMaterialMapper;
import com.biz.crm.product.mapper.MdmProductMediaMapper;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.model.MdmProductIntroductionEntity;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.model.MdmProductMediaEntity;
import com.biz.crm.product.service.IMdmProductMaterialService;
import com.biz.crm.product.service.IMdmProductMediaService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MdmProductServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(MdmProductServiceHelper.class);
    @Autowired
    private MdmProductMapper productMapper;
    @Autowired
    private MdmProductMediaMapper productMediaMapper;
    @Autowired
    private MdmProductIntroductionMapper productIntroductionMapper;
    @Autowired
    private MdmProductMaterialMapper materialMapper;
    @Autowired
    private IMdmProductMaterialService materialService;
    @Autowired
    private IMdmProductMediaService mediaService;

    public Map<String, Map<String, String>> getProductDict() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("product_type");
        dictCodes.add("enable_status");
        dictCodes.add("product_sale_unit");
        dictCodes.add("product_base_unit");
        dictCodes.add("material_base_unit");
        dictCodes.add("material_sale_unit");
        dictCodes.add("is_shelf");
        Map map = DictUtil.getDictValueMapsByCodes((List)dictCodes);
        return map;
    }

    public void convertListDate(List<MdmProductRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getProductDict();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getIsShelf())) {
                    o.setIsShelfName((String)((Map)Optional.ofNullable(map.get("is_shelf")).orElse(Maps.newHashMap())).get(o.getIsShelf()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getProductType())) {
                    o.setProductTypeName((String)((Map)Optional.ofNullable(map.get("product_type")).orElse(Maps.newHashMap())).get(o.getProductType()));
                }
                if (!StringUtils.equals((CharSequence)ProductTypeEnum.STANDARD.getCode(), (CharSequence)o.getProductType())) {
                    if (StringUtils.isNotEmpty((CharSequence)o.getSaleUnit())) {
                        o.setSaleUnitName((String)((Map)Optional.ofNullable(map.get("product_sale_unit")).orElse(Maps.newHashMap())).get(o.getSaleUnit()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)o.getBaseUnit())) {
                        o.setBaseUnitName((String)((Map)Optional.ofNullable(map.get("product_base_unit")).orElse(Maps.newHashMap())).get(o.getBaseUnit()));
                    }
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)o.getSaleUnit())) {
                        o.setSaleUnitName((String)((Map)Optional.ofNullable(map.get("material_sale_unit")).orElse(Maps.newHashMap())).get(o.getSaleUnit()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)o.getBaseUnit())) {
                        o.setBaseUnitName((String)((Map)Optional.ofNullable(map.get("material_base_unit")).orElse(Maps.newHashMap())).get(o.getBaseUnit()));
                    }
                }
                if (Objects.nonNull(o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
            });
        }
    }

    public void saveProductEntity(MdmProductEntity mdmProductEntity) {
        if (Objects.isNull((Object)mdmProductEntity)) {
            throw new BusinessException((CrmExceptionType)MdmProductException.PRODUCT_NULL);
        }
        this.productMapper.insert((Object)mdmProductEntity);
    }

    public void saveProductMaterials(List<MdmProductMaterialEntity> materialEntities) {
        if (CollectionUtils.isEmpty(materialEntities)) {
            throw new BusinessException((CrmExceptionType)MdmProductException.PRODUCT_MATERIAL_NULL);
        }
        materialEntities.forEach(o -> this.materialMapper.insert(o));
    }

    public void saveProductMedias(List<MdmProductMediaEntity> mediaEntities) {
        if (CollectionUtils.isNotEmpty(mediaEntities)) {
            mediaEntities.forEach(o -> this.productMediaMapper.insert(o));
        }
    }

    public void saveProductIntroduction(MdmProductIntroductionEntity mdmProductIntroductionEntity) {
        if (Objects.nonNull((Object)mdmProductIntroductionEntity)) {
            this.productIntroductionMapper.insert((Object)mdmProductIntroductionEntity);
        }
    }

    public List<MdmProductEntity> findProductsByParam(MdmProductReqVo reqVo) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getProductCode())) {
            wrapper.eq((Object)"product_code", (Object)reqVo.getProductCode());
        }
        return this.productMapper.selectList((Wrapper)wrapper);
    }

    public List<MdmProductMaterialRespVo> findMaterialByProductCode(String productCode) {
        MdmProductMaterialReqVo materialReqVo = new MdmProductMaterialReqVo();
        materialReqVo.setProductCode(productCode);
        return this.materialService.findList(materialReqVo).getData();
    }

    public List<MdmProductMediaRespVo> findMediaByProductCode(String productCode) {
        MdmProductMediaReqVo mediaReqVo = new MdmProductMediaReqVo();
        mediaReqVo.setProductCode(productCode);
        PageResult<MdmProductMediaRespVo> page = this.mediaService.findList(mediaReqVo);
        return page.getData();
    }

    public MdmProductIntroductionRespVo findIntroductionByProductCode(String productCode) {
        MdmProductIntroductionEntity introductionEntity = (MdmProductIntroductionEntity)((Object)this.productIntroductionMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"product_code", (Object)productCode)).eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode())));
        MdmProductIntroductionRespVo respVo = new MdmProductIntroductionRespVo();
        CrmBeanUtil.copyProperties((Object)((Object)introductionEntity), (Object)respVo);
        return respVo;
    }
}

