/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.FileTypeEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.mdm.MdmProductException;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductIntroductionRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.product.mapper.MdmProductMapper;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.service.IMdmProductService;
import com.biz.crm.product.service.impl.MdmProductBuilder;
import com.biz.crm.product.service.impl.MdmProductServiceHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iMdmProductService")
public class MdmProductServiceImpl
extends ServiceImpl<MdmProductMapper, MdmProductEntity>
implements IMdmProductService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductServiceImpl.class);
    @Autowired
    private MdmProductMapper mdmProductMapper;
    @Autowired
    private MdmProductServiceHelper productServiceHelper;

    @Override
    public PageResult<MdmProductRespVo> findList(MdmProductReqVo mdmProductReqVo) {
        Page page = new Page((long)mdmProductReqVo.getPageNum().intValue(), (long)mdmProductReqVo.getPageSize().intValue());
        List<MdmProductRespVo> list = this.mdmProductMapper.findList((Page<MdmProductRespVo>)page, mdmProductReqVo);
        this.productServiceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmProductRespVo query(MdmProductReqVo mdmProductReqVo) {
        PageResult<MdmProductRespVo> page = this.findList(mdmProductReqVo);
        List list = page.getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException((CrmExceptionType)MdmProductException.PRODUCT_NOT_EXIST);
        }
        MdmProductRespVo mdmProductRespVo = (MdmProductRespVo)list.get(0);
        List<MdmProductMaterialRespVo> materialRespVos = this.productServiceHelper.findMaterialByProductCode(mdmProductRespVo.getProductCode());
        mdmProductRespVo.setMaterialList(materialRespVos);
        List<MdmProductMediaRespVo> medias = this.productServiceHelper.findMediaByProductCode(mdmProductRespVo.getProductCode());
        if (CollectionUtils.isNotEmpty(medias)) {
            Map<String, List<MdmProductMediaRespVo>> mediaMap = medias.stream().collect(Collectors.groupingBy(MdmProductMediaRespVo::getType));
            mdmProductRespVo.setPictureList(mediaMap.get(FileTypeEnum.PICTURE.getCode()));
            mdmProductRespVo.setVideoList(mediaMap.get(FileTypeEnum.VIDEO.getCode()));
        }
        MdmProductIntroductionRespVo introduction = this.productServiceHelper.findIntroductionByProductCode(mdmProductReqVo.getProductCode());
        mdmProductRespVo.setIntroductionVo(introduction);
        return mdmProductRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductReqVo mdmProductReqVo) {
        MdmProductBuilder.builder(this.productServiceHelper, mdmProductReqVo).init().check().convert().save();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductReqVo mdmProductReqVo) {
        MdmProductEntity entity = (MdmProductEntity)((Object)this.getById((Serializable)((Object)mdmProductReqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmProductReqVo mdmProductReqVo) {
        List mdmProductEntities = this.mdmProductMapper.selectBatchIds(mdmProductReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
            mdmProductEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmProductEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmProductReqVo mdmProductReqVo) {
        List mdmProductEntities = this.mdmProductMapper.selectBatchIds(mdmProductReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
            mdmProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmProductEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmProductReqVo mdmProductReqVo) {
        List mdmProductEntities = this.mdmProductMapper.selectBatchIds(mdmProductReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
            mdmProductEntities.forEach(o -> {
                o.setIsShelf(IsShelfEnum.DOWN.getCode());
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(mdmProductEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void upShelf(MdmProductReqVo mdmProductReqVo) {
        List mdmProductEntities = this.mdmProductMapper.selectBatchIds(mdmProductReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
            mdmProductEntities.forEach(o -> o.setIsShelf(IsShelfEnum.UP.getCode()));
        }
        this.updateBatchById(mdmProductEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void downShelf(MdmProductReqVo mdmProductReqVo) {
        List mdmProductEntities = this.mdmProductMapper.selectBatchIds(mdmProductReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
            mdmProductEntities.forEach(o -> o.setIsShelf(IsShelfEnum.DOWN.getCode()));
        }
        this.updateBatchById(mdmProductEntities);
    }
}

