/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.productlevel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.productlevel.mapper.MdmProductLevelMapper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.IMdmProductLevelService;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmProductLevelServiceImpl
extends ServiceImpl<MdmProductLevelMapper, MdmProductLevelEntity>
implements IMdmProductLevelService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelServiceImpl.class);
    @Autowired
    private MdmProductLevelMapper mdmProductLevelMapper;

    @Override
    public PageResult<MdmProductLevelRespVo> findList(MdmProductLevelReqVo mdmProductLevelReqVo) {
        Page page = new Page((long)mdmProductLevelReqVo.getPageNum().intValue(), (long)mdmProductLevelReqVo.getPageSize().intValue());
        List<MdmProductLevelRespVo> list = this.mdmProductLevelMapper.findList((Page<MdmProductLevelRespVo>)page, mdmProductLevelReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmProductLevelRespVo query(MdmProductLevelReqVo mdmProductLevelReqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductLevelReqVo mdmProductLevelReqVo) {
        MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)CrmBeanUtil.copy((Object)mdmProductLevelReqVo, MdmProductLevelEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductLevelReqVo mdmProductLevelReqVo) {
        MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)this.getById((Serializable)((Object)mdmProductLevelReqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List mdmProductLevelEntities = this.mdmProductLevelMapper.selectBatchIds(mdmProductLevelReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductLevelEntities)) {
            mdmProductLevelEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmProductLevelEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List mdmProductLevelEntities = this.mdmProductLevelMapper.selectBatchIds(mdmProductLevelReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductLevelEntities)) {
            mdmProductLevelEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmProductLevelEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List mdmProductLevelEntities = this.mdmProductLevelMapper.selectBatchIds(mdmProductLevelReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductLevelEntities)) {
            mdmProductLevelEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmProductLevelEntities);
    }

    @Override
    public MdmProductLevelEntity findDetailsByFormInstanceId(String formInstanceId) {
        if (StringUtils.isBlank((CharSequence)formInstanceId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"form_instance_id", (Object)formInstanceId);
        List mdmProductLevelEntities = this.mdmProductLevelMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)mdmProductLevelEntities)) {
            return null;
        }
        return (MdmProductLevelEntity)((Object)mdmProductLevelEntities.get(0));
    }
}

