/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.MdmCustomerBillMapper;
import com.biz.crm.customer.model.MdmCustomerBillEntity;
import com.biz.crm.customer.service.MdmCustomerBillService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerBillReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerBillRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerBillServiceExpandImpl"})
public class MdmCustomerBillServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerBillMapper, MdmCustomerBillEntity>
implements MdmCustomerBillService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerBillServiceImpl.class);

    @Override
    public void setUp(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
        List mdmCustomerBillVos = mdmCustomerMsgReqVo.getMdmCustomerBillVos();
        if (!StringUtils.isEmpty((Object)customerCode)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerBillEntity::getCustomerCode, (Object)customerCode)).remove();
            if (!CollectionUtils.isEmpty((Collection)mdmCustomerBillVos)) {
                long count = mdmCustomerBillVos.stream().filter(x -> !StringUtils.isEmpty((Object)x.getBillMain())).filter(x -> YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getBillMain())).count();
                if (count != 1L) {
                    mdmCustomerBillVos = mdmCustomerBillVos.stream().peek(x -> x.setBillMain(YesNoEnum.yesNoEnum.ZERO.getValue())).collect(Collectors.toList());
                    ((MdmCustomerBillReqVo)mdmCustomerBillVos.get(0)).setBillMain(YesNoEnum.yesNoEnum.ONE.getValue());
                }
                mdmCustomerBillVos = mdmCustomerBillVos.stream().peek(x -> x.setCustomerCode(customerCode)).collect(Collectors.toList());
                this.saveBatch(CrmBeanUtil.copyList(mdmCustomerBillVos, MdmCustomerBillEntity.class));
            }
        }
    }

    @Override
    public List<MdmCustomerBillRespVo> listCondition(String customerCode) {
        if (StringUtils.isEmpty((Object)customerCode)) {
            return Collections.emptyList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerBillEntity::getCustomerCode, (Object)customerCode)).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerBillRespVo.class);
    }
}

