/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.pricesetting.mapper.MdmPriceConditionTypeRelGroupMapper;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeRelGroupEntity;
import com.biz.crm.pricesetting.service.MdmPriceConditionGroupRelFieldService;
import com.biz.crm.pricesetting.service.MdmPriceConditionTypeRelGroupService;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPriceConditionTypeRelGroupServiceExpandImpl"})
public class MdmPriceConditionTypeRelGroupServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPriceConditionTypeRelGroupMapper, MdmPriceConditionTypeRelGroupEntity>
implements MdmPriceConditionTypeRelGroupService {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceConditionTypeRelGroupServiceImpl.class);
    @Resource
    private MdmPriceConditionGroupRelFieldService mdmPriceConditionGroupRelFieldService;

    @Override
    public Map<String, List<String>> groupPriorityList(List<String> conditionTypeCodeList) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (CollectionUtils.isEmpty(conditionTypeCodeList)) {
            return map;
        }
        List groupEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, conditionTypeCodeList)).list();
        log.info("\u6839\u636e\u5b57\u6bb5\u7c7b\u578b\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u6240\u6709\u6761\u4ef6\u5206\u7c7b:{}", (Object)groupEntities);
        if (CollectionUtils.isEmpty((Collection)groupEntities)) {
            return map;
        }
        Map<String, MdmPriceConditionTypeRelGroupEntity> priorityGroupMap = groupEntities.stream().collect(Collectors.toMap(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, Function.identity(), BinaryOperator.minBy(Comparator.comparing(k -> Optional.ofNullable(k).map(MdmPriceConditionTypeRelGroupEntity::getSortNum).orElse(100)))));
        log.info("\u8f6c\u6362\u9ad8\u4f18\u5148\u7ea7\u5206\u7c7b:{}", priorityGroupMap);
        Collection<MdmPriceConditionTypeRelGroupEntity> priorityGroups = priorityGroupMap.values();
        if (CollectionUtils.isEmpty(priorityGroups)) {
            return map;
        }
        List<String> groupList = priorityGroups.stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getConditionGroupCode())).map(MdmPriceConditionTypeRelGroupEntity::getConditionGroupCode).collect(Collectors.toList());
        Map<String, List<MdmPriceConditionGroupRelFieldRespVo>> groupFieldMap = this.mdmPriceConditionGroupRelFieldService.getRelFieldGroupByGroupCodeList(groupList);
        if (ObjectUtils.isEmpty(groupFieldMap)) {
            return map;
        }
        log.info("\u6839\u636e\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5206\u7c7b\u5b57\u6bb5\u5206\u7ec4:{}", groupFieldMap);
        for (MdmPriceConditionTypeRelGroupEntity priorityGroup : priorityGroups) {
            List<MdmPriceConditionGroupRelFieldRespVo> groupFields;
            String conditionGroupCode = priorityGroup.getConditionGroupCode();
            String conditionTypeCode = priorityGroup.getConditionTypeCode();
            if (StringUtils.isEmpty((Object)conditionGroupCode) || StringUtils.isEmpty((Object)conditionTypeCode) || CollectionUtils.isEmpty(groupFields = groupFieldMap.get(conditionGroupCode))) continue;
            List fieldList = groupFields.stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFieldCode())).map(MdmPriceConditionGroupRelFieldRespVo::getFieldCode).collect(Collectors.toList());
            map.put(conditionTypeCode, fieldList);
        }
        return map;
    }
}

