/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmDirectSystemService;
import com.biz.crm.nebular.mdm.kms.MdmDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.api.KmsDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDirectSystemServiceExpandImpl"})
public class MdmDirectSystemServiceImpl
implements MdmDirectSystemService {
    @Autowired
    private KmsProperties kmsProperties;

    @Override
    public List<MdmDirectSystemVo> directSystemSelect(MdmDirectSystemVo mdmDirectSystemVo) {
        ParameterizedTypeReference<KmsResult<List<KmsDirectSystemVo>>> reference;
        String url = this.kmsProperties.getUrl() + "/directSystemController/findDirectSystemListWithNum";
        ResponseEntity exchange = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)this.kmsProperties, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResult<List<KmsDirectSystemVo>>>(){}));
        List<KmsDirectSystemVo> kmsDirectSystemVos = Optional.ofNullable(exchange).map(HttpEntity::getBody).map(KmsResult::getData).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsDirectSystemVos)) {
            return Collections.emptyList();
        }
        String directSystemName = mdmDirectSystemVo.getDirectSystemName();
        kmsDirectSystemVos = kmsDirectSystemVos.stream().filter(x -> StringUtils.isEmpty((Object)directSystemName) || directSystemName.contains(x.getDirectSystemName())).collect(Collectors.toList());
        return KmsConverter.INSTANCE.directSystem2Mdm(kmsDirectSystemVos);
    }

    @Override
    public void enable(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String url = this.kmsProperties.getUrl() + "/directSystemController/stopOrUse";
        for (String id : ids) {
            KmsDirectSystemVo kmsDirectSystemVo = new KmsDirectSystemVo();
            kmsDirectSystemVo.setDirectSystemId(id);
            kmsDirectSystemVo.setComomStatus("ENABLE");
            kmsDirectSystemVo.setTenantryId(this.kmsProperties.getTenantryId());
            kmsDirectSystemVo.setUserId(this.kmsProperties.getUserId());
            ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsDirectSystemVo, Object.class);
            if (HttpStatus.OK.equals((Object)entity.getStatusCode())) continue;
            throw new BusinessException("\u542f\u7528\u5931\u8d25");
        }
    }

    @Override
    public void disable(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String url = this.kmsProperties.getUrl() + "/directSystemController/stopOrUse";
        for (String id : ids) {
            KmsDirectSystemVo kmsDirectSystemVo = new KmsDirectSystemVo();
            kmsDirectSystemVo.setDirectSystemId(id);
            kmsDirectSystemVo.setComomStatus("DISABLE");
            kmsDirectSystemVo.setTenantryId(this.kmsProperties.getTenantryId());
            kmsDirectSystemVo.setUserId(this.kmsProperties.getUserId());
            ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsDirectSystemVo, Object.class);
            if (HttpStatus.OK.equals((Object)entity.getStatusCode())) continue;
            throw new BusinessException("\u7981\u7528\u5931\u8d25");
        }
    }
}

