/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationCustomerPageRespVo;
import com.biz.crm.position.mapper.MdmPositionRelationCustomerMapper;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionRelationCustomerService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmPositionRelationCustomerServiceImpl
implements MdmPositionRelationCustomerService {
    @Resource
    private MdmPositionRelationCustomerMapper mdmPositionRelationCustomerMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmCustomerSupplyService mdmCustomerSupplyService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;

    @Override
    public PageResult<MdmPositionRelationCustomerPageRespVo> findCustomerNotRelateAnyPosition(MdmPositionRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPositionRelationCustomerPageRespVo> list = this.mdmPositionRelationCustomerMapper.findCustomerNotRelateAnyPosition((Page<MdmPositionRelationCustomerPageRespVo>)page, reqVo);
        this.setOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmPositionRelationCustomerPageRespVo> findCustomerNotRelateCurPosition(MdmPositionRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        List<MdmPositionRelationCustomerPageRespVo> list = this.mdmPositionRelationCustomerMapper.findCustomerNotRelateCurPosition((Page<MdmPositionRelationCustomerPageRespVo>)page, reqVo);
        this.setOrgName(list);
        this.setPositionCodeName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmPositionRelationCustomerPageRespVo> findCustomerHasRelateCurPosition(MdmPositionRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPositionRelationCustomerPageRespVo> list = this.mdmPositionRelationCustomerMapper.findCustomerHasRelateCurPosition((Page<MdmPositionRelationCustomerPageRespVo>)page, reqVo);
        this.setOrgName(list);
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindRelation(List<String> customerCodeList, String positionCode) {
        Assert.notEmpty(customerCodeList, (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmPositionEntity position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{MdmPositionEntity::getPositionCode}).one());
        Assert.notNull((Object)((Object)position), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        customerCodeList.forEach(customerCode -> this.mdmCustomerSupplyService.addRelation((String)customerCode, position.getPositionCode(), position.getOrgCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceCustomerPosition(List<String> ids, String positionCode) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931id");
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmPositionEntity position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{MdmPositionEntity::getPositionCode}).one());
        Assert.notNull((Object)((Object)position), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        this.mdmCustomerSupplyService.replacePosition(ids, positionCode, position.getOrgCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindRelation(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931id");
        this.mdmCustomerSupplyService.removeRelations(ids);
    }

    private void setOrgName(List<MdmPositionRelationCustomerPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        Map<String, List<MdmOrgRespVo>> map = this.mdmCustomerROrgService.findOrgGroupByCustomerCodeList(list.stream().map(MdmPositionRelationCustomerPageRespVo::getCustomerCode).collect(Collectors.toList()));
        list.forEach(item -> {
            if (map.containsKey(item.getCustomerCode())) {
                List orgList = (List)map.get(item.getCustomerCode());
                item.setOrgName(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(",")));
            }
        });
    }

    private void setPositionCodeName(List<MdmPositionRelationCustomerPageRespVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List positionList;
            List terminalCodeList = list.stream().map(MdmPositionRelationCustomerPageRespVo::getCustomerCode).collect(Collectors.toList());
            List terminalSupplyList = ((LambdaQueryChainWrapper)this.mdmCustomerSupplyService.lambdaQuery().in(MdmCustomerSupplyEntity::getCustomerCode, terminalCodeList)).select(new SFunction[]{MdmCustomerSupplyEntity::getCustomerCode, MdmCustomerSupplyEntity::getPositionCode}).list();
            List positionCodeList = terminalSupplyList.stream().map(MdmCustomerSupplyEntity::getPositionCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName}).list()))) {
                Map<String, MdmPositionEntity> positionMap = positionList.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
                Map collect = terminalSupplyList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionCode())).collect(Collectors.groupingBy(MdmCustomerSupplyEntity::getCustomerCode, Collectors.mapping(MdmCustomerSupplyEntity::getPositionCode, Collectors.toList())));
                list.forEach(item -> {
                    if (collect.containsKey(item.getCustomerCode())) {
                        List positionCodeListInThisCustomer = (List)collect.get(item.getCustomerCode());
                        ArrayList positionListInThisCustomer = new ArrayList();
                        for (String positionCode : positionCodeListInThisCustomer) {
                            if (!positionMap.containsKey(positionCode)) continue;
                            positionListInThisCustomer.add(positionMap.get(positionCode));
                        }
                        item.setPositionCode(positionListInThisCustomer.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.joining(",")));
                        item.setPositionName(positionListInThisCustomer.stream().map(MdmPositionEntity::getPositionName).collect(Collectors.joining(",")));
                    }
                });
            }
        }
    }
}

