/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.productlevel.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.service.MdmMaterialService;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelReloadRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.productlevel.mapper.MdmProductLevelMapper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.ProductLevelUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmProductLevelServiceExpandImpl"})
public class MdmProductLevelServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmProductLevelMapper, MdmProductLevelEntity>
implements MdmProductLevelService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelServiceImpl.class);
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;
    @Resource
    private MdmMaterialService mdmMaterialService;

    @Override
    public PageResult<MdmProductLevelRespVo> findList(MdmProductLevelReqVo mdmProductLevelReqVo) {
        MdmProductLevelEntity one;
        Page page = PageUtil.buildPage((Integer)mdmProductLevelReqVo.getPageNum(), (Integer)mdmProductLevelReqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)mdmProductLevelReqVo.getCode()) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)mdmProductLevelReqVo.getCode())).one())) != null) {
            mdmProductLevelReqVo.setRuleCode(one.getRuleCode());
        }
        ArrayList<String> productLevelTypeSort = new ArrayList<String>();
        List productLevelTypeList = DictUtil.list((String)"mdm_product_level_type");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)productLevelTypeList)) {
            productLevelTypeSort.addAll(productLevelTypeList.stream().map(DictDataVo::getDictCode).collect(Collectors.toList()));
        }
        List<MdmProductLevelRespVo> list = this.mdmProductLevelMapper.findList((Page<MdmProductLevelRespVo>)page, mdmProductLevelReqVo, productLevelTypeSort);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmProductLevelRespVo detail(String id, String productLevelCode) {
        MdmProductLevelEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)productLevelCode)) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).one())) != null) {
            MdmProductLevelEntity parent;
            MdmProductLevelRespVo respVo = (MdmProductLevelRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmProductLevelRespVo.class);
            if (StringUtils.isNotEmpty((String)one.getParentCode()) && (parent = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)one.getParentCode())).select(new SFunction[]{MdmProductLevelEntity::getProductLevelName}).one())) != null) {
                respVo.setParentName(parent.getProductLevelName());
            }
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductLevelReqVo mdmProductLevelReqVo) {
        Assert.notNull((Object)mdmProductLevelReqVo, (String)"\u7a7a\u53c2\u6570");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)mdmProductLevelReqVo.getProductLevelCode())) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)mdmProductLevelReqVo.getProductLevelCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)("\u7f16\u7801[" + mdmProductLevelReqVo.getProductLevelCode() + "]\u5df2\u5b58\u5728"));
        } else {
            mdmProductLevelReqVo.setProductLevelCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_PRODUCT_LEVEL_CODE.getCode()));
        }
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)mdmProductLevelReqVo.getParentCode())) {
            MdmProductLevelRespVo parent = this.detail(null, mdmProductLevelReqVo.getParentCode());
            Assert.notNull((Object)parent, (String)"\u4e0a\u7ea7\u7f16\u7801\u65e0\u6548");
            levelNum = parent.getLevelNum() + 1;
        }
        MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)CrmBeanUtil.copy((Object)mdmProductLevelReqVo, MdmProductLevelEntity.class));
        entity.setRuleCode(this.generateRuleCodeByParentCode(entity.getParentCode()));
        entity.setLevelNum(levelNum);
        this.save((Object)entity);
        ProductLevelUtil.deleteAllCache();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductLevelReqVo mdmProductLevelReqVo) {
        Assert.notNull((Object)mdmProductLevelReqVo, (String)"\u7a7a\u53c2\u6570");
        Assert.hasText((String)mdmProductLevelReqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelCode(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)this.getById((Serializable)((Object)mdmProductLevelReqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
        Assert.isTrue((boolean)entity.getProductLevelCode().equals(mdmProductLevelReqVo.getProductLevelCode()), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)mdmProductLevelReqVo.getParentCode())) {
            MdmProductLevelEntity parent = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)mdmProductLevelReqVo.getParentCode())).select(new SFunction[]{BaseIdEntity::getId, MdmProductLevelEntity::getProductLevelCode, CrmTreeEntity::getRuleCode, CrmTreeEntity::getLevelNum}).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728");
            Assert.isTrue((!parent.getId().equals(entity.getId()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u662f\u81ea\u5df1");
            Assert.isTrue((!parent.getRuleCode().startsWith(entity.getRuleCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u662f\u5f53\u524d\u5c42\u7ea7\u7684\u4e0b\u7ea7");
            levelNum = parent.getLevelNum() + 1;
        }
        boolean updateRuleCode = false;
        String enableStatusChangeTo = "";
        if (!(entity.getParentCode() == null ? "" : entity.getParentCode()).equals(mdmProductLevelReqVo.getParentCode() == null ? "" : mdmProductLevelReqVo.getParentCode())) {
            updateRuleCode = true;
        }
        if (!entity.getEnableStatus().equals(mdmProductLevelReqVo.getEnableStatus())) {
            enableStatusChangeTo = mdmProductLevelReqVo.getEnableStatus();
        }
        CrmBeanUtil.copyProperties((Object)mdmProductLevelReqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        if (updateRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(entity.getParentCode());
            this.updateCurAndChildren(entity.getProductLevelCode(), ruleCode, levelNum);
        }
        if (StringUtils.isNotEmpty((String)enableStatusChangeTo)) {
            if (CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatusChangeTo)) {
                this.enableBatch(Collections.singletonList(entity.getId()));
            } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(enableStatusChangeTo)) {
                this.disableBatch(Collections.singletonList(entity.getId()));
            } else {
                throw new BusinessException("\u542f\u7528\u72b6\u6001\u9519\u8bef");
            }
        }
        ProductLevelUtil.deleteAllCache();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u53c2\u6570\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId, MdmProductLevelEntity::getProductLevelCode}).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684\u53c2\u6570");
        List productLevelCodeList = list.stream().map(MdmProductLevelEntity::getProductLevelCode).collect(Collectors.toList());
        List childrenList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmProductLevelEntity::getParentCode, productLevelCodeList)).notIn(BaseIdEntity::getId, ids)).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)childrenList), (String)"\u5f53\u524d\u4ea7\u54c1\u5c42\u7ea7\u5305\u542b\u5b50\u5c42\u7ea7\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5b50\u5c42\u7ea7");
        List materialList = ((LambdaQueryChainWrapper)this.mdmMaterialService.lambdaQuery().in(MdmMaterialEntity::getProductLevelCode, productLevelCodeList)).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)materialList), (String)"\u5f53\u524d\u4ea7\u54c1\u5c42\u7ea7\u5df2\u5173\u8054\u7269\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5173\u8054\u7269\u6599");
        this.removeByIds(ids);
        ProductLevelUtil.deleteAllCache();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, CrmTreeEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List collect = list.stream().map(CrmTreeEntity::getRuleCode).collect(Collectors.toList());
            Set parentRuleCodesExcludeSelf = TreeRuleCodeUtil.splitParentRuleCodesExcludeAnySelf(collect);
            if (!parentRuleCodesExcludeSelf.isEmpty()) {
                List parentList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeEntity::getRuleCode, (Collection)parentRuleCodesExcludeSelf)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
                Assert.isTrue((boolean)CollectionUtil.listEmpty((List)parentList), (String)"\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u5c42\u7ea7\uff0c\u4e0d\u80fd\u542f\u7528\u5f53\u524d\u5c42\u7ea7");
            }
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
            ProductLevelUtil.deleteAllCache();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List<String> collect;
        List<MdmProductLevelRespVo> childrenByRuleCodeList;
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{CrmTreeEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list) && CollectionUtil.listNotEmptyNotSizeZero(childrenByRuleCodeList = this.mdmProductLevelMapper.findChildrenByRuleCodeList(collect = list.stream().map(item -> item.getRuleCode() + "%").collect(Collectors.toList()), CrmEnableStatusEnum.ENABLE.getCode()))) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmProductLevelEntity::getProductLevelCode, (Collection)childrenByRuleCodeList.stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList()))).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
            ProductLevelUtil.deleteAllCache();
        }
    }

    @Override
    public List<String> getCurrentAndSubLevelCode(String productLevelCode) {
        List<MdmProductLevelRespVo> childrenList;
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)productLevelCode) && CollectionUtil.listNotEmptyNotSizeZero(childrenList = this.getChildrenList(null, productLevelCode))) {
            list.addAll(childrenList.stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    public void resetRuleCode() {
        long l = System.currentTimeMillis();
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801_" + l + "_\u5f00\u59cb-----------");
        this.mdmProductLevelMapper.copyIdToRuleCode();
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f-----------");
        this.mdmProductLevelMapper.setNullNotExistParentCode();
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801_" + l + "_\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f-----------");
        List topList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmProductLevelEntity::getParentCode)).or()).eq(MdmProductLevelEntity::getParentCode, (Object)"")).list();
        for (int i = 0; i < topList.size(); ++i) {
            this.updateCurAndChildren(((MdmProductLevelEntity)((Object)topList.get(i))).getProductLevelCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
        }
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f16\u7801\u91cd\u65b0\u751f\u6210\u6210\u529f-----------");
        ProductLevelUtil.deleteAllCache();
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f13\u5b58\u6e05\u9664\u6210\u529f-----------");
        log.info("-----------\u91cd\u7f6e\u4ea7\u54c1\u5c42\u7ea7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7ed3\u675f-----------");
    }

    @Override
    public List<MdmProductLevelRespVo> getParentList(String id, String productLevelCode) {
        List parentList;
        Set parentRuleCodes;
        MdmProductLevelEntity one;
        ArrayList<MdmProductLevelRespVo> list = new ArrayList<MdmProductLevelRespVo>();
        if (StringUtils.isEmpty((String)id) && StringUtils.isEmpty((String)productLevelCode) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).one())) != null && !(parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes((String)one.getRuleCode())).isEmpty() && CollectionUtil.listNotEmptyNotSizeZero((List)(parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeEntity::getRuleCode, (Collection)parentRuleCodes)).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)parentList, MdmProductLevelRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmProductLevelRespVo> getChildrenList(String id, String productLevelCode) {
        List children;
        MdmProductLevelEntity one;
        ArrayList<MdmProductLevelRespVo> list = new ArrayList<MdmProductLevelRespVo>();
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)productLevelCode)) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).one())) != null && CollectionUtil.listNotEmptyNotSizeZero((List)(children = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeEntity::getRuleCode, (Object)one.getRuleCode())).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)children, MdmProductLevelRespVo.class));
        }
        return list;
    }

    @Override
    public List<String> getAllChildrenProductLevelCodeList(String id, String productLevelCode) {
        List list;
        MdmProductLevelEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)productLevelCode)) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one())) != null && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeEntity::getRuleCode, (Object)one.getRuleCode())).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode}).list()))) {
            return list.stream().map(MdmProductLevelEntity::getProductLevelCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<MdmProductLevelSelectRespVo> productLevelSelectList(MdmProductLevelSelectReqVo reqVo) {
        MdmProductLevelEntity one;
        ArrayList<MdmProductLevelSelectRespVo> list = new ArrayList<MdmProductLevelSelectRespVo>();
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        String underThisRuleCode = null;
        String notUnderThisRuleCode = null;
        if (StringUtils.isNotEmpty((String)reqVo.getUnderProductLevelCode()) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)reqVo.getUnderProductLevelCode())).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one())) != null) {
            underThisRuleCode = one.getRuleCode();
        }
        if (StringUtils.isNotEmpty((String)reqVo.getNotUnderProductLevelCode()) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)reqVo.getNotUnderProductLevelCode())).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one())) != null) {
            notUnderThisRuleCode = one.getRuleCode();
        }
        HashSet<String> codeList = new HashSet<String>(16);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmProductLevelMapper.findProductLevelSelectList((Page<MdmProductLevelSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, underThisRuleCode, notUnderThisRuleCode));
        }
        return list;
    }

    @Override
    public List<MdmProductLevelRedisVo> findRedisListByProductLevelCodeList(List<String> productLevelCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(productLevelCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmProductLevelEntity::getProductLevelCode, productLevelCodeList)).list()))) {
            List parentCodeNameList;
            HashMap<String, String> codeNameMap = new HashMap<String, String>(16);
            Set parentCodeSet = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode())).map(MdmProductLevelEntity::getParentCode).collect(Collectors.toSet());
            if (!parentCodeSet.isEmpty() && CollectionUtil.listNotEmptyNotSizeZero((List)(parentCodeNameList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmProductLevelEntity::getProductLevelCode, parentCodeSet)).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName}).list()))) {
                codeNameMap.putAll(parentCodeNameList.stream().collect(Collectors.toMap(MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName)));
            }
            return list.stream().map(item -> {
                MdmProductLevelRedisVo copy = (MdmProductLevelRedisVo)CrmBeanUtil.copy((Object)item, MdmProductLevelRedisVo.class);
                if (codeNameMap.containsKey(copy.getProductLevelCode())) {
                    copy.setProductLevelName((String)codeNameMap.get(copy.getProductLevelCode()));
                }
                return copy;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<MdmProductLevelParentChildrenRedisVo> findRedisProductLevelParentListByCodeList(List<String> productLevelCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(productLevelCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmProductLevelEntity::getProductLevelCode, productLevelCodeList)).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode, CrmTreeEntity::getRuleCode}).list()))) {
            Set parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(CrmTreeEntity::getRuleCode).collect(Collectors.toList()));
            List parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeEntity::getRuleCode, (Collection)parentRuleCodes)).list();
            Set collect = parentList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode())).map(MdmProductLevelEntity::getParentCode).collect(Collectors.toSet());
            HashMap<String, String> parentProductLevelCodeNameMap = new HashMap<String, String>(16);
            if (!collect.isEmpty()) {
                parentProductLevelCodeNameMap.putAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmProductLevelEntity::getProductLevelCode, collect)).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName}).list().stream().collect(Collectors.toMap(MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName)));
            }
            List parentRedisVoList = parentList.stream().map(item -> {
                MdmProductLevelRedisVo copy = (MdmProductLevelRedisVo)CrmBeanUtil.copy((Object)item, MdmProductLevelRedisVo.class);
                if (StringUtils.isNotEmpty((String)copy.getParentCode()) && parentProductLevelCodeNameMap.containsKey(copy.getParentCode())) {
                    copy.setParentName((String)parentProductLevelCodeNameMap.get(copy.getParentCode()));
                }
                return copy;
            }).collect(Collectors.toList());
            ArrayList<MdmProductLevelParentChildrenRedisVo> result = new ArrayList<MdmProductLevelParentChildrenRedisVo>();
            for (MdmProductLevelEntity item2 : parentList) {
                MdmProductLevelParentChildrenRedisVo redisVo = new MdmProductLevelParentChildrenRedisVo();
                redisVo.setProductLevelCode(item2.getProductLevelCode());
                redisVo.setList(parentRedisVoList.stream().filter(x -> item2.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
                result.add(redisVo);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MdmProductLevelParentChildrenRedisVo> findRedisProductLevelChildrenListByCodeList(List<String> productLevelCodeList) {
        List<String> likeRightRuleCodeList;
        List<MdmProductLevelRespVo> childrenList;
        List productLevelList;
        if (CollectionUtil.listNotEmptyNotSizeZero(productLevelCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(productLevelList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmProductLevelEntity::getProductLevelCode, productLevelCodeList)).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode, CrmTreeEntity::getRuleCode}).list())) && CollectionUtil.listNotEmptyNotSizeZero(childrenList = this.mdmProductLevelMapper.findChildrenByRuleCodeList(likeRightRuleCodeList = productLevelList.stream().map(item -> item.getRuleCode() + "%").collect(Collectors.toList()), null))) {
            List redisList = CrmBeanUtil.copyList(childrenList, MdmProductLevelRedisVo.class);
            ArrayList<MdmProductLevelParentChildrenRedisVo> resultList = new ArrayList<MdmProductLevelParentChildrenRedisVo>();
            for (MdmProductLevelEntity item2 : productLevelList) {
                MdmProductLevelParentChildrenRedisVo redisVo = new MdmProductLevelParentChildrenRedisVo();
                redisVo.setProductLevelCode(item2.getProductLevelCode());
                redisVo.setList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item2.getRuleCode())).collect(Collectors.toList()));
                resultList.add(redisVo);
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MdmProductLevelReloadRedisVo> findRedisReloadList() {
        List all = this.lambdaQuery().list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)all)) {
            Map<String, String> productLevelCodeNameMap = all.stream().collect(Collectors.toMap(MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName));
            List redisList = all.stream().map(item -> {
                MdmProductLevelRedisVo copy = (MdmProductLevelRedisVo)CrmBeanUtil.copy((Object)item, MdmProductLevelRedisVo.class);
                if (StringUtils.isNotEmpty((String)copy.getParentCode())) {
                    copy.setParentName((String)productLevelCodeNameMap.get(copy.getParentCode()));
                }
                return copy;
            }).collect(Collectors.toList());
            return redisList.stream().map(item -> {
                MdmProductLevelReloadRedisVo redisVo = new MdmProductLevelReloadRedisVo();
                redisVo.setProductLevelCode(item.getProductLevelCode());
                redisVo.setSelf(item);
                redisVo.setParentList(redisList.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
                redisVo.setChildrenList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item.getRuleCode())).collect(Collectors.toList()));
                return redisVo;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void updateCurAndChildren(String productLevelCode, String ruleCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).set(CrmTreeEntity::getRuleCode, (Object)ruleCode)).set(CrmTreeEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentCode, (Object)productLevelCode)).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmProductLevelEntity)((Object)list.get(i))).getProductLevelCode(), ruleCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }

    private String generateRuleCodeByParentCode(String parentCode) {
        MdmProductLevelEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((String)parentCode) && (parent = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)parentCode)).one())) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmProductLevelEntity::getParentCode)).or()).eq(MdmProductLevelEntity::getParentCode, (Object)"")).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentCode, (Object)parentCode)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmProductLevelEntity item : list) {
                if (!StringUtils.isNotEmpty((String)item.getRuleCode())) continue;
                Integer integer = Integer.valueOf(item.getRuleCode().substring(item.getRuleCode().length() - 3));
                set.add(integer);
            }
            for (int i = 1; i <= TreeRuleCodeUtil.getMaxRuleCodeValueInLevel(); ++i) {
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)i);
                break;
            }
        }
        return ruleCode;
    }
}

