/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.TrueOrFalseEnum;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigBatchReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.tableconfig.manager.MdmColumnConfigConverter;
import com.biz.crm.tableconfig.mapper.MdmColumnConfigMapper;
import com.biz.crm.tableconfig.model.MdmColumnConfigEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.cache.TableConfigUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmColumnConfigServiceExpandImpl"})
public class MdmColumnConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmColumnConfigMapper, MdmColumnConfigEntity>
implements IMdmColumnConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdmColumnConfigServiceImpl.class);
    @Resource
    private MdmColumnConfigMapper mdmColumnConfigMapper;
    @Resource
    private MdmFunctionService mdmFunctionService;
    @Resource
    private IMdmFunctionSubService mdmFunctionSubService;

    @Override
    public PageResult<MdmColumnConfigRespVo> findList(MdmColumnConfigReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmColumnConfigEntity> list = this.mdmColumnConfigMapper.findList((Page<MdmColumnConfigRespVo>)page, reqVo);
        if (CollectionUtils.isEmpty(list)) {
            return new PageResult(Long.valueOf(0L), Collections.emptyList());
        }
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(MdmColumnConfigConverter.INSTANCE.entity2RespVo(list)).build();
    }

    @Override
    public MdmColumnConfigRespVo query(MdmColumnConfigReqVo reqVo) {
        MdmColumnConfigEntity one = (MdmColumnConfigEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)reqVo.getParentCode()), MdmColumnConfigEntity::getParentCode, (Object)reqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)reqVo.getFunctionCode()), MdmColumnConfigEntity::getFunctionCode, (Object)reqVo.getFunctionCode())).eq(!StringUtils.isEmpty((Object)reqVo.getField()), MdmColumnConfigEntity::getField, (Object)reqVo.getField())).one());
        return MdmColumnConfigConverter.INSTANCE.entity2RespVo(one);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmColumnConfigReqVo reqVo) {
        Assert.hasText((String)reqVo.getParentCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getField(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.validSearch(Collections.singletonList(reqVo));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmColumnConfigEntity::getParentCode, (Object)reqVo.getParentCode())).eq(MdmColumnConfigEntity::getFunctionCode, (Object)reqVo.getFunctionCode())).eq(MdmColumnConfigEntity::getField, (Object)reqVo.getField())).remove();
        reqVo.setId(null);
        this.save((Object)MdmColumnConfigConverter.INSTANCE.reqVo2Entity(reqVo));
        TableConfigUtil.removeListConfig((String)reqVo.getParentCode(), (String)reqVo.getFunctionCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmColumnConfigReqVo reqVo) {
        Assert.hasText((String)reqVo.getParentCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getField(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.validSearch(Collections.singletonList(reqVo));
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmColumnConfigEntity entity = (MdmColumnConfigEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u5b57\u6bb5\u4e0d\u5b58\u5728");
        this.updateById((Object)MdmColumnConfigConverter.INSTANCE.reqVo2Entity(reqVo));
        TableConfigUtil.removeListConfig((String)reqVo.getParentCode(), (String)reqVo.getFunctionCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmColumnConfigReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)reqVo.getIds())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            MdmColumnConfigEntity mdmColumnConfigEntity = (MdmColumnConfigEntity)((Object)list.get(0));
            String parentCode = mdmColumnConfigEntity.getParentCode();
            String functionCode = mdmColumnConfigEntity.getFunctionCode();
            if (!StringUtils.isEmpty((Object)parentCode) && !StringUtils.isEmpty((Object)functionCode)) {
                TableConfigUtil.removeListConfig((String)parentCode, (String)functionCode);
            }
            this.removeByIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmColumnConfigReqVo reqVo) {
        List mdmColumnConfigEntities = this.mdmColumnConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmColumnConfigEntities)) {
            mdmColumnConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmColumnConfigEntities);
        TableConfigUtil.removeAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmColumnConfigReqVo reqVo) {
        List mdmColumnConfigEntities = this.mdmColumnConfigMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmColumnConfigEntities)) {
            mdmColumnConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmColumnConfigEntities);
        TableConfigUtil.removeAll();
    }

    @Override
    public List<MdmColumnConfigRespVo> listCondition(MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        Assert.hasText((String)mdmColumnConfigReqVo.getParentCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmColumnConfigReqVo.getFunctionCode(), (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmColumnConfigEntity::getParentCode, (Object)mdmColumnConfigReqVo.getParentCode())).eq(MdmColumnConfigEntity::getFunctionCode, (Object)mdmColumnConfigReqVo.getFunctionCode())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = list.stream().sorted(Comparator.comparing(x -> Optional.ofNullable(x.getFormorder()).map(Integer::valueOf).orElse(100))).collect(Collectors.toList());
        }
        return MdmColumnConfigConverter.INSTANCE.entity2RespVo(list);
    }

    @Override
    public List<MdmColumnConfigRespVo> columnResolve(String classPath) {
        ArrayList<MdmColumnConfigRespVo> list = new ArrayList<MdmColumnConfigRespVo>();
        for (Class<?> clazz = Class.forName(classPath); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
                if ("formInstanceId".equals(declaredField.getName()) || "serialVersionUID".equals(declaredField.getName())) continue;
                MdmColumnConfigRespVo mdmColumnConfigRespVo = new MdmColumnConfigRespVo();
                mdmColumnConfigRespVo.setField(declaredField.getName());
                mdmColumnConfigRespVo.setVisible(Boolean.valueOf(true));
                ApiModelProperty annotation = declaredField.getAnnotation(ApiModelProperty.class);
                if (annotation != null) {
                    mdmColumnConfigRespVo.setTitle(annotation.value());
                }
                list.add(mdmColumnConfigRespVo);
            }
        }
        return list;
    }

    @Override
    public void addBatch(MdmColumnConfigBatchReqVo mdmColumnConfigBatchReqVo) {
        String parentCode = mdmColumnConfigBatchReqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = mdmColumnConfigBatchReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmColumnConfigVos = mdmColumnConfigBatchReqVo.getMdmColumnConfigVos();
        Assert.notEmpty((Collection)mdmColumnConfigVos, (String)"\u65b0\u589e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.validSearch(mdmColumnConfigVos);
        TableConfigUtil.removeListConfig((String)parentCode, (String)functionCode);
        Integer functionCount = ((LambdaQueryChainWrapper)this.mdmFunctionService.lambdaQuery().eq(MdmFunctionEntity::getFunctionCode, (Object)parentCode)).count();
        Assert.isTrue((functionCount != null && functionCount > 0 ? 1 : 0) != 0, (String)"\u83dc\u5355\u4e0d\u5b58\u5728");
        Integer configCount = ((LambdaQueryChainWrapper)this.mdmFunctionSubService.lambdaQuery().eq(MdmFunctionSubEntity::getFunctionCode, (Object)functionCode)).count();
        Assert.isTrue((configCount != null && configCount > 0 ? 1 : 0) != 0, (String)"\u529f\u80fd\u5217\u8868\u4e0d\u5b58\u5728");
        HashSet<String> set = new HashSet<String>(mdmColumnConfigVos.size());
        for (MdmColumnConfigReqVo mdmColumnConfigVo : mdmColumnConfigVos) {
            Assert.isTrue((boolean)set.add(mdmColumnConfigVo.getField()), (String)("\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5:" + mdmColumnConfigVo.getField()));
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmColumnConfigEntity::getParentCode, (Object)parentCode)).eq(MdmColumnConfigEntity::getFunctionCode, (Object)functionCode)).remove();
        for (MdmColumnConfigReqVo mdmColumnConfigReqVo : mdmColumnConfigVos) {
            String field = mdmColumnConfigReqVo.getField();
            Assert.hasText((String)field, (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            mdmColumnConfigReqVo.setParentCode(parentCode);
            mdmColumnConfigReqVo.setFunctionCode(functionCode);
            MdmColumnConfigEntity entity = MdmColumnConfigConverter.INSTANCE.reqVo2Entity(mdmColumnConfigReqVo);
            entity.setId(null);
            this.save((Object)entity);
        }
    }

    @Override
    public List<MdmColumnExportRespVo> columnSelect(MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        String parentCode = mdmColumnConfigReqVo.getParentCode();
        String functionCode = mdmColumnConfigReqVo.getFunctionCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmColumnConfigEntity::getParentCode, (Object)parentCode)).eq(MdmColumnConfigEntity::getFunctionCode, (Object)functionCode)).eq(!StringUtils.isEmpty((Object)mdmColumnConfigReqVo.getColumnExport()), MdmColumnConfigEntity::getColumnExport, (Object)mdmColumnConfigReqVo.getColumnExport())).select(new SFunction[]{MdmColumnConfigEntity::getField, MdmColumnConfigEntity::getTitle, MdmColumnConfigEntity::getFormorder, MdmColumnConfigEntity::getDictCode, MdmColumnConfigEntity::getColumnExport}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        list.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFormorder()).map(Integer::valueOf).orElse(100)));
        return CrmBeanUtil.copyList((List)list, MdmColumnExportRespVo.class);
    }

    protected void validSearch(List<MdmColumnConfigReqVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (MdmColumnConfigReqVo mdmColumnConfigReqVo : list) {
            if (mdmColumnConfigReqVo == null) continue;
            String search = mdmColumnConfigReqVo.getSearch();
            if (!TrueOrFalseEnum.TRUE.getCode().equalsIgnoreCase(search)) continue;
            Assert.hasText((String)mdmColumnConfigReqVo.getType(), (String)("\u5b57\u6bb5(" + mdmColumnConfigReqVo.getTitle() + ")\u5141\u8bb8\u67e5\u8be2\u9700\u8981\u914d\u7f6e\u63a7\u4ef6\u7c7b\u578b"));
        }
    }
}

