/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdmbuglistmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.mdmbuglistmanagement.mapper.MdmBugListManagementMapper;
import com.biz.crm.mdmbuglistmanagement.model.MdmBugListManagementEntity;
import com.biz.crm.mdmbuglistmanagement.service.IMdmBugListManagementService;
import com.biz.crm.mdmbuglistmanagement.service.impl.BugManagementServiceHelp;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.resp.MdmBugListManagementRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.wx.WxMsgUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmBugListManagementServiceExpandImpl"})
public class MdmBugListManagementServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmBugListManagementMapper, MdmBugListManagementEntity>
implements IMdmBugListManagementService {
    private static final Logger log = LoggerFactory.getLogger(MdmBugListManagementServiceImpl.class);
    @Resource
    private MdmBugListManagementMapper mdmBugListManagementMapper;
    @Autowired
    private BugManagementServiceHelp helpService;

    @Override
    public PageResult<MdmBugListManagementRespVo> findList(MdmBugListManagementReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmBugListManagementRespVo> list = this.mdmBugListManagementMapper.findList((Page<MdmBugListManagementRespVo>)page, reqVo);
        Map<String, String> globalMap = this.getGlobalMap();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> this.helpService.setStatus(globalMap, (MdmBugListManagementRespVo)o));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private Map<String, String> getGlobalMap() {
        HashMap globalMap = Maps.newHashMap();
        globalMap.put(GlobalWhetherEnum.YES.getCode(), GlobalWhetherEnum.YES.getDes());
        globalMap.put(GlobalWhetherEnum.NO.getCode(), GlobalWhetherEnum.NO.getDes());
        return globalMap;
    }

    @Override
    public MdmBugListManagementRespVo query(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            MdmBugListManagementRespVo mdmBugListManagementRespVo = (MdmBugListManagementRespVo)CrmBeanUtil.copy((Object)this.mdmBugListManagementMapper.selectOne((Wrapper)Wrappers.lambdaQuery((Object)((Object)new MdmBugListManagementEntity())).eq(BaseIdEntity::getId, (Object)id)), MdmBugListManagementRespVo.class);
            Map<String, String> globalMap = this.getGlobalMap();
            this.helpService.setStatus(globalMap, mdmBugListManagementRespVo);
            return mdmBugListManagementRespVo;
        }
        return new MdmBugListManagementRespVo();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmBugListManagementReqVo reqVo) {
        this.helpService.checkData(reqVo);
        MdmBugListManagementEntity entity = (MdmBugListManagementEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmBugListManagementEntity.class));
        this.save((Object)entity);
        if (entity.getIsUrgent().equals(GlobalWhetherEnum.YES.getCode())) {
            WxMsgUtil.sendBugMsg((MdmBugListManagementReqVo)reqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmBugListManagementReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        List listManagementEntities = this.mdmBugListManagementMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId()));
        AssertUtils.isTrue((CollectionUtils.size((Object)listManagementEntities) == 1 ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u5f02\u5e38");
        if (StringUtils.equals((CharSequence)((MdmBugListManagementEntity)((Object)listManagementEntities.get(0))).getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
            throw new BusinessException("\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\u7684\u6570\u636e\u4e0d\u53ef\u4fee\u6539");
        }
        this.helpService.checkData(reqVo);
        MdmBugListManagementEntity entity = (MdmBugListManagementEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmBugListManagementEntity.class));
        this.updateById((Object)entity);
        if (entity.getIsUrgent().equals(GlobalWhetherEnum.YES.getCode())) {
            WxMsgUtil.sendBugMsg((MdmBugListManagementReqVo)reqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchBackEndFix(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsBackendFix(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDevTest(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        HashSet canNotUpdateCodes = Sets.newHashSet();
        ArrayList updateEntities = Lists.newArrayList();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsDevTesting(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDevTestPass(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        HashSet canNotUpdateCodes = Sets.newHashSet();
        ArrayList updateEntities = Lists.newArrayList();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsDevPassTest(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchForeEndFix(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsForeEndFix(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchComplete(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsComplete(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
        });
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUatTestPass(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsUatPassTest(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUatTest(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsUatTesting(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchProTest(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsProTesting(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchProTestPass(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsProPassTest(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchBackEndUat(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsBackendArrUat(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchBackEndPro(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsBackendArrPro(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchForeEndUat(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsForeEndArrUat(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchForeEndPro(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsForeEndArrPro(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUrgent(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e");
        List entities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList updateEntities = Lists.newArrayList();
        ArrayList listManagementReqVos = Lists.newArrayList();
        HashSet canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o -> {
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.NO.getCode())) {
                o.setIsUrgent(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
                listManagementReqVos.add(CrmBeanUtil.copy((Object)o, MdmBugListManagementReqVo.class));
            }
            if (StringUtils.equals((CharSequence)o.getIsComplete(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)canNotUpdateCodes)) {
            String splitSetWithComma = StringUtils.join((Iterable)canNotUpdateCodes, (String)"\u3001");
            throw new BusinessException("\u7985\u9053\u53f7: " + splitSetWithComma + ",\u5df2\u7ecf\u53d1\u5e03\u5230\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u4e0d\u53ef\u4fee\u6539");
        }
        this.updateBatchById(updateEntities);
        if (CollectionUtils.isNotEmpty((Collection)listManagementReqVos)) {
            listManagementReqVos.forEach(WxMsgUtil::sendBugMsg);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmBugListManagementReqVo reqVo) {
        List mdmBugListManagementEntities = this.mdmBugListManagementMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmBugListManagementEntities)) {
            mdmBugListManagementEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmBugListManagementEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmBugListManagementReqVo reqVo) {
        List mdmBugListManagementEntities = this.mdmBugListManagementMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmBugListManagementEntities)) {
            mdmBugListManagementEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmBugListManagementEntities);
    }

    @Override
    public void batchDelete(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List listManagementEntities = this.mdmBugListManagementMapper.selectBatchIds(ids);
        ArrayList deleteIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)listManagementEntities)) {
            listManagementEntities.forEach(o -> deleteIds.add(o.getId()));
            this.mdmBugListManagementMapper.deleteBatchIds(deleteIds);
        }
    }
}

