/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.MdmCustomerContactMapper;
import com.biz.crm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.customer.service.MdmCustomerContactService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerContactServiceExpandImpl"})
public class MdmCustomerContactServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerContactMapper, MdmCustomerContactEntity>
implements MdmCustomerContactService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerContactServiceImpl.class);
    private final MdmCustomerContactMapper mdmCustomerContactMapper;

    public MdmCustomerContactServiceImpl(MdmCustomerContactMapper mdmCustomerContactMapper) {
        this.mdmCustomerContactMapper = mdmCustomerContactMapper;
    }

    @Override
    public PageResult<MdmCustomerContactRespVo> findList(MdmCustomerContactReqVo mdmCustomerContactReqVo) {
        Page page = new Page((long)mdmCustomerContactReqVo.getPageNum().intValue(), (long)mdmCustomerContactReqVo.getPageSize().intValue());
        List<MdmCustomerContactRespVo> list = this.mdmCustomerContactMapper.findList((Page<MdmCustomerContactRespVo>)page, mdmCustomerContactReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmCustomerContactRespVo> list(MdmCustomerContactReqVo mdmCustomerContactReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmCustomerContactReqVo.getId()), BaseIdEntity::getId, (Object)mdmCustomerContactReqVo.getId())).eq(!StringUtils.isEmpty((String)mdmCustomerContactReqVo.getCustomerCode()), MdmCustomerContactEntity::getCustomerCode, (Object)mdmCustomerContactReqVo.getCustomerCode())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerContactRespVo.class);
    }

    @Override
    public MdmCustomerContactRespVo query(MdmCustomerContactReqVo mdmCustomerContactReqVo) {
        MdmCustomerContactEntity one = (MdmCustomerContactEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmCustomerContactReqVo.getCustomerCode()), MdmCustomerContactEntity::getCustomerCode, (Object)mdmCustomerContactReqVo.getCustomerCode())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (MdmCustomerContactRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmCustomerContactRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmCustomerContactReqVo mdmCustomerContactReqVo) {
        this.save(CrmBeanUtil.copy((Object)mdmCustomerContactReqVo, MdmCustomerContactEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmCustomerContactReqVo mdmCustomerContactReqVo) {
        this.updateById(CrmBeanUtil.copy((Object)mdmCustomerContactReqVo, MdmCustomerContactEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmCustomerContactReqVo mdmCustomerContactReqVo) {
        this.removeById((Serializable)((Object)mdmCustomerContactReqVo.getId()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmCustomerContactReqVo mdmCustomerContactReqVo) {
        String customerCode = mdmCustomerContactReqVo.getCustomerCode();
        if (!StringUtils.isEmpty((String)customerCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerContactEntity::getCustomerCode, (Object)customerCode)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmCustomerContactReqVo mdmCustomerContactReqVo) {
        String customerCode = mdmCustomerContactReqVo.getCustomerCode();
        if (!StringUtils.isEmpty((String)customerCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerContactEntity::getCustomerCode, (Object)customerCode)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        }
    }

    @Override
    public void setUpContact(List<MdmCustomerContactReqVo> mdmCustomerContactReqVos, String customerCode) {
        Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerContactEntity::getCustomerCode, (Object)customerCode)).remove();
        if (CollectionUtil.listEmpty(mdmCustomerContactReqVos)) {
            return;
        }
        List collect = mdmCustomerContactReqVos.stream().filter(item -> StringUtils.isNotEmpty((String)item.getContactName())).peek(item -> item.setCustomerCode(customerCode)).collect(Collectors.toList());
        if (CollectionUtil.listEmpty(collect)) {
            return;
        }
        long count = collect.stream().filter(x -> x.getContactMain() != null && YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getContactMain())).count();
        Assert.isTrue((count <= 1L ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4fe1\u606f\uff1a\u4e3b\u8054\u7cfb\u4eba\u53ea\u80fd\u6709\u4e00\u4e2a");
        Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4fe1\u606f\uff1a\u4e3b\u8054\u7cfb\u4eba\u5fc5\u987b\u6709\u4e00\u4e2a");
        List mdmCustomerContactEntities = CrmBeanUtil.copyList(collect, MdmCustomerContactEntity.class);
        this.saveBatch(mdmCustomerContactEntities);
    }
}

