/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.login.service.MdmDmsAppLoginService;
import com.biz.crm.login.service.MdmDmsMallLoginService;
import com.biz.crm.login.service.MdmSfaAppLoginService;
import com.biz.crm.login.service.MdmSfaAppletLoginService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/login"})
@Api(tags={"\u767b\u5f55\u63a7\u5236\u5668"})
public class MdmLoginController {
    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;
    @Autowired
    private MdmDmsMallLoginService mdmDmsMallLoginService;
    @Autowired
    private MdmSfaAppletLoginService mdmSfaAppletLoginService;
    @Autowired
    private MdmSfaAppLoginService mdmSfaAppLoginService;
    @Autowired
    private MdmDmsAppLoginService mdmDmsAppLoginService;
    @Autowired
    private RedisService redisService;

    @ApiOperation(value="\u7cfb\u7edf\u767b\u5f55")
    @PostMapping(value={"/system"})
    @CrmLog
    public Result<MdmLoginRespVo> systemLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        return Result.ok((Object)this.mdmSystemLoginService.systemLogin(mdmLoginReqVo));
    }

    @ApiOperation(value="dms\u5546\u57ce\u540e\u53f0\u767b\u5f55")
    @PostMapping(value={"/dms_mall"})
    public Result<MdmLoginRespVo> dmsMallLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        return Result.ok((Object)this.mdmDmsMallLoginService.dmsMallLogin(mdmLoginReqVo));
    }

    @ApiOperation(value="dmsapp\u767b\u5f55")
    @PostMapping(value={"/dms_app"})
    public Result<MdmLoginRespVo> dmsAppLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        return Result.ok((Object)this.mdmDmsAppLoginService.dmsAppLogin(mdmLoginReqVo));
    }

    @ApiOperation(value="sfa\u5c0f\u7a0b\u5e8f\u767b\u5f55")
    @PostMapping(value={"/sfa_applet"})
    public Result<MdmLoginRespVo> sfaAppletLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        return Result.ok((Object)this.mdmSfaAppletLoginService.sfaAppletLogin(mdmLoginReqVo));
    }

    @ApiOperation(value="sfa\u5c0f\u7a0b\u5e8f\u514d\u5bc6\u7801\u767b\u5f55\uff08\u901a\u8fc7openId\uff09")
    @PostMapping(value={"/sfaAppletLoginByOpenId"})
    public Result<MdmLoginRespVo> sfaAppletLoginByOpenId(@RequestBody MdmAppletLoginReqVo reqVo) {
        MdmLoginRespVo mdmLoginRespVo = null;
        try {
            mdmLoginRespVo = this.mdmSfaAppletLoginService.sfaAppletLoginByOpenId(reqVo);
            mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        catch (Exception e) {
            mdmLoginRespVo = new MdmLoginRespVo();
            mdmLoginRespVo.setAppletOpenIdLoginSuccessFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        return Result.ok((Object)mdmLoginRespVo);
    }

    @ApiOperation(value="sfa\u5c0f\u7a0b\u5e8f\u767b\u5f55\u5e76\u7ed1\u5b9a\u5fae\u4fe1")
    @PostMapping(value={"/sfaAppletLoginAndBind"})
    public Result<MdmLoginRespVo> sfaAppletLoginAndBind(@RequestBody MdmAppletLoginReqVo reqVo) {
        return Result.ok((Object)this.mdmSfaAppletLoginService.sfaAppletLoginAndBind(reqVo));
    }

    @ApiOperation(value="sfaapp\u767b\u5f55")
    @PostMapping(value={"/sfa_app"})
    public Result<MdmLoginRespVo> sfaAppLogin(@RequestBody MdmLoginReqVo mdmLoginReqVo) {
        return Result.ok((Object)this.mdmSfaAppLoginService.sfaAppLogin(mdmLoginReqVo));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f")
    @GetMapping(value={"/getNowUser"})
    public Result<UserRedis> getNowUser() {
        Result result = new Result();
        UserRedis userRedis = UserUtils.getUser();
        result.setResult((Object)userRedis);
        return result;
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @GetMapping(value={"/loginOut"})
    public Result loginOut() {
        String token = UserUtils.getToken();
        this.redisService.del(new String[]{token});
        return Result.ok();
    }
}

