/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.model.MdmTerminalROrgEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.terminal.vo.UpdateTerminalCusOrgCodeVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalServiceExpandImpl"})
public class MdmTerminalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalMapper, MdmTerminalEntity>
implements MdmTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalServiceImpl.class);
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;
    @Autowired
    private MdmTerminalContactService mdmTerminalContactService;
    @Autowired
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;
    @Resource
    private MdmTerminalROrgService mdmTerminalROrgService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<MdmTerminalVo> findList(MdmTerminalVo mdmTerminalReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalReqVo.getPageNum(), (Integer)mdmTerminalReqVo.getPageSize());
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getCode())) {
            List<String> orgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, mdmTerminalReqVo.getCode());
            mdmTerminalReqVo.setOrgCodeList(orgCodeList);
        }
        List<MdmTerminalVo> list = this.mdmTerminalMapper.findList((Page<MdmTerminalVo>)page, mdmTerminalReqVo);
        this.setUpOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    protected void setUpOrgName(List<MdmTerminalVo> list) {
        List<String> orgCodeList;
        Map<String, String> orgNameMap;
        Map<String, List<String>> terminalOrgMap;
        List<String> terminalCodeList;
        if (!(CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(terminalCodeList = list.stream().filter(x -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getTerminalCode())).map(MdmTerminalVo::getTerminalCode).collect(Collectors.toList())) || ObjectUtils.isEmpty(terminalOrgMap = this.mdmTerminalROrgService.findOrgCodeList(terminalCodeList)) || ObjectUtils.isEmpty(orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList = terminalOrgMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()))))) {
            for (MdmTerminalVo mdmTerminalVo : list) {
                List<String> currentOrgCodeList = terminalOrgMap.get(mdmTerminalVo.getTerminalCode());
                if (CollectionUtils.isEmpty(currentOrgCodeList)) continue;
                String orgName = currentOrgCodeList.stream().filter(x -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x)).distinct().map(orgNameMap::get).collect(Collectors.joining(","));
                mdmTerminalVo.setOrgName(orgName);
                mdmTerminalVo.setOrgCode(currentOrgCodeList.stream().filter(x -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x)).distinct().collect(Collectors.joining(",")));
            }
        }
    }

    @Override
    public MdmTerminalVo query(String id, String terminalCode) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)id) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)terminalCode)) {
            return null;
        }
        MdmTerminalVo mdmTerminalVo = this.mdmTerminalMapper.query(id, terminalCode);
        if (mdmTerminalVo == null) {
            return null;
        }
        terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Map map = DictUtil.dictMap((String)"terminal_add_section");
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("contact_information"))) {
            mdmTerminalVo.setContacts(this.mdmTerminalContactService.findByTerminalCode(terminalCode));
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("supply_relationship"))) {
            mdmTerminalVo.setSupplys(this.mdmTerminalSupplyService.findByTerminalCode(terminalCode));
        }
        this.setUpOrgName(Collections.singletonList(mdmTerminalVo));
        return mdmTerminalVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(MdmTerminalVo mdmTerminalVo) {
        AssertUtils.isNotEmpty((String)mdmTerminalVo.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmTerminalVo.getTerminalCode())) {
            mdmTerminalVo.setTerminalCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_TERMINAL.getCode()));
        } else {
            Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalVo.getTerminalCode())).count();
            Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)(mdmTerminalVo.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"));
        }
        MdmTerminalEntity entity = (MdmTerminalEntity)((Object)CrmBeanUtil.copy((Object)mdmTerminalVo, MdmTerminalEntity.class));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getActApproveStatus())) {
            entity.setActApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        this.save((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), entity.getId(), null, (Object)entity);
        Map map = DictUtil.dictMap((String)"terminal_add_section");
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("contact_information"))) {
            this.mdmTerminalContactService.setUpContact(mdmTerminalVo);
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("supply_relationship"))) {
            this.mdmTerminalSupplyService.setUpSupply(mdmTerminalVo);
        }
        this.mdmTerminalROrgService.setUpTerminalRelationOrg(mdmTerminalVo);
        this.sendChangeMsg(Collections.singletonList(mdmTerminalVo.getTerminalCode()));
        return mdmTerminalVo.getTerminalCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmTerminalVo mdmTerminalVo) {
        MdmTerminalVo oldObject = this.queryById(mdmTerminalVo);
        String id = mdmTerminalVo.getId();
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmTerminalEntity entity = (MdmTerminalEntity)((Object)this.getById((Serializable)((Object)mdmTerminalVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u7ec8\u7aef\u4e0d\u5b58\u5728");
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)id)).eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)mdmTerminalVo, MdmTerminalEntity.class));
        MdmTerminalVo newObject = this.queryById(mdmTerminalVo);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), mdmTerminalVo.getId(), null, (Object)oldObject, (Object)newObject);
        Map map = DictUtil.dictMap((String)"terminal_add_section");
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("contact_information"))) {
            this.mdmTerminalContactService.setUpContact(mdmTerminalVo);
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("supply_relationship"))) {
            this.mdmTerminalSupplyService.setUpSupply(mdmTerminalVo);
        }
        this.mdmTerminalROrgService.setUpTerminalRelationOrg(mdmTerminalVo);
        this.sendChangeMsg(Collections.singletonList(mdmTerminalVo.getTerminalCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        ArrayList vos = new ArrayList();
        ids.forEach(id -> {
            MdmTerminalVo query = new MdmTerminalVo();
            query.setId(id);
            MdmTerminalVo vo = this.queryById(query);
            vos.add(vo);
        });
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode}).list();
        if (CollectionUtil.listEmpty((List)list)) {
            return;
        }
        List<String> terminalCodes = list.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
        this.mdmTerminalContactService.deleteByCodes(terminalCodes);
        this.mdmTerminalSupplyService.deleteByCodes(terminalCodes);
        ((LambdaUpdateChainWrapper)this.mdmTerminalROrgService.lambdaUpdate().in(MdmTerminalROrgEntity::getTerminalCode, terminalCodes)).remove();
        this.removeByIds(ids);
        this.sendChangeMsg(terminalCodes);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (MdmTerminalVo vo : vos) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), vo.getId(), null, (Object)vo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        ArrayList vos = new ArrayList();
        ids.forEach(id -> {
            MdmTerminalVo query = new MdmTerminalVo();
            query.setId(id);
            MdmTerminalVo vo = this.queryById(query);
            vos.add(vo);
        });
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, MdmTerminalEntity::getTerminalCode}).list();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        this.sendChangeMsg(list.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (MdmTerminalVo vo : vos) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), vo.getId(), null, (Object)vo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        ArrayList vos = new ArrayList();
        ids.forEach(id -> {
            MdmTerminalVo query = new MdmTerminalVo();
            query.setId(id);
            MdmTerminalVo vo = this.queryById(query);
            vos.add(vo);
        });
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        this.sendChangeMsg(list.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (MdmTerminalVo vo : vos) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), vo.getId(), null, (Object)vo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCusOrgCode(UpdateTerminalCusOrgCodeVo vo) {
        if (CollectionUtil.listEmpty(vo.getTerminalCodeList()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vo.getCustomerOrgCode())) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u6216\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, vo.getTerminalCodeList())).select(new SFunction[]{MdmTerminalEntity::getTerminalCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmTerminalEntity::getTerminalCode, vo.getTerminalCodeList())).set(MdmTerminalEntity::getCustomerOrgCode, (Object)vo.getCustomerOrgCode())).update();
        this.sendChangeMsg(list.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtil.listEmpty(list)) {
            return Collections.emptyList();
        }
        List<String> terminalCodeList = this.mdmTerminalROrgService.findTerminalCodeByOrg(list);
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list().stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> findOrgCodeByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtil.listEmpty(terminalCodeList)) {
            return Collections.emptyMap();
        }
        return this.mdmTerminalROrgService.findOrgCodeByTerminalCodeList(terminalCodeList);
    }

    @Override
    public Map<String, List<String>> findOrgCodeListByTerminalCodeList(List<String> terminalCodeList) {
        return this.mdmTerminalROrgService.findOrgCodeList(terminalCodeList);
    }

    @Override
    public List<MdmTerminalVo> findCurrentAndSubTerminalList(List<String> orgCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodes)) {
            List<MdmOrgRespVo> mdmOrgRespVos = this.mdmOrgService.findAllChildrenOrgListByList(null, orgCodes);
            if (CollectionUtil.listNotEmptyNotSizeZero(mdmOrgRespVos)) {
                orgCodes = mdmOrgRespVos.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            }
        } else {
            return new ArrayList<MdmTerminalVo>();
        }
        return this.mdmTerminalMapper.findCurrentAndSubTerminalList(orgCodes);
    }

    @Override
    public List<MdmTerminalVo> listCondition(MdmTerminalVo mdmTerminalReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getId()), BaseIdEntity::getId, (Object)mdmTerminalReqVo.getId())).eq(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmTerminalReqVo.getEnableStatus())).like(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalCode()), MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalReqVo.getTerminalCode())).like(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalName()), MdmTerminalEntity::getTerminalName, (Object)mdmTerminalReqVo.getTerminalName())).in(CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalReqVo.getTerminalCodeList()), MdmTerminalEntity::getTerminalCode, (Collection)mdmTerminalReqVo.getTerminalCodeList())).in(CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalReqVo.getOrgCodeList()), MdmTerminalEntity::getTerminalCode, this.mdmTerminalROrgService.findTerminalCodeByOrg(mdmTerminalReqVo.getOrgCodeList()))).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, MdmTerminalVo.class);
    }

    private void sendChangeMsg(List<String> terminalCodeList) {
        log.info("\u7ec8\u7aef\u53d8\u52a8\u6d88\u606f\u901a\u77e5:{}", terminalCodeList);
        if (CollectionUtil.listEmpty(terminalCodeList)) {
            return;
        }
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(this.topic);
        rocketMQMessageBody.setTag("TERMINAL_AVAILBLELIST_REFRSH");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(terminalCodeList));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public List<MdmTerminalVo> findPositionTerminalList(String posId, String posCode) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)posCode) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)posId)) {
            return new ArrayList<MdmTerminalVo>();
        }
        return this.mdmTerminalMapper.findPositionTerminalList(posId, posCode);
    }

    @Override
    public List<MdmTerminalVo> findCurrentAndSybPositionTerminalList(String posId, String posCode) {
        List<String> positionCodeList = this.mdmPositionService.findAllChildrenPositionCodeList(posId, posCode);
        if (CollectionUtil.listEmpty(positionCodeList)) {
            return new ArrayList<MdmTerminalVo>();
        }
        return this.mdmTerminalMapper.findPositionsTerminalList(positionCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateTerminalOrg(MdmOrgTerminalReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getOriginOrgCode())) {
            this.mdmTerminalROrgService.replaceOrg(reqVo.getTerminalCodeList(), reqVo.getOriginOrgCode(), reqVo.getOrgCode());
        } else {
            this.mdmTerminalROrgService.setUp(reqVo.getTerminalCodeList(), reqVo.getOrgCode());
        }
        this.sendChangeMsg(reqVo.getTerminalCodeList());
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> userTerminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
        String positionCode = mdmTerminalContactPageReqVo.getPositionCode();
        Assert.hasText((String)positionCode, (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmTerminalVo> positionTerminalList = this.findPositionTerminalList(null, positionCode);
        log.info("[\u7ec8\u7aef\u7ba1\u7406][\u7ec8\u7aef\u53ca\u4e3b\u8054\u7cfb\u4eba\u5206\u9875]\u804c\u4f4d\u5173\u8054\u7ec8\u7aef:{}", positionTerminalList);
        if (CollectionUtils.isEmpty(positionTerminalList)) {
            return new PageResult();
        }
        List terminalCodeList = positionTerminalList.stream().map(MdmTerminalVo::getTerminalCode).collect(Collectors.toList());
        mdmTerminalContactPageReqVo.setTerminalCodeList(terminalCodeList);
        Page page = PageUtil.buildPage((Integer)mdmTerminalContactPageReqVo.getPageNum(), (Integer)mdmTerminalContactPageReqVo.getPageSize());
        List<MdmTerminalContactPageVo> list = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmTerminalContactPageReqVo.getLatitude()) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmTerminalContactPageReqVo.getLongitude()) ? this.mdmTerminalMapper.distancePage((Page<MdmTerminalContactPageVo>)page, mdmTerminalContactPageReqVo) : this.mdmTerminalMapper.userTerminalContactPage((Page<MdmTerminalContactPageVo>)page, mdmTerminalContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> terminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalContactPageReqVo.getPageNum(), (Integer)mdmTerminalContactPageReqVo.getPageSize());
        List<MdmTerminalContactPageVo> list = this.mdmTerminalMapper.userTerminalContactPage((Page<MdmTerminalContactPageVo>)page, mdmTerminalContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmOrgRespVo> detailBatch(MdmTerminalVo vo) {
        List<String> orgCodeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(!CollectionUtils.isEmpty((Collection)vo.getTerminalCodeList()), MdmTerminalEntity::getTerminalCode, new Object[]{vo.getTerminalCode()})).like(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vo.getTerminalName()), MdmTerminalEntity::getTerminalName, (Object)vo.getTerminalName())).select(new SFunction[]{MdmTerminalEntity::getOrgCode}).list().stream().filter(x -> x != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getOrgCode())).map(MdmTerminalEntity::getOrgCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return Collections.emptyList();
        }
        return this.mdmOrgService.detailBatch(null, orgCodeList);
    }

    @Override
    public List<MdmTerminalVo> customerTerminalList(MdmCustomerTerminalVo mdmCustomerTerminalVo) {
        Page page = PageUtil.buildPage((Integer)mdmCustomerTerminalVo.getPageNum(), (Integer)mdmCustomerTerminalVo.getPageSize());
        List customerCodeList = mdmCustomerTerminalVo.getCustomerCodeList();
        if (!CollectionUtils.isEmpty((Collection)customerCodeList)) {
            List<String> terminalByCustomer = this.mdmTerminalSupplyService.findTerminalByCustomer(customerCodeList);
            if (CollectionUtils.isEmpty(terminalByCustomer)) {
                return Collections.emptyList();
            }
            mdmCustomerTerminalVo.setTerminalCodeList(terminalByCustomer);
        }
        page.setSearchCount(false);
        return this.mdmTerminalMapper.customerTerminalList((Page<MdmTerminalVo>)page, mdmCustomerTerminalVo);
    }

    @Override
    public Long findPositionRelationTerminalCount(String positionCode) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)positionCode)) {
            return 0L;
        }
        List<MdmPositionRespVo> position = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (CollectionUtils.isEmpty(position)) {
            return 0L;
        }
        List positionCodeList = position.stream().filter(x -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        return ((LambdaQueryChainWrapper)this.mdmTerminalSupplyService.lambdaQuery().in(MdmTerminalSupplyEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmTerminalSupplyEntity::getTerminalCode}).list().stream().filter(x -> x != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getTerminalCode())).distinct().count();
    }

    @Override
    public Long findPositionRelationTerminalCustomerCount(String positionCode) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)positionCode)) {
            return 0L;
        }
        List<MdmPositionRespVo> position = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (CollectionUtils.isEmpty(position)) {
            return 0L;
        }
        List positionCodeList = position.stream().filter(x -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        return ((LambdaQueryChainWrapper)this.mdmTerminalSupplyService.lambdaQuery().in(MdmTerminalSupplyEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmTerminalSupplyEntity::getCustomerCode}).list().stream().filter(x -> x != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getPositionCode())).distinct().count();
    }

    @Override
    public MdmTerminalVo findDetailByRegisterOrName(String licenseRegisterNumber, String terminalName) {
        Assert.isTrue((!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)licenseRegisterNumber) || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)terminalName) ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6ce8\u518c\u53f7\u6216\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmTerminalVo mdmTerminalVo = this.mdmTerminalMapper.findDetailByRegisterOrName(licenseRegisterNumber, terminalName);
        log.info("\u7ec8\u7aef\u4fe1\u606f:{},\u5165\u53c2:{}", (Object)mdmTerminalVo, (Object)(licenseRegisterNumber + ":" + terminalName));
        if (mdmTerminalVo == null) {
            return null;
        }
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmTerminalVo.setContacts(this.mdmTerminalContactService.findByTerminalCode(terminalCode));
        mdmTerminalVo.setSupplys(this.mdmTerminalSupplyService.findByTerminalCode(terminalCode));
        this.setUpOrgName(Collections.singletonList(mdmTerminalVo));
        return mdmTerminalVo;
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> distanceContactPage(MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalDistanceContactPageReqVo.getPageNum(), (Integer)mdmTerminalDistanceContactPageReqVo.getPageSize());
        String terminalScopeType = mdmTerminalDistanceContactPageReqVo.getTerminalScopeType();
        PageResult emptyPage = PageResult.builder().data(Collections.emptyList()).count(Long.valueOf(0L)).build();
        if (!StringUtils.isEmpty((String)terminalScopeType)) {
            String positionCode = Optional.ofNullable(UserUtils.getUser()).filter(x -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getPoscode())).map(UserRedis::getPoscode).orElse(null);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)positionCode)) {
                log.error("\u7528\u6237\u4f1a\u8bdd\u5f02\u5e38:{}", (Object)UserUtils.getUser());
                return emptyPage;
            }
            ArrayList<String> positionCodeList = new ArrayList<String>();
            switch (terminalScopeType) {
                case "1": {
                    List<MdmPositionRespVo> allChildrenPositionList = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
                    log.info("\u5f53\u524d\u53ca\u4e0b\u5c5e\u804c\u4f4d:{}", allChildrenPositionList);
                    if (CollectionUtils.isEmpty(allChildrenPositionList)) break;
                    List collect = allChildrenPositionList.stream().filter(x -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
                    positionCodeList.addAll(collect);
                    break;
                }
                case "2": {
                    positionCodeList.add(positionCode);
                    break;
                }
                case "3": {
                    List<MdmPositionRespVo> childrenPositionList = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
                    log.info("\u5f53\u524d\u53ca\u4e0b\u5c5e\u804c\u4f4d:{}", childrenPositionList);
                    if (CollectionUtils.isEmpty(childrenPositionList)) break;
                    List collect = childrenPositionList.stream().filter(x -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getPositionCode())).filter(x -> !positionCode.equals(x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
                    positionCodeList.addAll(collect);
                    break;
                }
            }
            List<String> terminalCodeList = this.mdmTerminalSupplyService.findTerminalByPositionCodeList(positionCodeList);
            if (CollectionUtils.isEmpty(terminalCodeList)) {
                return emptyPage;
            }
        }
        List<MdmTerminalContactPageVo> list = this.mdmTerminalMapper.distanceContactPage((Page<MdmTerminalContactPageVo>)page, mdmTerminalDistanceContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private MdmTerminalVo queryById(MdmTerminalVo mdmTerminalVo) {
        MdmTerminalVo query = new MdmTerminalVo();
        query.setId(mdmTerminalVo.getId());
        List<MdmTerminalVo> mdmTerminalVos = this.listCondition(query);
        if (mdmTerminalVos.isEmpty()) {
            return new MdmTerminalVo();
        }
        return mdmTerminalVos.get(0);
    }
}

