/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelist.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.annotation.Klock;
import com.biz.crm.availablelist.entity.TerminalAvailablelistEntity;
import com.biz.crm.availablelist.repositories.TerminalAvailablelistRepositories;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.availablelist.utils.TerminalAvailablelistUtil;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.TerminalChangeAdviseTargetStrategy;
import com.biz.crm.availablelistrule.service.AvailableListRuleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.availablelist.TerminalAvailablelistVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.ContextUtil;
import com.biz.crm.util.EsUtil;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"terminalAvailablelistServiceExpandImpl"})
@Service(value="terminalAvailablelistService")
public class TerminalAvailablelistServiceImpl<M extends BaseMapper<T>, T>
implements TerminalAvailablelistService {
    private static final Logger log = LoggerFactory.getLogger(TerminalAvailablelistServiceImpl.class);
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private RedissonUtil redissonUtil;
    @Autowired
    private TerminalAvailablelistRepositories terminalAvailablelistRepositories;
    @Resource
    private MdmTerminalService mdmTerminalService;
    @Resource
    private MdmProductService mdmProductService;
    @Resource
    private AvailableListRuleService availableListRuleService;
    @Resource
    private Advise advise;
    @Resource
    private TerminalChangeAdviseTargetStrategy terminalChangeAdviseTargetStrategy;
    @Autowired
    private ContextUtil contextUtil;
    @Autowired
    private MdmProductLevelService mdmProductLevelService;

    @Override
    public void reFresh(List<MdmProductAdviseRespVo> goods, String terminalCode) {
        ValidateUtils.validate((Object)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        MdmTerminalVo terminalReqVo = this.mdmTerminalService.query(null, terminalCode);
        ValidateUtils.validate((Object)terminalReqVo, (String)("\u8be5\u7ec8\u7aef\u4e0d\u5b58\u5728,\u7ec8\u7aef\u7f16\u7801:" + terminalCode));
        if (EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, TerminalAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            DeleteQuery deleteQuery = new DeleteQuery();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"terminalCode.keyword", (String)terminalCode));
            deleteQuery.setQuery((QueryBuilder)boolQueryBuilder);
            this.elasticsearchTemplate.delete(deleteQuery, TerminalAvailablelistEntity.class);
            this.elasticsearchTemplate.refresh("terminalavailablelistindex");
        }
        if (CollectionUtils.isEmpty(goods)) {
            return;
        }
        this.terminalAvailablelistRepositories.saveAll(TerminalAvailablelistUtil.packageEntities(goods, terminalReqVo));
        this.elasticsearchTemplate.refresh("terminalavailablelistindex");
    }

    @Override
    @Klock(keys={"terminalcusallocal", "#terminalCode"}, waitTime=30L, leaseTime=10L)
    public void reFresh(String terminalCode) {
        Map<String, List<String>> terminalList = this.mdmTerminalService.findOrgCodeListByTerminalCodeList(Lists.newArrayList((Object[])new String[]{terminalCode}));
        if (CollectionUtils.isEmpty(terminalList)) {
            return;
        }
        List<String> goodsCodes = this.availableListRuleService.findGoodsByTerminalCodeAndOrgCode(terminalCode, terminalList.get(terminalCode));
        ArrayList<MdmProductAdviseRespVo> goods = new ArrayList<MdmProductAdviseRespVo>(0);
        if (!CollectionUtils.isEmpty(goodsCodes)) {
            ArrayList<String> currentGoodsCodes = new ArrayList<String>();
            int i = 0;
            for (String goodsCode : goodsCodes) {
                currentGoodsCodes.add(goodsCode);
                if (currentGoodsCodes.size() != 500 && ++i != goodsCodes.size()) continue;
                goods.addAll(this.mdmProductService.adviseQuery(currentGoodsCodes));
                currentGoodsCodes.clear();
            }
        }
        this.reFresh(goods, terminalCode);
    }

    @Override
    public void reFresh(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        TerminalAvailablelistService terminalAvailablelistService = (TerminalAvailablelistService)ContextUtil.getBean(TerminalAvailablelistService.class);
        for (String terminalCode : terminalCodes) {
            try {
                terminalAvailablelistService.reFresh(terminalCode);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5237\u65b0\u5931\u8d25\uff0c\u7ec8\u7aef:" + terminalCode, (Throwable)e);
            }
        }
    }

    @Override
    public void reFreshByProductLevel(List<String> productLevelCode) {
        if (CollectionUtils.isEmpty(productLevelCode)) {
            return;
        }
        List<String> terminalCodes = this.availableListRuleService.listTerminalCodesByProductLevel(productLevelCode);
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        this.reFresh(terminalCodes);
    }

    @Override
    public void updateByGoodsCodes(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos) {
        if (CollectionUtils.isEmpty(mdmProductAdviseRespVos)) {
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, TerminalAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"productCode.keyword", (Collection)mdmProductAdviseRespVos.stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList())));
        TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"terminalCodes").field("terminalCode.keyword")).size(10000);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"terminalavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)0, (int)10)).addAggregation((AbstractAggregationBuilder)aggregationBuilder).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        Aggregation tags = (Aggregation)aggregations.asMap().get("terminalCodes");
        Terms teamSum = (Terms)tags;
        List buckets = teamSum.getBuckets();
        ArrayList<String> terminalCodes = new ArrayList<String>();
        for (Terms.Bucket bucket : buckets) {
            terminalCodes.add(bucket.getKeyAsString());
        }
        TerminalAvailablelistService terminalAvailablelistService = (TerminalAvailablelistService)ContextUtil.getBean(TerminalAvailablelistService.class);
        for (String terminalCode : terminalCodes) {
            try {
                terminalAvailablelistService.updateByGoodsCodesAndTerminalCode(mdmProductAdviseRespVos, terminalCode);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5546\u54c1\u5220\u9664\u5931\u8d25\uff0c\u7ec8\u7aef:" + terminalCode, (Throwable)e);
            }
        }
    }

    @Override
    @Klock(keys={"terminalcusallocal", "#terminalCode"}, waitTime=30L, leaseTime=10L)
    public void updateByGoodsCodesAndTerminalCode(List<MdmProductAdviseRespVo> mdmProductAdviseRespVos, String terminalCode) {
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, TerminalAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        List<TerminalAvailablelistEntity> terminalAvailablelistEntities = this.terminalAvailablelistRepositories.findByTerminalCodeAndProductCodeIn(terminalCode, (mdmProductAdviseRespVos = mdmProductAdviseRespVos.stream().filter(vo -> !StringUtils.isEmpty((Object)vo.getProductCode())).collect(Collectors.toList())).stream().map(MdmProductAdviseRespVo::getProductCode).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(terminalAvailablelistEntities)) {
            return;
        }
        Map<String, MdmProductAdviseRespVo> goodsMap = mdmProductAdviseRespVos.stream().collect(Collectors.toMap(MdmProductAdviseRespVo::getProductCode, a -> a, (k1, k2) -> k1));
        int pageSize = 500;
        int total = terminalAvailablelistEntities.size();
        ArrayList<TerminalAvailablelistEntity> entities = new ArrayList<TerminalAvailablelistEntity>(pageSize);
        for (int i = 0; i < total; ++i) {
            TerminalAvailablelistEntity entity = terminalAvailablelistEntities.get(i);
            MdmProductAdviseRespVo vo2 = goodsMap.get(entity.getProductCode());
            if (null != vo2) {
                entity = TerminalAvailablelistUtil.copyGoodsVo(entity, vo2);
                entities.add(entity);
            }
            if (entities.size() != pageSize && i != total - 1) continue;
            this.terminalAvailablelistRepositories.deleteByIdIn(entities.stream().map(UuidVo::getId).collect(Collectors.toList()));
            this.terminalAvailablelistRepositories.saveAll(entities);
            entities.clear();
        }
        this.elasticsearchTemplate.refresh("terminalavailablelistindex");
    }

    @Override
    public void delByGoodsCodes(List<String> goodsCodes) {
        if (CollectionUtils.isEmpty(goodsCodes)) {
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, TerminalAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"productCode.keyword", goodsCodes));
        TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"terminalCodes").field("terminalCode.keyword")).size(10000);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"terminalavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)0, (int)10)).addAggregation((AbstractAggregationBuilder)aggregationBuilder).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        Aggregation tags = (Aggregation)aggregations.asMap().get("terminalCodes");
        Terms teamSum = (Terms)tags;
        List buckets = teamSum.getBuckets();
        ArrayList<String> terminalCodes = new ArrayList<String>();
        for (Terms.Bucket bucket : buckets) {
            terminalCodes.add(bucket.getKeyAsString());
        }
        TerminalAvailablelistService terminalAvailablelistService = (TerminalAvailablelistService)ContextUtil.getBean(TerminalAvailablelistService.class);
        for (String terminalCode : terminalCodes) {
            try {
                terminalAvailablelistService.delByGoodsCodesAndTerminalCode(goodsCodes, terminalCode);
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5546\u54c1\u5220\u9664\u5931\u8d25\uff0c\u7ec8\u7aef:" + terminalCode, (Throwable)e);
            }
        }
    }

    @Override
    @Klock(keys={"terminalcusallocal", "#terminalCode"}, waitTime=30L, leaseTime=10L)
    public void delByGoodsCodesAndTerminalCode(List<String> goodsCodes, String terminalCode) {
        this.terminalAvailablelistRepositories.deleteByTerminalCodeAndProductCodeIn(terminalCode, goodsCodes);
    }

    @Override
    @CrmDictMethod
    public PageResult<TerminalAvailablelistVo> list(TerminalAvailablelistVo terminalAvailablelistVo) {
        NativeSearchQuery searchQuery;
        AggregatedPage scroll;
        List list;
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, TerminalAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"terminalCode.keyword", (String)terminalAvailablelistVo.getTerminalCode()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalName", (Object)terminalAvailablelistVo.getTerminalName()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalOrgCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"terminalOrgCode.keyword", (String)terminalAvailablelistVo.getTerminalOrgCode()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalOrgName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalOrgName", (Object)terminalAvailablelistVo.getTerminalOrgName()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalChannelCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"terminalChannelCode.keyword", (String)terminalAvailablelistVo.getTerminalChannelCode()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalChannelName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalChannelName", (Object)terminalAvailablelistVo.getTerminalChannelName()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productType.keyword", (String)terminalAvailablelistVo.getProductType()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductLevelCode())) {
            List<String> productLevelCodes = this.mdmProductLevelService.getAllChildrenProductLevelCodeList(null, terminalAvailablelistVo.getProductLevelCode());
            if (CollectionUtils.isEmpty(productLevelCodes)) {
                return pageResult;
            }
            BoolQueryBuilder productLevelCodeBoolQueryBuilder = QueryBuilders.boolQuery();
            for (String productLevelCode : productLevelCodes) {
                productLevelCodeBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"productLevelCode.keyword", (String)productLevelCode));
            }
            boolQueryBuilder.must((QueryBuilder)productLevelCodeBoolQueryBuilder);
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productCode", (Object)terminalAvailablelistVo.getProductCode()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productName", (Object)terminalAvailablelistVo.getProductName()));
        }
        if (CollectionUtils.isEmpty((Collection)(list = (scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)(searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"terminalavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)(terminalAvailablelistVo.getPageNum() - 1), (int)terminalAvailablelistVo.getPageSize())).build()), TerminalAvailablelistEntity.class)).getContent()))) {
            return pageResult;
        }
        ArrayList<TerminalAvailablelistVo> reList = new ArrayList<TerminalAvailablelistVo>(list.size());
        for (TerminalAvailablelistEntity entity : list) {
            TerminalAvailablelistVo vo = new TerminalAvailablelistVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            reList.add(vo);
        }
        pageResult.setData(reList);
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    public PageResult<TerminalAvailablelistVo> listForM(TerminalAvailablelistVo terminalAvailablelistVo) {
        NativeSearchQuery searchQuery;
        AggregatedPage scroll;
        List list;
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, TerminalAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return pageResult;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"terminalCode.keyword", (String)("*" + terminalAvailablelistVo.getTerminalCode() + "*")));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalName", (Object)terminalAvailablelistVo.getTerminalName()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalOrgCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"terminalOrgCode.keyword", (String)("*" + terminalAvailablelistVo.getTerminalOrgCode() + "*")));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalOrgName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalOrgName", (Object)terminalAvailablelistVo.getTerminalOrgName()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalChannelCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"terminalChannelCode.keyword", (String)terminalAvailablelistVo.getTerminalChannelCode()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getTerminalChannelName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"terminalChannelName", (Object)terminalAvailablelistVo.getTerminalChannelName()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"productType.keyword", (String)terminalAvailablelistVo.getProductType()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductLevelCode())) {
            List<String> productLevelCodes = this.mdmProductLevelService.getAllChildrenProductLevelCodeList(null, terminalAvailablelistVo.getProductLevelCode());
            if (CollectionUtils.isEmpty(productLevelCodes)) {
                return pageResult;
            }
            BoolQueryBuilder productLevelCodeBoolQueryBuilder = QueryBuilders.boolQuery();
            for (String productLevelCode : productLevelCodes) {
                productLevelCodeBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"productLevelCode.keyword", (String)productLevelCode));
            }
            boolQueryBuilder.must((QueryBuilder)productLevelCodeBoolQueryBuilder);
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productCode", (Object)terminalAvailablelistVo.getProductCode()));
        }
        if (!StringUtils.isEmpty((Object)terminalAvailablelistVo.getProductName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productName", (Object)terminalAvailablelistVo.getProductName()));
        }
        if (CollectionUtils.isEmpty((Collection)(list = (scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)(searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"terminalavailablelistindex"}).withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)(terminalAvailablelistVo.getPageNum() - 1), (int)terminalAvailablelistVo.getPageSize())).build()), TerminalAvailablelistEntity.class)).getContent()))) {
            return pageResult;
        }
        ArrayList<TerminalAvailablelistVo> reList = new ArrayList<TerminalAvailablelistVo>(list.size());
        for (TerminalAvailablelistEntity entity : list) {
            TerminalAvailablelistVo vo = new TerminalAvailablelistVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            reList.add(vo);
        }
        pageResult.setData(reList);
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    public void delById(String id) {
        if (StringUtils.isEmpty((Object)id)) {
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, TerminalAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        Optional optionalTerminalAvailablelistEntity = this.terminalAvailablelistRepositories.findById(id);
        if (!optionalTerminalAvailablelistEntity.isPresent()) {
            return;
        }
        TerminalAvailablelistService terminalAvailablelistService = (TerminalAvailablelistService)ContextUtil.getBean(TerminalAvailablelistService.class);
        terminalAvailablelistService.delByIdAndTerminalCode(id, ((TerminalAvailablelistEntity)((Object)optionalTerminalAvailablelistEntity.get())).getTerminalCode());
    }

    @Override
    @Klock(keys={"terminalcusallocal", "#terminalCode"}, waitTime=30L, leaseTime=10L)
    public void delByIdAndTerminalCode(String id, String terminalCode) {
        this.terminalAvailablelistRepositories.deleteById(id);
    }

    @Override
    public void delByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (!EsUtil.indexExsit((ElasticsearchTemplate)this.elasticsearchTemplate, TerminalAvailablelistEntity.class, (RedissonUtil)this.redissonUtil)) {
            return;
        }
        List<TerminalAvailablelistEntity> entities = this.terminalAvailablelistRepositories.findByIdIn(ids);
        Map<String, List<TerminalAvailablelistEntity>> entityMap = entities.stream().collect(Collectors.groupingBy(TerminalAvailablelistEntity::getTerminalCode));
        TerminalAvailablelistService terminalAvailablelistService = (TerminalAvailablelistService)ContextUtil.getBean(TerminalAvailablelistService.class);
        for (Map.Entry<String, List<TerminalAvailablelistEntity>> entry : entityMap.entrySet()) {
            List<TerminalAvailablelistEntity> handleEntities = entry.getValue();
            if (CollectionUtils.isEmpty(handleEntities)) continue;
            try {
                terminalAvailablelistService.delByIdsAndTerminalCode(handleEntities.stream().map(UuidVo::getId).collect(Collectors.toList()), entry.getKey());
            }
            catch (Exception e) {
                log.error("\u53ef\u591f\u6e05\u5355\u5220\u9664\u5931\u8d25\uff0c\u7ec8\u7aef:" + entry.getKey(), (Throwable)e);
            }
        }
    }

    @Override
    @Klock(keys={"terminalcusallocal", "#terminalCode"}, waitTime=30L, leaseTime=10L)
    public void delByIdsAndTerminalCode(List<String> ids, String terminalCode) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.terminalAvailablelistRepositories.deleteByIdIn(ids);
    }

    @Override
    public TerminalAvailablelistVo findById(String id) {
        Optional optionalTerminalAvailablelistEntity = this.terminalAvailablelistRepositories.findById(id);
        if (!optionalTerminalAvailablelistEntity.isPresent()) {
            return null;
        }
        TerminalAvailablelistEntity entity = (TerminalAvailablelistEntity)((Object)optionalTerminalAvailablelistEntity.get());
        TerminalAvailablelistVo vo = new TerminalAvailablelistVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }
}

