/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.role.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.button.service.MdmButtonRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.function.service.MdmFunctionRoleService;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionButtonStoreVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionRespVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionTreeVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSelectReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonVo;
import com.biz.crm.nebular.mdm.role.req.MdmSwitchFunctionButtonReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleSelectRespVo;
import com.biz.crm.permission.model.MdmDataPermissionEntity;
import com.biz.crm.permission.service.IMdmDataPermissionService;
import com.biz.crm.position.model.MdmPositionRoleEntity;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.positionlevel.service.MdmPositionLevelRoleService;
import com.biz.crm.role.mapper.MdmRoleMapper;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.cache.TableConfigUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmRoleServiceExpandImpl"})
public class MdmRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmRoleMapper, MdmRoleEntity>
implements MdmRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmRoleServiceImpl.class);
    @Resource
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;
    @Resource
    private MdmPositionLevelRoleService mdmPositionLevelRoleService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmFunctionService mdmFunctionService;
    @Resource
    private IMdmFunctionSubButtonService mdmFunctionSubButtonService;
    @Resource
    private MdmFunctionRoleService mdmFunctionRoleService;
    @Resource
    private MdmButtonRoleService mdmButtonRoleService;
    @Resource
    private IMdmDataPermissionService mdmDataPermissionService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<MdmRoleRespVo> findList(MdmRoleReqVo mdmRoleReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmRoleReqVo.getPageNum(), (Integer)mdmRoleReqVo.getPageSize());
        List<MdmRoleRespVo> list = this.mdmRoleMapper.findList((Page<MdmRoleReqVo>)page, mdmRoleReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmRoleRespVo detail(String id, String roleCode) {
        if (StringUtils.isNotEmpty((CharSequence)id) || StringUtils.isNotEmpty((CharSequence)roleCode)) {
            MdmRoleEntity one = (MdmRoleEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((CharSequence)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((CharSequence)roleCode), MdmRoleEntity::getRoleCode, (Object)roleCode)).one());
            return (MdmRoleRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmRoleRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmRoleReqVo mdmRoleReqVo) {
        mdmRoleReqVo.setId(null);
        if (StringUtils.isBlank((CharSequence)mdmRoleReqVo.getRoleName())) {
            throw new BusinessException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleName, (Object)mdmRoleReqVo.getRoleName())).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        if (StringUtils.isBlank((CharSequence)mdmRoleReqVo.getRoleCode())) {
            mdmRoleReqVo.setRoleCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ROLE_CODE.getCode()));
        } else {
            MdmRoleEntity roleCodeEntity = (MdmRoleEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)mdmRoleReqVo.getRoleCode())).select(new SFunction[]{BaseIdEntity::getId}).last(DatabaseTypeUtil.SEGMENT)).one());
            Assert.isNull((Object)((Object)roleCodeEntity), (String)"\u5f53\u524d\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        this.save(CrmBeanUtil.copy((Object)mdmRoleReqVo, MdmRoleEntity.class));
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            this.crmLogSendUtil.sendForAdd(menuObject.toString(), mdmRoleReqVo.getId(), null, (Object)mdmRoleReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmRoleReqVo mdmRoleReqVo) {
        Object menuObject;
        List positionRoleEntityList;
        String id = mdmRoleReqVo.getId();
        Assert.hasText((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        String roleCode = mdmRoleReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String roleName = mdmRoleReqVo.getRoleName();
        Assert.hasText((String)roleName, (String)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmRoleEntity oldEntity = (MdmRoleEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)oldEntity), (String)"\u672a\u627e\u5230\u89d2\u8272");
        Integer codeCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)id)).eq(MdmRoleEntity::getRoleCode, (Object)roleCode)).count();
        Assert.isTrue((codeCount == null || codeCount < 1 ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
        Integer nameCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)id)).eq(MdmRoleEntity::getRoleName, (Object)roleName)).count();
        Assert.isTrue((nameCount == null || nameCount < 1 ? 1 : 0) != 0, (String)"\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
        boolean updatePositionRedundancy = false;
        if (!oldEntity.getRoleName().equals(mdmRoleReqVo.getRoleName())) {
            updatePositionRedundancy = true;
        }
        MdmRoleEntity mdmRoleEntity = (MdmRoleEntity)((Object)this.getById((Serializable)((Object)mdmRoleReqVo.getId())));
        MdmRoleReqVo oldObject = (MdmRoleReqVo)CrmBeanUtil.copy((Object)((Object)mdmRoleEntity), MdmRoleReqVo.class);
        this.updateById(CrmBeanUtil.copy((Object)mdmRoleReqVo, MdmRoleEntity.class));
        if (updatePositionRedundancy && CollectionUtil.listNotEmptyNotSizeZero((List)(positionRoleEntityList = ((LambdaQueryChainWrapper)this.mdmPositionRoleService.lambdaQuery().eq(MdmPositionRoleEntity::getRoleCode, (Object)oldEntity.getRoleCode())).select(new SFunction[]{MdmPositionRoleEntity::getPositionCode}).list()))) {
            this.mdmPositionService.updatePositionRoleRedundancy(positionRoleEntityList.stream().map(MdmPositionRoleEntity::getRoleCode).collect(Collectors.toList()));
        }
        if ((menuObject = ThreadLocalUtil.getObj((String)"menuCode")) != null) {
            MdmRoleEntity mdmRoleEntityNew = (MdmRoleEntity)((Object)this.getById((Serializable)((Object)mdmRoleReqVo.getId())));
            MdmRoleReqVo newObject = (MdmRoleReqVo)CrmBeanUtil.copy((Object)((Object)mdmRoleEntityNew), MdmRoleReqVo.class);
            this.crmLogSendUtil.sendForUpdate(menuObject.toString(), mdmRoleReqVo.getId(), newObject.getRoleName(), (Object)oldObject, (Object)newObject);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmRoleReqVo mdmRoleReqVo) {
        List ids = mdmRoleReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u5fc5\u586b");
        HashSet<String> positionCodeSet = new HashSet<String>();
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        for (String id : ids) {
            MdmRoleEntity role = (MdmRoleEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)role), (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
            positionCodeSet.addAll(this.mdmPositionRoleService.getRoleRelationPositionCodeList(Collections.singletonList(role.getRoleCode())));
            this.mdmPositionLevelRoleService.removeRoleCode(role.getRoleCode());
            this.mdmPositionRoleService.removeRoleCode(role.getRoleCode());
            this.mdmFunctionRoleService.deleteByRoleCodeList(Collections.singletonList(role.getRoleCode()));
            this.mdmButtonRoleService.deleteByRoleCodeList(Collections.singletonList(role.getRoleCode()));
            ((LambdaUpdateChainWrapper)this.mdmDataPermissionService.lambdaUpdate().eq(MdmDataPermissionEntity::getRoleCode, (Object)role.getRoleCode())).remove();
            if (menuObject != null) {
                this.crmLogSendUtil.sendForDel(menuObject.toString(), id, role.getRoleCode(), CrmBeanUtil.copy((Object)((Object)role), MdmRoleReqVo.class));
            }
            this.removeById((Serializable)((Object)id));
        }
        if (!positionCodeSet.isEmpty()) {
            this.mdmPositionService.updatePositionRoleRedundancy(new ArrayList<String>(positionCodeSet));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmRoleReqVo mdmRoleReqVo) {
        List ids = mdmRoleReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmRoleReqVo mdmRoleReqVo) {
        List ids = mdmRoleReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmRoleRespVo> roleList(MdmRoleReqVo reqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).like(StringUtils.isNotEmpty((CharSequence)reqVo.getRoleCode()), MdmRoleEntity::getRoleCode, (Object)reqVo.getRoleCode())).in(!CollectionUtils.isEmpty((Collection)reqVo.getRoleCodeList()), MdmRoleEntity::getRoleCode, (Collection)reqVo.getRoleCodeList())).like(StringUtils.isNotEmpty((CharSequence)reqVo.getRoleName()), MdmRoleEntity::getRoleName, (Object)reqVo.getRoleName())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list();
        return CrmBeanUtil.copyList((List)list, MdmRoleRespVo.class);
    }

    @Override
    public List<MdmRoleSelectRespVo> roleSelectList(MdmRoleSelectReqVo reqVo) {
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmRoleSelectRespVo> list = new ArrayList<MdmRoleSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmRoleMapper.roleSelectList((Page<MdmRoleSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo));
        }
        return list;
    }

    @Override
    public MdmRoleFunctionRespVo roleFunctionTree(MdmRoleFunctionReqVo mdmRoleFunctionReqVo) {
        String roleCode = mdmRoleFunctionReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmRoleEntity mdmRoleEntity = (MdmRoleEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)roleCode)).select(new SFunction[]{MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName, CrmBaseEntity::getRemarks}).one());
        Assert.notNull((Object)((Object)mdmRoleEntity), (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        List<MdmRoleFunctionTreeVo> mdmRoleFunctionTreeVos = this.mdmFunctionService.roleFunctionTree(mdmRoleFunctionReqVo);
        MdmRoleFunctionRespVo mdmRoleFunctionRespVo = new MdmRoleFunctionRespVo();
        mdmRoleFunctionRespVo.setRoleCode(mdmRoleEntity.getRoleCode());
        mdmRoleFunctionRespVo.setRoleName(mdmRoleEntity.getRoleName());
        mdmRoleFunctionRespVo.setRemarks(mdmRoleEntity.getRemarks());
        mdmRoleFunctionRespVo.setMdmRoleFunctionTreeVos(mdmRoleFunctionTreeVos);
        return mdmRoleFunctionRespVo;
    }

    @Override
    public List<MdmRoleSubButtonVo> roleButtonList(MdmRoleSubButtonReqVo mdmRoleSubButtonReqVo) {
        return this.mdmFunctionSubButtonService.buttonList(mdmRoleSubButtonReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveFunctionButton(MdmRoleFunctionButtonStoreVo mdmRoleFunctionButtonStoreVo) {
        String roleCode = mdmRoleFunctionButtonStoreVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String roleName = mdmRoleFunctionButtonStoreVo.getRoleName();
        Assert.hasText((String)roleName, (String)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)roleCode)).count();
        Assert.isTrue((count != null && count > 0 ? 1 : 0) != 0, (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmRoleEntity::getRoleCode, (Object)roleCode)).set(MdmRoleEntity::getRoleName, (Object)roleName)).set(!StringUtils.isEmpty((CharSequence)mdmRoleFunctionButtonStoreVo.getRemarks()), CrmBaseEntity::getRemarks, (Object)mdmRoleFunctionButtonStoreVo.getRemarks()).update();
        List mdmRoleFunctionTreeVos = mdmRoleFunctionButtonStoreVo.getMdmRoleFunctionTreeVos();
        ArrayList<String> functionCodeList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)mdmRoleFunctionTreeVos)) {
            this.setUpFunction(functionCodeList, mdmRoleFunctionTreeVos);
        }
        this.mdmFunctionRoleService.update(roleCode, functionCodeList);
        List mdmRoleSubButtonVos = mdmRoleFunctionButtonStoreVo.getMdmRoleSubButtonVos();
        if (!CollectionUtils.isEmpty((Collection)mdmRoleSubButtonVos)) {
            this.mdmButtonRoleService.setUp(roleCode, mdmRoleSubButtonVos);
        }
        TableConfigUtil.removeAll();
    }

    @Override
    public void switchFunctionButton(MdmSwitchFunctionButtonReqVo mdmSwitchFunctionButtonReqVo) {
        this.mdmFunctionSubButtonService.switchFunctionButton(mdmSwitchFunctionButtonReqVo);
    }

    public void setUpFunction(List<String> functionCodeList, List<MdmRoleFunctionTreeVo> mdmRoleFunctionTreeVos) {
        if (!CollectionUtils.isEmpty(mdmRoleFunctionTreeVos)) {
            List currentFunctionCodeList = mdmRoleFunctionTreeVos.stream().filter(x -> !StringUtils.isEmpty((CharSequence)x.getFunctionCode())).filter(x -> !StringUtils.isEmpty((CharSequence)x.getFunctionSelect()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getFunctionSelect())).map(MdmRoleFunctionTreeVo::getFunctionCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(currentFunctionCodeList)) {
                functionCodeList.addAll(currentFunctionCodeList);
            }
            List<MdmRoleFunctionTreeVo> collect = mdmRoleFunctionTreeVos.stream().flatMap(x -> {
                ArrayList children = x.getChildren();
                if (children == null) {
                    children = new ArrayList();
                }
                return children.stream();
            }).collect(Collectors.toList());
            this.setUpFunction(functionCodeList, collect);
        }
    }
}

