/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangeCurrentCustomerReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserCustomerEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserEditReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.role.service.MdmRoleCustomerService;
import com.biz.crm.user.mapper.MdmCustomerUserMapper;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmCustomerUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmUserCustomerServiceExpandImpl"})
public class MdmCustomerUserServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserMapper, MdmUserEntity>
implements MdmCustomerUserService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerUserServiceImpl.class);
    @Resource
    private MdmCustomerUserMapper mdmCustomerUserMapper;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmRoleCustomerService mdmRoleCustomerService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<MdmCustomerUserPageRespVo> findList(MdmCustomerUserPageReqVo reqVo) {
        reqVo.setUserType(UserTypeEnum.CUSTOMER.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCustomerUserPageRespVo> list = this.mdmCustomerUserMapper.findList((Page<MdmCustomerUserPageRespVo>)page, reqVo);
        this.setCustomerCodeName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmUserRespVo query(String id, String userName) {
        MdmUserEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)userName)) && (one = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((String)userName), MdmUserEntity::getUserName, (Object)userName)).one())) != null) {
            MdmUserRespVo respVo = (MdmUserRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmUserRespVo.class);
            respVo.setUserPassword("");
            if (UserTypeEnum.CUSTOMER.getCode().equals(respVo.getUserType())) {
                respVo.setCustomerList(this.mdmCustomerMsgService.getCustomerListByUserName(one.getUserName()));
                if (YesNoEnum.yesNoEnum.N.getValue().equals(ParamUtil.getParameterValue((String)"user_can_relation_many_customer")) && CollectionUtil.listNotEmptyNotSizeZero((List)respVo.getCustomerList())) {
                    respVo.setCustomerCode(((MdmCustomerMsgRespVo)respVo.getCustomerList().get(0)).getCustomerCode());
                    respVo.setCustomerName(((MdmCustomerMsgRespVo)respVo.getCustomerList().get(0)).getCustomerName());
                    respVo.setRoleCode(((MdmCustomerMsgRespVo)respVo.getCustomerList().get(0)).getRoleCode());
                    respVo.setRoleName(((MdmCustomerMsgRespVo)respVo.getCustomerList().get(0)).getRoleName());
                }
            }
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmUserEditReqVo reqVo) {
        reqVo.setId(null);
        reqVo.setUserType(UserTypeEnum.CUSTOMER.getCode());
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmUserEntity.class));
        if (StringUtils.isEmpty((String)entity.getUserCode())) {
            entity.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
        }
        entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveOrUpdateUserRelation(reqVo, entity);
        MdmUserRespVo newObject = this.query(entity.getId(), null);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCodeObj == null ? "" : menuCodeObj.toString(), entity.getId(), entity.getUserName(), (Object)newObject);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmUserEditReqVo reqVo) {
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        MdmUserRespVo oldObject = this.query(reqVo.getId(), null);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.saveOrUpdateUserRelation(reqVo, entity);
        MdmUserRespVo newObject = this.query(reqVo.getId(), null);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCodeObj == null ? "" : menuCodeObj.toString(), entity.getId(), entity.getUserName(), (Object)oldObject, (Object)newObject);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmUserEntity one = (MdmUserEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u65e0\u6548\u7684\u7528\u6237");
            Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(one.getUserType()), (String)("\u7528\u6237[" + one.getFullName() + "]\u4e0d\u662f\u5ba2\u6237\u7528\u6237"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmCustomerMsgService.lambdaUpdate().eq(MdmCustomerEntity::getUserName, (Object)one.getUserName())).set(MdmCustomerEntity::getUserName, (Object)"")).update();
            Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
            this.crmLogSendUtil.sendForDel(menuCodeObj == null ? "" : menuCodeObj.toString(), one.getId(), one.getUserName(), (Object)one);
        });
        this.removeByIds(ids);
    }

    private void verifyData(MdmUserEditReqVo reqVo) {
        String userName = reqVo.getUserName();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserEntity one = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).one());
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            Assert.isNull((Object)((Object)one), (String)("\u5e10\u53f7[" + userName + "]\u5df2\u5b58\u5728"));
            Assert.hasText((String)reqVo.getUserPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqVo.getUserPassword())) {
            reqVo.setUserPassword(one.getUserPassword());
        } else {
            reqVo.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)reqVo.getUserPassword()));
        }
        String parameterValue = ParamUtil.getParameterValue((String)"user_can_relation_many_customer");
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(parameterValue)) {
            List customerList = reqVo.getCustomerList();
            Assert.notEmpty((Collection)customerList, (String)"\u5ba2\u6237\u7528\u6237\u5fc5\u987b\u5173\u8054\u5ba2\u6237");
            HashMap<String, MdmUserCustomerEditReqVo> customerUniqueMap = new HashMap<String, MdmUserCustomerEditReqVo>(16);
            for (MdmUserCustomerEditReqVo item : customerList) {
                Assert.hasText((String)item.getCustomerCode(), (String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                if (customerUniqueMap.containsKey(item.getCustomerCode())) {
                    throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5173\u8054\u5ba2\u6237\u76f8\u540c\u5ba2\u6237");
                }
                customerUniqueMap.put(item.getCustomerCode(), item);
            }
        } else if (YesNoEnum.yesNoEnum.N.getValue().equals(parameterValue)) {
            Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            throw new BusinessException("\u5168\u5c40\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
    }

    private void saveOrUpdateUserRelation(MdmUserEditReqVo reqVo, MdmUserEntity userEntity) {
        if (YesNoEnum.yesNoEnum.N.getValue().equals(ParamUtil.getParameterValue((String)"user_can_relation_many_customer"))) {
            reqVo.setCustomerList(Collections.singletonList(new MdmUserCustomerEditReqVo().setCustomerCode(reqVo.getCustomerCode()).setRoleCode(reqVo.getRoleCode())));
        }
        boolean setPrimary = false;
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmCustomerMsgService.lambdaUpdate().eq(MdmCustomerEntity::getUserName, (Object)userEntity.getUserName())).set(MdmCustomerEntity::getUserName, (Object)"")).update();
        for (MdmUserCustomerEditReqVo item : reqVo.getCustomerList()) {
            MdmCustomerEntity customer = (MdmCustomerEntity)((Object)((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)item.getCustomerCode())).one());
            Assert.notNull((Object)((Object)customer), (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
            customer.setUserName(userEntity.getUserName());
            customer.setCustomerPrimary(setPrimary ? YesNoEnum.yesNoEnum.ZERO.getValue() : YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmCustomerMsgService.updateById((Object)customer);
            setPrimary = true;
            this.mdmRoleCustomerService.removeByCustomerCode(item.getCustomerCode());
            if (!StringUtils.isNotEmpty((String)item.getRoleCode())) continue;
            this.mdmRoleCustomerService.addCustomerRole(customer.getCustomerCode(), item.getRoleCode());
        }
        this.updateUserCustomerRedundancy(Collections.singletonList(userEntity.getId()), null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public void updateUserCustomerRedundancy(List<String> ids, List<String> userNameList) {
        if (CollectionUtil.listEmpty(ids) && CollectionUtil.listEmpty(userNameList)) {
            return;
        }
        List customerUserList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserType, (Object)UserTypeEnum.CUSTOMER.getCode())).in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).in(CollectionUtil.listNotEmptyNotSizeZero(userNameList), MdmUserEntity::getUserName, userNameList)).select(new SFunction[]{MdmUserEntity::getUserName}).list();
        if (CollectionUtil.listEmpty((List)customerUserList)) {
            return;
        }
        Map<Object, Object> userCustomerGroupTempListMap = new HashMap(16);
        List customerList = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().in(MdmCustomerEntity::getUserName, (Collection)customerUserList.stream().map(MdmUserEntity::getUserName).collect(Collectors.toList()))).select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName, MdmCustomerEntity::getUserName}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)customerList)) {
            userCustomerGroupTempListMap = customerList.stream().collect(Collectors.groupingBy(MdmCustomerEntity::getUserName));
        }
        HashMap userCustomerGroupListMap = userCustomerGroupTempListMap;
        customerUserList.forEach(item -> {
            String customerCodeRedundancy = "";
            String customerNameRedundancy = "";
            if (userCustomerGroupListMap.containsKey(item.getUserName())) {
                List collect = ((List)userCustomerGroupListMap.get(item.getUserName())).stream().sorted(Comparator.comparing(MdmCustomerEntity::getCustomerCode)).collect(Collectors.toList());
                customerCodeRedundancy = collect.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.joining(","));
                customerNameRedundancy = collect.stream().map(MdmCustomerEntity::getCustomerName).collect(Collectors.joining(","));
            }
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserEntity::getUserName, (Object)item.getUserName())).set(MdmUserEntity::getCustomerCodeRedundancy, (Object)customerCodeRedundancy)).set(MdmUserEntity::getCustomerNameRedundancy, (Object)customerNameRedundancy)).update();
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    @Deprecated
    public void resetCustomerUserRedundancy() {
        List customerUserList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserType, (Object)UserTypeEnum.CUSTOMER.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)customerUserList)) {
            List customerUserIdList = customerUserList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            List lists = Lists.partition(customerUserIdList, (int)500);
            for (List item : lists) {
                this.updateUserCustomerRedundancy(item, null);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserCurrentCustomer(MdmUserChangeCurrentCustomerReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u767b\u5f55\u540d");
        Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        MdmUserEntity one = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)reqVo.getUserName())).select(new SFunction[]{BaseIdEntity::getId, MdmUserEntity::getUserName, MdmUserEntity::getFullName, MdmUserEntity::getUserType}).one());
        Assert.notNull((Object)((Object)one), (String)"\u672a\u627e\u5230\u7528\u6237");
        Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(one.getUserType()), (String)"\u8be5\u7528\u6237\u4e0d\u662f\u5ba2\u6237\u7528\u6237");
        MdmCustomerEntity customerEntity = (MdmCustomerEntity)((Object)((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)reqVo.getCustomerCode())).select(new SFunction[]{BaseIdEntity::getId, MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName, MdmCustomerEntity::getCustomerPrimary, MdmCustomerEntity::getUserName, MdmCustomerEntity::getOrgCode, CrmBaseEntity::getEnableStatus}).one());
        Assert.notNull((Object)((Object)customerEntity), (String)"\u672a\u627e\u5230\u5ba2\u6237");
        Assert.isTrue((boolean)reqVo.getUserName().equals(customerEntity.getUserName()), (String)"\u8be5\u5ba2\u6237\u672a\u5173\u8054\u8be5\u7528\u6237");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(customerEntity.getEnableStatus()), (String)"\u8be5\u5ba2\u6237\u672a\u542f\u7528");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmCustomerMsgService.lambdaUpdate().eq(MdmCustomerEntity::getUserName, (Object)one.getUserName())).ne(MdmCustomerEntity::getCustomerCode, (Object)customerEntity.getCustomerCode())).set(MdmCustomerEntity::getCustomerPrimary, (Object)YesNoEnum.yesNoEnum.ZERO.getValue())).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmCustomerMsgService.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)customerEntity.getCustomerCode())).set(MdmCustomerEntity::getCustomerPrimary, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
        UserRedis user = UserUtils.getUser();
        String token = UserUtils.getToken();
        if (user != null && StringUtils.isNotEmpty((String)user.getUsername()) && one.getUserName().equals(user.getUsername()) && StringUtils.isNotEmpty((String)token)) {
            UserRedis userRedis = new UserRedis();
            userRedis.setUsername(one.getUserName());
            userRedis.setRealname(one.getFullName());
            userRedis.setCustcode(customerEntity.getCustomerCode());
            userRedis.setCustname(customerEntity.getCustomerName());
            List<String> customerRelOrgList = this.mdmCustomerROrgService.findOrgCodeByCustomerCode(customerEntity.getCustomerCode());
            if (CollectionUtil.listNotEmptyNotSizeZero(customerRelOrgList)) {
                Map<String, String> orgNameMap = this.mdmOrgService.findOrgNameMap(customerRelOrgList);
                List orgCodeList = customerRelOrgList.stream().filter(orgNameMap::containsKey).collect(Collectors.toList());
                if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) {
                    List orgNameList = orgCodeList.stream().map(orgNameMap::get).collect(Collectors.toList());
                    userRedis.setOrgcode(String.join((CharSequence)",", orgCodeList));
                    userRedis.setOrgname(String.join((CharSequence)",", orgNameList));
                }
            }
            UserUtils.setUser((String)token, (UserRedis)userRedis);
        }
    }

    private void setCustomerCodeName(List<MdmCustomerUserPageRespVo> allList) {
        if (CollectionUtil.listEmpty(allList)) {
            return;
        }
        List partition = Lists.partition(allList, (int)500);
        for (List list : partition) {
            List userNameList = allList.stream().map(MdmCustomerUserPageRespVo::getUserName).collect(Collectors.toList());
            Map<String, List<MdmCustomerEntity>> collect = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().in(MdmCustomerEntity::getUserName, userNameList)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName, MdmCustomerEntity::getUserName}).list().stream().collect(Collectors.groupingBy(MdmCustomerEntity::getUserName));
            list.forEach(item -> {
                List customerList;
                if (collect.containsKey(item.getUserName()) && CollectionUtil.listNotEmptyNotSizeZero((List)(customerList = (List)collect.get(item.getUserName())))) {
                    item.setCustomerCode(customerList.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.joining(",")));
                    item.setCustomerName(customerList.stream().map(MdmCustomerEntity::getCustomerName).collect(Collectors.joining(",")));
                }
            });
        }
    }
}

