/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.ClassUtil;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigBatchReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnResolveVo;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmcolumnconfig"})
@Api(tags={"\u5b57\u6bb5\u914d\u7f6e"})
@PropertySource(value={"classpath:bootstrap.yml"})
public class MdmColumnConfigController {
    private static final Logger log = LoggerFactory.getLogger(MdmColumnConfigController.class);
    @Autowired
    private IMdmColumnConfigService mdmColumnConfigService;
    @Value(value="${vopackagepath:com.biz.crm}")
    private String voPackagePath;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<MdmColumnConfigRespVo>> list(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        return Result.ok(this.mdmColumnConfigService.findList(mdmColumnConfigReqVo));
    }

    @ApiOperation(value="\u5b57\u6bb5\u914d\u7f6e\u5217\u8868")
    @PostMapping(value={"/list_condition"})
    public Result<List<MdmColumnConfigRespVo>> listCondition(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        return Result.ok(this.mdmColumnConfigService.listCondition(mdmColumnConfigReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<MdmColumnConfigRespVo> query(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        MdmColumnConfigRespVo respVo = this.mdmColumnConfigService.query(mdmColumnConfigReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e")
    @PostMapping(value={"/save_batch"})
    public Result<Object> saveBatch(@RequestBody MdmColumnConfigBatchReqVo mdmColumnConfigBatchReqVo) {
        this.mdmColumnConfigService.addBatch(mdmColumnConfigBatchReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result<Object> save(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        this.mdmColumnConfigService.save(mdmColumnConfigReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result<Object> update(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        this.mdmColumnConfigService.update(mdmColumnConfigReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result<Object> delete(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        this.mdmColumnConfigService.deleteBatch(mdmColumnConfigReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result<Object> enable(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        this.mdmColumnConfigService.enableBatch(mdmColumnConfigReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u5168\u8def\u5f84\u540d\u83b7\u53d6\u5b57\u6bb5\u89e3\u6790")
    @GetMapping(value={"/column_resolve"})
    public Result<List<MdmColumnConfigRespVo>> columnResolve(@RequestParam(value="classPath") String classPath) {
        return Result.ok(this.mdmColumnConfigService.columnResolve(classPath));
    }

    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6evo")
    @PostMapping(value={"/column_resolve_select"})
    public Result<List<MdmColumnResolveVo>> columnResolveSelect(@RequestBody MdmColumnResolveVo mdmColumnResolveVo) {
        String[] pageagePath;
        ArrayList classes = new ArrayList(500);
        for (String path : pageagePath = this.voPackagePath.split(",")) {
            List<Class<?>> currentClasses = ClassUtil.getClasses(path);
            if (CollectionUtils.isEmpty(currentClasses)) continue;
            classes.addAll(currentClasses);
        }
        List collect = classes.stream().filter(x -> x.isAnnotationPresent(CrmColumnResolve.class)).filter(x -> StringUtils.isEmpty((Object)mdmColumnResolveVo.getClassName()) || x.getSimpleName().contains(mdmColumnResolveVo.getClassName())).map(x -> {
            MdmColumnResolveVo mdmColumnResolveVo1 = new MdmColumnResolveVo();
            ApiModel annotation = x.getAnnotation(ApiModel.class);
            if (annotation != null) {
                mdmColumnResolveVo1.setClassNote(annotation.value());
            }
            mdmColumnResolveVo1.setClassName(x.getSimpleName());
            mdmColumnResolveVo1.setClassPath(x.getName());
            return mdmColumnResolveVo1;
        }).collect(Collectors.toList());
        return Result.ok(collect);
    }

    @ApiOperation(value="\u5b57\u6bb5\u4e0b\u62c9\u6846")
    @PostMapping(value={"/columnSelect"})
    public Result<List<MdmColumnExportRespVo>> columnSelect(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        List<MdmColumnExportRespVo> list = this.mdmColumnConfigService.columnSelect(mdmColumnConfigReqVo);
        return Result.ok(list);
    }
}

