/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmGrabRuleService;
import com.biz.crm.nebular.mdm.kms.MdmDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabOrderTypeVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.MdmRuleParamVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRulePageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmGrabRuleServiceExpandImpl"})
public class MdmGrabRuleServiceImpl
implements MdmGrabRuleService {
    @Autowired
    private KmsProperties kmsProperties;

    @Override
    public List<MdmGrabOrderTypeVo> orderTypeList(MdmDirectSystemVo mdmDirectSystemVo) {
        String directSystemId = mdmDirectSystemVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsDirectRuleVo = new KmsGrabRuleVo();
        kmsDirectRuleVo.setDirectSystemId(directSystemId);
        kmsDirectRuleVo.setUserId(this.kmsProperties.getUserId());
        kmsDirectRuleVo.setUsername(this.kmsProperties.getUsername());
        kmsDirectRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        String url = this.kmsProperties.getUrl() + "/orderTypeController/findOrderTypeList";
        ParameterizedTypeReference<KmsResultVo<List<MdmGrabOrderTypeVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<MdmGrabOrderTypeVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsDirectRuleVo, (ParameterizedTypeReference)reference);
        return Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(Collections.emptyList());
    }

    @Override
    public PageResult<MdmGrabRuleVo> page(MdmGrabRuleVo mdmGrabRuleVo) {
        String directSystemId = mdmGrabRuleVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String invoiceId = mdmGrabRuleVo.getInvoiceId();
        Assert.hasText((String)invoiceId, (String)"\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        Integer current = Optional.ofNullable(mdmGrabRuleVo.getPageNum()).orElse(1);
        Integer size = Optional.ofNullable(mdmGrabRuleVo.getPageSize()).orElse(25);
        KmsPageVo kmsPageVo = new KmsPageVo(current, size);
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setInvoiceId(invoiceId);
        kmsGrabRuleVo.setDirectSystemId(directSystemId);
        KmsGrabRulePageVo kmsGrabRulePageVo = new KmsGrabRulePageVo();
        kmsGrabRulePageVo.setUserId(this.kmsProperties.getUserId());
        kmsGrabRulePageVo.setUsername(this.kmsProperties.getUsername());
        kmsGrabRulePageVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRulePageVo.setReqVo(kmsGrabRuleVo);
        kmsGrabRulePageVo.setPage(kmsPageVo);
        String url = this.kmsProperties.getUrl() + "/grabRuleController/findGrabRuleListByPage";
        ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsGrabRuleVo>>> reference = new ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsGrabRuleVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)reference);
        KmsPageResultVo kmsPageResultVo = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (kmsPageResultVo == null || kmsPageResultVo.getRecords() == null || kmsPageResultVo.getRecords() == 0) {
            PageResult emptyPage = new PageResult();
            emptyPage.setCount(Long.valueOf(0L));
            emptyPage.setData(Collections.emptyList());
            return emptyPage;
        }
        return KmsConverter.INSTANCE.grabRule2Mdm((KmsPageResultVo<KmsGrabRuleVo>)kmsPageResultVo);
    }

    @Override
    public void enable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setIds(ids);
        kmsGrabRuleVo.setComomStatus("ENABLE");
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRuleVo.setUsername(kmsGrabRuleVo.getUsername());
        kmsGrabRuleVo.setUserId(kmsGrabRuleVo.getUserId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/modifyGrabRuleStatus?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u542f\u7528\u5931\u8d25");
        }
    }

    @Override
    public void disable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setIds(ids);
        kmsGrabRuleVo.setComomStatus("DISABLE");
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRuleVo.setUsername(kmsGrabRuleVo.getUsername());
        kmsGrabRuleVo.setUserId(kmsGrabRuleVo.getUserId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/modifyGrabRuleStatus?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u7981\u7528\u5931\u8d25");
        }
    }

    @Override
    public void remove(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setIds(ids);
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRuleVo.setUsername(kmsGrabRuleVo.getUsername());
        kmsGrabRuleVo.setUserId(kmsGrabRuleVo.getUserId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/deleteGrabRuleByIds?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public List<MdmRuleParamVo> paramList(MdmGrabRuleVo mdmGrabRuleVo) {
        String directSystemId = mdmGrabRuleVo.getDirectSystemId();
        String invoiceId = mdmGrabRuleVo.getInvoiceId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)invoiceId, (String)"\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("bsDirectId", directSystemId);
        paramMap.put("bsInvoiceId", invoiceId);
        paramMap.put("tenantryId", this.kmsProperties.getTenantryId());
        paramMap.put("userId", this.kmsProperties.getUserId());
        paramMap.put("username", this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/ruleParamController/findRuleParamList";
        ParameterizedTypeReference<KmsResultVo<List<MdmRuleParamVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<MdmRuleParamVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, paramMap, (ParameterizedTypeReference)reference);
        List mdmRuleParamVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(mdmRuleParamVos)) {
            return Collections.emptyList();
        }
        return mdmRuleParamVos.stream().peek(x -> {
            String isRequired = x.getIsRequired();
            if (!StringUtils.isEmpty((Object)isRequired) && "YES".equals(isRequired)) {
                x.setIsRequired("1");
            } else {
                x.setIsRequired("0");
            }
        }).collect(Collectors.toList());
    }
}

