/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmSellPartyService;
import com.biz.crm.nebular.mdm.kms.MdmSellPartyVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsSellPartyPageReqVo;
import com.biz.crm.nebular.mdm.kms.api.KmsSellPartyReqVo;
import com.biz.crm.nebular.mdm.kms.api.KmsSellPartyVo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmSellPartyServiceExpandImpl"})
public class MdmSellPartyServiceImpl
implements MdmSellPartyService {
    @Autowired
    private KmsProperties kmsProperties;

    @Override
    public PageResult<MdmSellPartyVo> page(MdmSellPartyVo mdmSellPartyVo) {
        Integer current = Optional.ofNullable(mdmSellPartyVo.getPageNum()).orElse(1);
        Integer size = Optional.ofNullable(mdmSellPartyVo.getPageSize()).orElse(25);
        KmsPageVo kmsPageVo = new KmsPageVo(current, size);
        KmsSellPartyReqVo kmsSellPartyReqVo = new KmsSellPartyReqVo();
        String directSystemId = mdmSellPartyVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        kmsSellPartyReqVo.setDirectSystemId(directSystemId);
        kmsSellPartyReqVo.setTenantryId(this.kmsProperties.getTenantryId());
        KmsSellPartyPageReqVo kmsSellPartyPageReqVo = new KmsSellPartyPageReqVo();
        kmsSellPartyPageReqVo.setPage(kmsPageVo);
        kmsSellPartyPageReqVo.setReqVo(kmsSellPartyReqVo);
        kmsSellPartyPageReqVo.setSearchValue(mdmSellPartyVo.getSellPartyName());
        kmsSellPartyPageReqVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyPageReqVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyPageReqVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/sell/party/findByPage";
        ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsSellPartyVo>>> reference = new ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsSellPartyVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsSellPartyPageReqVo, (ParameterizedTypeReference)reference);
        KmsPageResultVo mdmSellPartyVoKmsPageResultVo = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (mdmSellPartyVoKmsPageResultVo == null) {
            PageResult mdmSellPartyVoPageResult = new PageResult();
            mdmSellPartyVoPageResult.setCount(Long.valueOf(0L));
            mdmSellPartyVoPageResult.setData(Collections.emptyList());
            return mdmSellPartyVoPageResult;
        }
        return KmsConverter.INSTANCE.sellPartyPage((KmsPageResultVo<KmsSellPartyVo>)mdmSellPartyVoKmsPageResultVo);
    }

    @Override
    public void save(MdmSellPartyVo mdmSellPartyVo) {
        Assert.hasText((String)mdmSellPartyVo.getDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getSellPartyCode(), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getSellPartyName(), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        KmsSellPartyVo kmsSellPartyVo = KmsConverter.INSTANCE.mdm2SellParty(mdmSellPartyVo);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        kmsSellPartyVo.setId(null);
        String url = this.kmsProperties.getUrl() + "/sell/party/saveSellParty?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public void update(MdmSellPartyVo mdmSellPartyVo) {
        Assert.hasText((String)mdmSellPartyVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getSellPartyCode(), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getSellPartyName(), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        KmsSellPartyVo kmsSellPartyVo = KmsConverter.INSTANCE.mdm2SellParty(mdmSellPartyVo);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/sell/party/saveSellParty?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25");
        }
    }

    @Override
    public void delete(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsSellPartyVo kmsSellPartyVo = new KmsSellPartyVo();
        kmsSellPartyVo.setIds(ids);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/sell/party/deleteBatch?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void enable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsSellPartyVo kmsSellPartyVo = new KmsSellPartyVo();
        kmsSellPartyVo.setIds(ids);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        kmsSellPartyVo.setFieldEn("status");
        kmsSellPartyVo.setStatus("ENABLE");
        String url = this.kmsProperties.getUrl() + "/sell/party/editBatch?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u542f\u7528\u5931\u8d25");
        }
    }

    @Override
    public void disable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsSellPartyVo kmsSellPartyVo = new KmsSellPartyVo();
        kmsSellPartyVo.setIds(ids);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        kmsSellPartyVo.setFieldEn("status");
        kmsSellPartyVo.setStatus("DISABLE");
        String url = this.kmsProperties.getUrl() + "/sell/party/editBatch?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u7981\u7528\u5931\u8d25");
        }
    }

    @Override
    public List<MdmSellPartyVo> list(MdmSellPartyVo mdmSellPartyVo) {
        String directSystemId = mdmSellPartyVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        KmsSellPartyPageReqVo kmsSellPartyPageReqVo = new KmsSellPartyPageReqVo();
        kmsSellPartyPageReqVo.setSearchValue(mdmSellPartyVo.getSellPartyName());
        kmsSellPartyPageReqVo.setDirectSystemId(directSystemId);
        kmsSellPartyPageReqVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyPageReqVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyPageReqVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/sell/party/findByList";
        ParameterizedTypeReference<KmsResultVo<List<KmsSellPartyVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<KmsSellPartyVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsSellPartyPageReqVo, (ParameterizedTypeReference)reference);
        List kmsSellPartyVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsSellPartyVos)) {
            return Collections.emptyList();
        }
        return KmsConverter.INSTANCE.sellParty2Mdm(kmsSellPartyVos);
    }
}

