/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdmbuglistmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.mdmbuglistmanagement.mapper.MdmBugListManagementMapper;
import com.biz.crm.mdmbuglistmanagement.model.MdmBugListManagementEntity;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.resp.MdmBugListManagementRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BugManagementServiceHelp {
    private static final Logger log = LoggerFactory.getLogger(BugManagementServiceHelp.class);
    @Resource
    private MdmBugListManagementMapper mdmBugListManagementMapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("sys_task");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void setStatus(Map<String, String> globalMap, MdmBugListManagementRespVo o) {
        Map<String, Map<String, String>> helpMap = this.getDicts();
        if (StringUtils.isNotEmpty((CharSequence)o.getCodeByPhone())) {
            o.setChargeMan(Optional.ofNullable(helpMap.get("sys_task")).orElse(Maps.newHashMap()).get(o.getCodeByPhone()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsBackendFix())) {
            o.setIsBackendFixDesc(globalMap.get(o.getIsBackendFix()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsForeEndFix())) {
            o.setIsForeEndFixDesc(globalMap.get(o.getIsForeEndFix()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsDevTesting())) {
            o.setIsDevTestingDesc(globalMap.get(o.getIsDevTesting()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsDevPassTest())) {
            o.setIsDevPassTestDesc(globalMap.get(o.getIsDevPassTest()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsBackendArrUat())) {
            o.setIsBackendArrUatDesc(globalMap.get(o.getIsBackendArrUat()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsForeEndArrUat())) {
            o.setIsForeEndArrUatDesc(globalMap.get(o.getIsForeEndArrUat()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsUatTesting())) {
            o.setIsUatTestingDesc(globalMap.get(o.getIsUatTesting()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsUatPassTest())) {
            o.setIsUatPassTestDesc(globalMap.get(o.getIsUatPassTest()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsBackendArrPro())) {
            o.setIsBackendArrProDesc(globalMap.get(o.getIsBackendArrPro()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsForeEndArrPro())) {
            o.setIsForeEndArrProDesc(globalMap.get(o.getIsForeEndArrPro()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsProTesting())) {
            o.setIsProTestingDesc(globalMap.get(o.getIsProTesting()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsProPassTest())) {
            o.setIsProPassTestDesc(globalMap.get(o.getIsProPassTest()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsComplete())) {
            o.setIsCompleteDesc(globalMap.get(o.getIsComplete()));
        }
        if (StringUtils.isNotEmpty((CharSequence)o.getIsUrgent())) {
            o.setIsUrgentDesc(globalMap.get(o.getIsUrgent()));
        }
    }

    public void checkData(MdmBugListManagementReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getBugCode(), (String)"\u8bf7\u8f93\u5165bug\u7f16\u7801");
        AssertUtils.isNotEmpty((String)reqVo.getBugName(), (String)"BugName\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCodeByPhone(), (String)"\u8d1f\u8d23\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, Map<String, String>> helpMap = this.getDicts();
        reqVo.setChargeMan(Optional.ofNullable(helpMap.get("sys_task")).orElse(Maps.newHashMap()).get(reqVo.getCodeByPhone()));
        if (StringUtils.isBlank((CharSequence)reqVo.getIsBackendFix())) {
            reqVo.setIsBackendFix(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsForeEndFix())) {
            reqVo.setIsForeEndFix(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsBackendArrPro())) {
            reqVo.setIsBackendArrPro(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsForeEndArrPro())) {
            reqVo.setIsForeEndArrPro(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsBackendArrUat())) {
            reqVo.setIsBackendArrUat(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsForeEndArrUat())) {
            reqVo.setIsForeEndArrUat(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsDevTesting())) {
            reqVo.setIsDevTesting(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsDevPassTest())) {
            reqVo.setIsDevPassTest(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsProTesting())) {
            reqVo.setIsProTesting(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsProPassTest())) {
            reqVo.setIsProPassTest(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsUatTesting())) {
            reqVo.setIsUatTesting(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsUatPassTest())) {
            reqVo.setIsUatPassTest(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsUrgent())) {
            reqVo.setIsUrgent(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getIsComplete())) {
            reqVo.setIsComplete(GlobalWhetherEnum.NO.getCode());
        }
        this.checkExist(reqVo);
    }

    private void checkExist(MdmBugListManagementReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmBugListManagementEntity::getBugCode, (Object)reqVo.getBugCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.mdmBugListManagementMapper.selectList((Wrapper)wrapper))) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d");
        }
    }

    public void setPhone(MdmBugListManagementReqVo x) {
        Map<String, String> phoneMap = Optional.ofNullable(this.getDicts().get("sys_task")).orElse(Maps.newHashMap());
        HashSet valueSet = Sets.newHashSet(phoneMap.values());
        if (valueSet.size() != phoneMap.size()) {
            throw new BusinessException("\u6709\u76f8\u540c\u59d3\u540d\u8d1f\u8d23\u4eba\uff0c\u8bf7\u533a\u5206");
        }
        Map<String, String> nameToPhoneMap = phoneMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        if (StringUtils.isNotBlank((CharSequence)x.getChargeMan())) {
            x.setCodeByPhone(nameToPhoneMap.get(x.getChargeMan()));
        }
    }
}

