/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmGrabRuleService;
import com.biz.crm.nebular.mdm.kms.MdmDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabOrderTypeVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.MdmRuleParamVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRulePageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabStoreVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import com.biz.crm.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmGrabRuleServiceExpandImpl"})
public class MdmGrabRuleServiceImpl
implements MdmGrabRuleService {
    @Autowired
    private KmsProperties kmsProperties;

    @Override
    public List<MdmGrabOrderTypeVo> orderTypeList(MdmDirectSystemVo mdmDirectSystemVo) {
        String directSystemId = mdmDirectSystemVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsDirectRuleVo = new KmsGrabRuleVo();
        kmsDirectRuleVo.setDirectSystemId(directSystemId);
        kmsDirectRuleVo.setUserId(this.kmsProperties.getUserId());
        kmsDirectRuleVo.setUsername(this.kmsProperties.getUsername());
        kmsDirectRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        String url = this.kmsProperties.getUrl() + "/orderTypeController/findOrderTypeList";
        ParameterizedTypeReference<KmsResultVo<List<MdmGrabOrderTypeVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<MdmGrabOrderTypeVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsDirectRuleVo, (ParameterizedTypeReference)reference);
        return Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(x -> {
            for (MdmGrabOrderTypeVo mdmGrabOrderTypeVo : x) {
                mdmGrabOrderTypeVo.setInvoiceId(mdmGrabOrderTypeVo.getId());
            }
            return x;
        }).orElse(Collections.emptyList());
    }

    @Override
    public PageResult<MdmGrabRuleVo> page(MdmGrabRuleVo mdmGrabRuleVo) {
        String directSystemId = mdmGrabRuleVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String invoiceId = mdmGrabRuleVo.getInvoiceId();
        Assert.hasText((String)invoiceId, (String)"\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        Integer current = Optional.ofNullable(mdmGrabRuleVo.getPageNum()).orElse(1);
        Integer size = Optional.ofNullable(mdmGrabRuleVo.getPageSize()).orElse(25);
        KmsPageVo kmsPageVo = new KmsPageVo(current, size);
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setInvoiceId(invoiceId);
        kmsGrabRuleVo.setDirectSystemId(directSystemId);
        KmsGrabRulePageVo kmsGrabRulePageVo = new KmsGrabRulePageVo();
        kmsGrabRulePageVo.setUserId(this.kmsProperties.getUserId());
        kmsGrabRulePageVo.setUsername(this.kmsProperties.getUsername());
        kmsGrabRulePageVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRulePageVo.setReqVo(kmsGrabRuleVo);
        kmsGrabRulePageVo.setPage(kmsPageVo);
        String url = this.kmsProperties.getUrl() + "/grabRuleController/findGrabRuleListByPage";
        ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsGrabRuleVo>>> reference = new ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsGrabRuleVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)reference);
        KmsPageResultVo kmsPageResultVo = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (kmsPageResultVo == null || kmsPageResultVo.getRecords() == null || kmsPageResultVo.getRecords() == 0) {
            PageResult emptyPage = new PageResult();
            emptyPage.setCount(Long.valueOf(0L));
            emptyPage.setData(Collections.emptyList());
            return emptyPage;
        }
        return KmsConverter.INSTANCE.grabRule2Mdm((KmsPageResultVo<KmsGrabRuleVo>)kmsPageResultVo);
    }

    @Override
    public void enable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setIds(ids);
        kmsGrabRuleVo.setComomStatus("ENABLE");
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRuleVo.setUsername(kmsGrabRuleVo.getUsername());
        kmsGrabRuleVo.setUserId(kmsGrabRuleVo.getUserId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/modifyGrabRuleStatus?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u542f\u7528\u5931\u8d25");
        }
    }

    @Override
    public void disable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setIds(ids);
        kmsGrabRuleVo.setComomStatus("DISABLE");
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRuleVo.setUsername(kmsGrabRuleVo.getUsername());
        kmsGrabRuleVo.setUserId(kmsGrabRuleVo.getUserId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/modifyGrabRuleStatus?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u7981\u7528\u5931\u8d25");
        }
    }

    @Override
    public void remove(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setIds(ids);
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRuleVo.setUsername(kmsGrabRuleVo.getUsername());
        kmsGrabRuleVo.setUserId(kmsGrabRuleVo.getUserId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/deleteGrabRuleByIds?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public List<MdmRuleParamVo> paramList(MdmGrabRuleVo mdmGrabRuleVo) {
        String bsDirectId = mdmGrabRuleVo.getBsDirectId();
        Assert.hasText((String)bsDirectId, (String)"\u540e\u53f0\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String bsInvoiceId = mdmGrabRuleVo.getBsInvoiceId();
        Assert.hasText((String)bsInvoiceId, (String)"\u540e\u53f0\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("bsDirectId", bsDirectId);
        paramMap.put("bsInvoiceId", bsDirectId);
        paramMap.put("tenantryId", this.kmsProperties.getTenantryId());
        paramMap.put("userId", this.kmsProperties.getUserId());
        paramMap.put("username", this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/ruleParamController/findRuleParamList";
        ParameterizedTypeReference<KmsResultVo<List<MdmRuleParamVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<MdmRuleParamVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, paramMap, (ParameterizedTypeReference)reference);
        List mdmRuleParamVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(mdmRuleParamVos)) {
            return Collections.emptyList();
        }
        return mdmRuleParamVos.stream().peek(x -> {
            String isRequired = x.getIsRequired();
            x.setBsFieldId(x.getId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)isRequired) && "YES".equals(isRequired)) {
                x.setIsRequired("1");
            } else {
                x.setIsRequired("0");
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<KmsGrabStoreVo> findGrabStoreList(MdmGrabRuleVo mdmGrabRuleVo) {
        String directSystemId = mdmGrabRuleVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String invoiceId = mdmGrabRuleVo.getInvoiceId();
        Assert.hasText((String)invoiceId, (String)"\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("directSystemId", directSystemId);
        map.put("invoiceId", invoiceId);
        map.put("userId", this.kmsProperties.getUserId());
        map.put("username", this.kmsProperties.getUsername());
        map.put("tenantryId", this.kmsProperties.getTenantryId());
        String url = this.kmsProperties.getUrl() + "/ruleStoreController/findStoreGroupListForSave";
        ParameterizedTypeReference<KmsResultVo<List<KmsGrabStoreVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<KmsGrabStoreVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, map, (ParameterizedTypeReference)reference);
        return Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(Collections.emptyList());
    }

    @Override
    public void save(MdmGrabRuleVo mdmGrabRuleVo) {
        Assert.hasText((String)mdmGrabRuleVo.getAccountId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getBsDirectId(), (String)"\u540e\u53f0\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getBsInvoiceId(), (String)"\u540e\u53f0\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getInvoiceId(), (String)"\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getInvoiceName(), (String)"\u5355\u636e\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getName(), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)this.verifyDateFormat(mdmGrabRuleVo.getStartDate(), "HH:mm"), (String)"\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        Assert.isTrue((boolean)this.verifyDateFormat(mdmGrabRuleVo.getEndDate(), "HH:mm"), (String)"\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        Assert.isTrue((mdmGrabRuleVo.getEndDate().compareTo(mdmGrabRuleVo.getStartDate()) > 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u8981\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
        Assert.hasText((String)mdmGrabRuleVo.getRequency(), (String)"\u6267\u884c\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        try {
            int startMinutes = sdf.parse("11:38").getMinutes();
            int endMinutes = sdf.parse("11:40").getMinutes();
            Assert.isTrue((endMinutes - startMinutes > Integer.parseInt(mdmGrabRuleVo.getRequency()) ? 1 : 0) != 0, (String)"\u65f6\u95f4\u95f4\u9694\u8981\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e4b\u5dee");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        KmsGrabRuleVo kmsGrabRuleVo = KmsConverter.INSTANCE.grabRule2Kms(mdmGrabRuleVo);
        kmsGrabRuleVo.setUserId(this.kmsProperties.getUserId());
        kmsGrabRuleVo.setUsername(this.kmsProperties.getUsername());
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/saveGrabRule?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public MdmGrabRuleVo query(MdmGrabRuleVo mdmGrabRuleVo) {
        return null;
    }

    private boolean verifyDateFormat(String dataStr, String formatStr) {
        boolean flag = false;
        if (StringUtils.isNotEmpty((String)dataStr) && StringUtils.isNotEmpty((String)formatStr)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                Date parse = sdf.parse(dataStr);
                String dateFormatStr = sdf.format(parse);
                if (dataStr.equals(dateFormatStr)) {
                    flag = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }
}

