/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmShelfProductService;
import com.biz.crm.nebular.mdm.kms.MdmProductUnitVo;
import com.biz.crm.nebular.mdm.kms.MdmShelfProductVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsProductPageReqVo;
import com.biz.crm.nebular.mdm.kms.api.KmsProductUnitVo;
import com.biz.crm.nebular.mdm.kms.api.KmsProductVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultBodyVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmShelfProductServiceExpandImpl"})
public class MdmShelfProductServiceImpl
implements MdmShelfProductService {
    @Resource
    private KmsProperties kmsProperties;

    @Override
    public List<MdmProductUnitVo> findProductUnit(MdmShelfProductVo mdmShelfProductVo) {
        String proDetailsNumber = mdmShelfProductVo.getProDetailsNumber();
        Assert.hasText((String)proDetailsNumber, (String)"\u4f01\u4e1a\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        KmsProductVo kmsProductVo = new KmsProductVo();
        kmsProductVo.setProDetailsNumber(proDetailsNumber);
        kmsProductVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsProductVo.setUserId(this.kmsProperties.getUserId());
        kmsProductVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/shelfProductController/getProductUnitList";
        ParameterizedTypeReference<KmsResultVo<List<KmsProductUnitVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<KmsProductUnitVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsProductVo, (ParameterizedTypeReference)reference);
        List<KmsProductUnitVo> kmsProductUnitVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(kmsProductUnitVos)) {
            return Collections.emptyList();
        }
        return KmsConverter.INSTANCE.productUnit2Mdm(kmsProductUnitVos);
    }

    @Override
    public List<MdmShelfProductVo> findProductList(MdmShelfProductVo mdmShelfProductVo) {
        String sellPartyId = mdmShelfProductVo.getSellPartyId();
        Assert.hasText((String)sellPartyId, (String)"\u552e\u8fbe\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        String directSystemId = mdmShelfProductVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        KmsProductVo kmsProductVo = new KmsProductVo();
        kmsProductVo.setUsername(this.kmsProperties.getUsername());
        kmsProductVo.setUserId(this.kmsProperties.getUserId());
        kmsProductVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsProductVo.setDirectSystemId(directSystemId);
        kmsProductVo.setSellPartyId(sellPartyId);
        String url = this.kmsProperties.getUrl() + "/shelfProductController/getProductList";
        ParameterizedTypeReference<KmsResultVo<List<KmsProductVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<KmsProductVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsProductVo, (ParameterizedTypeReference)reference);
        List kmsProductVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsProductVos)) {
            return Collections.emptyList();
        }
        return KmsConverter.INSTANCE.product2Mdm(kmsProductVos);
    }

    @Override
    public void save(MdmShelfProductVo mdmShelfProductVo) {
        Assert.hasText((String)mdmShelfProductVo.getDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmShelfProductVo.getDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmShelfProductVo.getOrderUnitId(), (String)"\u8ba2\u8d27\u5355\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmShelfProductVo.getOrderUnit(), (String)"\u8ba2\u8d27\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmShelfProductVo.getProDetailsNumber(), (String)"\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmShelfProductVo.getProDetailsName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmShelfProductVo.getSellPartyId(), (String)"\u552e\u8fbe\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmShelfProductVo.getStoreProductCode(), (String)"\u95e8\u5e97\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        KmsProductVo kmsProductVo = KmsConverter.INSTANCE.product2Kms(mdmShelfProductVo);
        kmsProductVo.setUsername(this.kmsProperties.getUsername());
        kmsProductVo.setUserId(this.kmsProperties.getUserId());
        kmsProductVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsProductVo.setDirectSystemName(mdmShelfProductVo.getDirectSystemName());
        String url = this.kmsProperties.getUrl() + "/shelfProductController/saveShelfProduct?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsProductVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public void remove(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsProductVo kmsProductVo = new KmsProductVo();
        kmsProductVo.setUsername(this.kmsProperties.getUsername());
        kmsProductVo.setUserId(this.kmsProperties.getUserId());
        kmsProductVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsProductVo.setIds(ids);
        String url = this.kmsProperties.getUrl() + "/shelfProductController/deleteShelfProductByIds?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsProductVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public PageResult<MdmShelfProductVo> page(MdmShelfProductVo mdmShelfProductVo) {
        List data;
        String directSystemId = mdmShelfProductVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        KmsProductVo kmsProductVo = new KmsProductVo();
        kmsProductVo.setDirectSystemId(mdmShelfProductVo.getDirectSystemId());
        kmsProductVo.setTenantryId(this.kmsProperties.getTenantryId());
        KmsProductPageReqVo kmsProductPageReqVo = new KmsProductPageReqVo();
        kmsProductPageReqVo.setUserId(this.kmsProperties.getUserId());
        kmsProductPageReqVo.setUsername(this.kmsProperties.getUsername());
        kmsProductPageReqVo.setTenantryId(this.kmsProperties.getTenantryId());
        String url = this.kmsProperties.getUrl() + "/shelfProductController/findShelfProductListByPage";
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsProductVo>>>> reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsProductVo>>>>(){};
        Integer current = Optional.ofNullable(mdmShelfProductVo.getPageNum()).orElse(1);
        Integer size = Optional.ofNullable(mdmShelfProductVo.getPageSize()).orElse(25);
        KmsPageVo kmsPageVo = new KmsPageVo(current, size);
        kmsProductPageReqVo.setPage(kmsPageVo);
        kmsProductPageReqVo.setReqVo(kmsProductVo);
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsProductPageReqVo, (ParameterizedTypeReference)reference);
        KmsPageResultVo pageResultVo = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).orElse(null);
        if (pageResultVo == null || pageResultVo.getRecords() == null || pageResultVo.getRecords() == 0) {
            PageResult emptyPage = new PageResult();
            emptyPage.setCount(Long.valueOf(0L));
            emptyPage.setData(Collections.emptyList());
            return emptyPage;
        }
        PageResult<MdmShelfProductVo> voPageResult = KmsConverter.INSTANCE.product2Mdm((KmsPageResultVo<KmsProductVo>)pageResultVo);
        if (voPageResult != null && !CollectionUtils.isEmpty((Collection)(data = voPageResult.getData()))) {
            data.forEach(x -> {
                x.setDirectSystemId(mdmShelfProductVo.getDirectSystemId());
                x.setDirectSystemName(mdmShelfProductVo.getDirectSystemName());
            });
        }
        return voPageResult;
    }
}

