/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.MdmUserRelWeChatOriginModuleEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelWeChatRespVo;
import com.biz.crm.user.mapper.MdmUserRelWeChatMapper;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.model.MdmUserRelWeChatEntity;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmUserRelWeChatServiceExpandImpl"})
public class MdmUserRelWeChatServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserRelWeChatMapper, MdmUserRelWeChatEntity>
implements MdmUserRelWeChatService {
    private static final Logger log = LoggerFactory.getLogger(MdmUserRelWeChatServiceImpl.class);
    @Resource
    private MdmUserRelWeChatMapper mdmUserRelWeChatMapper;
    @Resource
    private MdmUserService mdmUserService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bind(MdmUserRelWeChatReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        Assert.hasText((String)reqVo.getOriginModule(), (String)"\u7f3a\u5931\u5173\u8054\u5c0f\u7a0b\u5e8f\u6a21\u5757");
        MdmUserEntity one = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)reqVo.getUserName())).one());
        Assert.notNull((Object)((Object)one), (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        boolean uniqueCheck = false;
        if (MdmUserRelWeChatOriginModuleEnum.APPLET_SFA.getValue().equals(reqVo.getOriginModule())) {
            Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(one.getUserType()), (String)"\u975e\u4f01\u4e1a\u7528\u6237\u4e0d\u80fd\u7ed1\u5b9aSFA\u5c0f\u7a0b\u5e8f");
            uniqueCheck = YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"sfa_applet_user_unique_flag"));
        } else if (MdmUserRelWeChatOriginModuleEnum.APPLET_DMS.getValue().equals(reqVo.getOriginModule())) {
            Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(one.getUserType()), (String)"\u975e\u5ba2\u6237\u7528\u6237\u4e0d\u80fd\u7ed1\u5b9aDMS\u5c0f\u7a0b\u5e8f");
        } else {
            throw new BusinessException("\u5c0f\u7a0b\u5e8f\u6a21\u5757\u4e0d\u5b58\u5728");
        }
        if (uniqueCheck) {
            List userCheck = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)reqVo.getOriginModule())).eq(MdmUserRelWeChatEntity::getUserName, (Object)reqVo.getUserName())).ne(MdmUserRelWeChatEntity::getOpenId, (Object)reqVo.getOpenId())).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)userCheck), (String)"\u8be5\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5fae\u4fe1\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)reqVo.getOriginModule())).eq(MdmUserRelWeChatEntity::getOpenId, (Object)reqVo.getOpenId())).ne(MdmUserRelWeChatEntity::getUserName, (Object)reqVo.getUserName())).remove();
        List existCheck = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)reqVo.getOriginModule())).eq(MdmUserRelWeChatEntity::getUserName, (Object)reqVo.getUserName())).eq(MdmUserRelWeChatEntity::getOpenId, (Object)reqVo.getOpenId())).list();
        if (CollectionUtil.listEmpty((List)existCheck)) {
            if (StringUtils.isEmpty((String)reqVo.getLoginStatus())) {
                reqVo.setLoginStatus(YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            this.save(CrmBeanUtil.copy((Object)reqVo, MdmUserRelWeChatEntity.class));
        } else if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(((MdmUserRelWeChatEntity)((Object)existCheck.get(0))).getLoginStatus())) {
            ((MdmUserRelWeChatEntity)((Object)existCheck.get(0))).setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
            this.updateById(existCheck.get(0));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindByOpenId(String originModule, String openId) {
        if (!YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"sfa_applet_user_unique_flag"))) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)originModule)).eq(MdmUserRelWeChatEntity::getOpenId, (Object)openId)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeLoginStatus(String originModule, String openId, String loginStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)originModule)).eq(MdmUserRelWeChatEntity::getOpenId, (Object)openId)).set(MdmUserRelWeChatEntity::getLoginStatus, (Object)loginStatus)).update();
    }

    @Override
    public List<MdmUserRelWeChatRespVo> findUserRelWeChatList(String userName) {
        Assert.hasText((String)userName, (String)"\u7f3a\u5931\u7528\u6237\u540d");
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelWeChatEntity::getUserName, (Object)userName)).list().stream().map(x -> {
            MdmUserRelWeChatRespVo copy = (MdmUserRelWeChatRespVo)CrmBeanUtil.copy((Object)x, MdmUserRelWeChatRespVo.class);
            copy.setOriginModuleName(MdmUserRelWeChatOriginModuleEnum.getDesc((String)copy.getOriginModule()));
            return copy;
        }).collect(Collectors.toList());
    }
}

