/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.positionlevel.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.positionlevel.mapper.MdmPositionLevelRoleMapper;
import com.biz.crm.positionlevel.model.MdmPositionLevelRoleEntity;
import com.biz.crm.positionlevel.service.MdmPositionLevelRoleService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmPositionLevelRoleServiceExpandImpl"})
@Transactional(rollbackFor={Exception.class})
public class MdmPositionLevelRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionLevelRoleMapper, MdmPositionLevelRoleEntity>
implements MdmPositionLevelRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionLevelRoleServiceImpl.class);
    @Resource
    private MdmPositionLevelRoleMapper mdmPositionLevelRoleMapper;

    @Override
    public void replacePositionLevelRole(String positionLevelCode, List<String> roleCodes) {
        if (StringUtils.isNotEmpty((String)positionLevelCode)) {
            this.removePositionLevel(positionLevelCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes)) {
                roleCodes.stream().filter(StringUtils::isNotEmpty).forEach(roleCode -> {
                    MdmPositionLevelRoleEntity entity = new MdmPositionLevelRoleEntity();
                    entity.setPositionLevelCode(positionLevelCode);
                    entity.setRoleCode((String)roleCode);
                    this.save((Object)entity);
                });
            }
        }
    }

    @Override
    public void addPositionLevelRole(String positionLevelCode, List<String> roleCodes) {
        List collect;
        if (StringUtils.isNotEmpty((String)positionLevelCode) && CollectionUtil.listNotEmptyNotSizeZero(roleCodes) && CollectionUtil.listNotEmptyNotSizeZero(collect = roleCodes.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList()))) {
            Set exist = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionLevelRoleEntity::getPositionLevelCode, (Object)positionLevelCode)).in(MdmPositionLevelRoleEntity::getRoleCode, collect)).select(new SFunction[]{MdmPositionLevelRoleEntity::getRoleCode}).list().stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toSet());
            collect.stream().filter(x -> !exist.contains(x)).forEach(roleCode -> {
                MdmPositionLevelRoleEntity entity = new MdmPositionLevelRoleEntity();
                entity.setPositionLevelCode(positionLevelCode);
                entity.setRoleCode((String)roleCode);
                this.save((Object)entity);
            });
        }
    }

    @Override
    public void removePositionLevel(String positionLevelCode) {
        if (StringUtils.isNotEmpty((String)positionLevelCode)) {
            this.removePositionLevels(Collections.singletonList(positionLevelCode));
        }
    }

    @Override
    public void removePositionLevels(List<String> positionLevelCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionLevelCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionLevelRoleEntity::getPositionLevelCode, positionLevelCodes)).remove();
        }
    }

    @Override
    public void removeRoleCode(String roleCode) {
        if (StringUtils.isNotEmpty((String)roleCode)) {
            this.removeRoleCodes(Collections.singletonList(roleCode));
        }
    }

    @Override
    public void removeRoleCodes(List<String> roleCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionLevelRoleEntity::getRoleCode, roleCodes)).remove();
        }
    }
}

