/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.config.CrmDataSource;
import com.biz.crm.config.DataSourceType;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.model.DmsAcceptanceVoucherEntity;
import com.biz.crm.kms.model.DmsIndentVoucherEntity;
import com.biz.crm.kms.model.DmsPriceVoucherEntity;
import com.biz.crm.kms.model.DmsReturnVoucherEntity;
import com.biz.crm.kms.service.DmsAcceptanceVoucherService;
import com.biz.crm.kms.service.DmsIndentVoucherService;
import com.biz.crm.kms.service.DmsPriceVoucherService;
import com.biz.crm.kms.service.DmsReturnVoucherService;
import com.biz.crm.kms.service.KmsOrderService;
import com.biz.crm.nebular.mdm.kms.api.KmsAcceptanceVoucherVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRulePageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.api.KmsIndentVoucherVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPriceVoucherVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultBodyVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsReturnVoucherVo;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"KmsOrderServiceExpandImpl"})
@CrmDataSource(value=DataSourceType.SLAVE)
public class KmsOrderServiceImpl
implements KmsOrderService {
    @Autowired
    private KmsProperties kmsProperties;
    @Autowired
    private DmsAcceptanceVoucherService dmsAcceptanceVoucherService;
    @Autowired
    private DmsIndentVoucherService dmsIndentVoucherService;
    @Autowired
    private DmsReturnVoucherService dmsReturnVoucherService;
    @Autowired
    private DmsPriceVoucherService dmsPriceVoucherService;

    @Override
    public void fetchAcceptanceOrder() {
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsAcceptanceVoucherVo>>>> reference;
        String bsInvoiceId = "412d45400bf6711005483f0b865dd7dc";
        KmsGrabRulePageVo kmsGrabRulePageVo = this.setUpOrderReq(bsInvoiceId);
        String url = this.kmsProperties.getUrl() + "/orderController/findOrderListByPage";
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsAcceptanceVoucherVo>>>>(){}));
        List kmsAcceptanceVoucherVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).map(KmsPageResultVo::getRows).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsAcceptanceVoucherVos)) {
            return;
        }
        List<DmsAcceptanceVoucherEntity> list = KmsConverter.INSTANCE.acceptance2entity(kmsAcceptanceVoucherVos);
        this.dmsAcceptanceVoucherService.saveOrUpdateBatch(list);
    }

    @Override
    public void fetchIndentOrder() {
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsIndentVoucherVo>>>> reference;
        String bsInvoiceId = "c7074fa4d375b74399eadc78b04eb15e";
        KmsGrabRulePageVo kmsGrabRulePageVo = this.setUpOrderReq(bsInvoiceId);
        String url = this.kmsProperties.getUrl() + "/orderController/findOrderListByPage";
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsIndentVoucherVo>>>>(){}));
        List kmsIndentVoucherVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).map(KmsPageResultVo::getRows).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsIndentVoucherVos)) {
            return;
        }
        List<DmsIndentVoucherEntity> list = KmsConverter.INSTANCE.indent2entity(kmsIndentVoucherVos);
        this.dmsIndentVoucherService.saveOrUpdateBatch(list);
    }

    @Override
    public void fetchPriceOrder() {
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsPriceVoucherVo>>>> reference;
        String bsInvoiceId = "c7074fa4d375b74399eadc78b04eb15e";
        KmsGrabRulePageVo kmsGrabRulePageVo = this.setUpOrderReq(bsInvoiceId);
        String url = this.kmsProperties.getUrl() + "/orderController/findOrderListByPage";
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsPriceVoucherVo>>>>(){}));
        List kmsPriceVoucherVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).map(KmsPageResultVo::getRows).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsPriceVoucherVos)) {
            return;
        }
        List<DmsPriceVoucherEntity> list = KmsConverter.INSTANCE.price2entity(kmsPriceVoucherVos);
        this.dmsPriceVoucherService.saveOrUpdateBatch(list);
    }

    @Override
    public void fetchReturnOrder() {
        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsReturnVoucherVo>>>> reference;
        String bsInvoiceId = "b28472db89aa83022142788598480ce5";
        KmsGrabRulePageVo kmsGrabRulePageVo = this.setUpOrderReq(bsInvoiceId);
        String url = this.kmsProperties.getUrl() + "/orderController/findOrderListByPage";
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)(reference = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsReturnVoucherVo>>>>(){}));
        List kmsReturnVoucherVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsResultBodyVo::getBody).map(KmsPageResultVo::getRows).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsReturnVoucherVos)) {
            return;
        }
        List<DmsReturnVoucherEntity> list = KmsConverter.INSTANCE.return2entity(kmsReturnVoucherVos);
        this.dmsReturnVoucherService.saveOrUpdateBatch(list);
    }

    protected KmsGrabRulePageVo setUpOrderReq(String bsInvoiceId) {
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setBsInvoiceId(bsInvoiceId);
        kmsGrabRuleVo.setFieldCategory("INVOICE");
        KmsPageVo kmsPageVo = new KmsPageVo(Integer.valueOf(0), Integer.valueOf(-1));
        KmsGrabRulePageVo kmsGrabRulePageVo = new KmsGrabRulePageVo();
        kmsGrabRulePageVo.setPage(kmsPageVo);
        kmsGrabRulePageVo.setReqVo(kmsGrabRuleVo);
        kmsGrabRulePageVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRulePageVo.setUserId(this.kmsProperties.getUserId());
        kmsGrabRulePageVo.setUsername(this.kmsProperties.getUsername());
        return kmsGrabRulePageVo;
    }
}

