/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmCustomerAccountService;
import com.biz.crm.nebular.mdm.kms.MdmCustomerAccountVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.api.KmsCustomerAccountPageReqVo;
import com.biz.crm.nebular.mdm.kms.api.KmsCustomerAccountVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabStoreVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerAccountServiceExpandImpl"})
public class MdmCustomerAccountServiceImpl
implements MdmCustomerAccountService {
    @Autowired
    private KmsProperties kmsProperties;

    @Override
    public PageResult<MdmCustomerAccountVo> page(MdmCustomerAccountVo mdmCustomerAccountVo) {
        List data;
        Integer current = Optional.ofNullable(mdmCustomerAccountVo.getPageNum()).orElse(1);
        Integer size = Optional.ofNullable(mdmCustomerAccountVo.getPageSize()).orElse(25);
        KmsPageVo kmsPageVo = new KmsPageVo(current, size);
        KmsCustomerAccountVo kmsCustomerAccountVo = new KmsCustomerAccountVo();
        String directSystemId = mdmCustomerAccountVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        kmsCustomerAccountVo.setDirectSystemId(directSystemId);
        kmsCustomerAccountVo.setTenantryId(this.kmsProperties.getTenantryId());
        KmsCustomerAccountPageReqVo kmsCustomerAccountPageReqVo = new KmsCustomerAccountPageReqVo();
        kmsCustomerAccountPageReqVo.setPage(kmsPageVo);
        kmsCustomerAccountPageReqVo.setReqVo(kmsCustomerAccountVo);
        kmsCustomerAccountPageReqVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsCustomerAccountPageReqVo.setUserId(this.kmsProperties.getUserId());
        kmsCustomerAccountPageReqVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/ruleAccountController/findRuleAccountListByPage";
        ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsCustomerAccountVo>>> reference = new ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsCustomerAccountVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsCustomerAccountPageReqVo, (ParameterizedTypeReference)reference);
        KmsPageResultVo kmsCustomerAccountVoKmsPageResultVo = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (kmsCustomerAccountVoKmsPageResultVo == null) {
            PageResult mdmCustomerAccountVoPageResult = new PageResult();
            mdmCustomerAccountVoPageResult.setCount(Long.valueOf(0L));
            mdmCustomerAccountVoPageResult.setData(Collections.emptyList());
            return mdmCustomerAccountVoPageResult;
        }
        PageResult<MdmCustomerAccountVo> mdmCustomerAccountVoPageResult = KmsConverter.INSTANCE.customerAccountPage((KmsPageResultVo<KmsCustomerAccountVo>)kmsCustomerAccountVoKmsPageResultVo);
        if (mdmCustomerAccountVoPageResult != null && !CollectionUtils.isEmpty((Collection)(data = mdmCustomerAccountVoPageResult.getData()))) {
            data.forEach(x -> {
                x.setAccountId(x.getId());
                x.setDirectSystemId(mdmCustomerAccountVo.getDirectSystemId());
                x.setDirectSystemName(mdmCustomerAccountVo.getDirectSystemName());
            });
        }
        return mdmCustomerAccountVoPageResult;
    }

    @Override
    public void save(MdmCustomerAccountVo mdmCustomerAccountVo) {
        mdmCustomerAccountVo.setId(null);
        Assert.hasText((String)mdmCustomerAccountVo.getLoginAcc(), (String)"\u5ba2\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmCustomerAccountVo.getDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        KmsCustomerAccountVo kmsCustomerAccountVo = KmsConverter.INSTANCE.customerAccount2Kms(mdmCustomerAccountVo);
        kmsCustomerAccountVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsCustomerAccountVo.setUserId(this.kmsProperties.getUserId());
        kmsCustomerAccountVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/ruleAccountController/saveRuleAccount?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsCustomerAccountVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public void update(MdmCustomerAccountVo mdmCustomerAccountVo) {
        Assert.hasText((String)mdmCustomerAccountVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmCustomerAccountVo.getLoginAcc(), (String)"\u5ba2\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmCustomerAccountVo.getDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        KmsCustomerAccountVo kmsCustomerAccountVo = KmsConverter.INSTANCE.customerAccount2Kms(mdmCustomerAccountVo);
        kmsCustomerAccountVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsCustomerAccountVo.setUserId(this.kmsProperties.getUserId());
        kmsCustomerAccountVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/ruleAccountController/updatePass?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsCustomerAccountVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25");
        }
    }

    @Override
    public void delete(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsCustomerAccountVo kmsCustomerAccountVo = new KmsCustomerAccountVo();
        kmsCustomerAccountVo.setIds(ids);
        kmsCustomerAccountVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsCustomerAccountVo.setUserId(this.kmsProperties.getUserId());
        kmsCustomerAccountVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/ruleAccountController/deleteRuleAccount?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsCustomerAccountVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public List<KmsGrabStoreVo> findGrabStoreList(MdmGrabRuleVo mdmGrabRuleVo) {
        String directSystemId = mdmGrabRuleVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String invoiceId = mdmGrabRuleVo.getInvoiceId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("directSystemId", directSystemId);
        map.put("userId", this.kmsProperties.getUserId());
        map.put("username", this.kmsProperties.getUsername());
        map.put("tenantryId", this.kmsProperties.getTenantryId());
        String url = this.kmsProperties.getUrl() + "/storeGroupController/findStoreGroupTreeListOnlyGroup";
        ParameterizedTypeReference<KmsResultVo<List<KmsGrabStoreVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<KmsGrabStoreVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, map, (ParameterizedTypeReference)reference);
        List kmsGrabStoreVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(Collections.emptyList());
        List<KmsGrabStoreVo> collect = kmsGrabStoreVos.stream().filter(MdmCustomerAccountServiceImpl.distinctByKey(KmsGrabStoreVo::getId)).collect(Collectors.toList());
        for (KmsGrabStoreVo kmsGrabStoreVo : collect) {
            kmsGrabStoreVo.setChildList(this.distinctId(kmsGrabStoreVo.getChildList()));
        }
        return collect;
    }

    private List<KmsGrabStoreVo> distinctId(List<KmsGrabStoreVo> childList) {
        if (CollectionUtils.isEmpty(childList)) {
            return Collections.emptyList();
        }
        for (KmsGrabStoreVo kmsGrabStoreVo : childList) {
            kmsGrabStoreVo.setChildList(this.distinctId(kmsGrabStoreVo.getChildList()));
        }
        return childList.stream().filter(MdmCustomerAccountServiceImpl.distinctByKey(KmsGrabStoreVo::getId)).collect(Collectors.toList());
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

