/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.approval.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.approval.mapper.MdmApprovalConfigMapper;
import com.biz.crm.approval.model.MdmApprovalConfigEntity;
import com.biz.crm.approval.service.MdmApprovalConfigConditionService;
import com.biz.crm.approval.service.MdmApprovalConfigService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigConditionRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigConditionRespVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRespVo;
import com.biz.crm.util.ApprovalConfigUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmApprovalConfigServiceExpandImpl"})
public class MdmApprovalConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmApprovalConfigMapper, MdmApprovalConfigEntity>
implements MdmApprovalConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdmApprovalConfigServiceImpl.class);
    @Resource
    private MdmApprovalConfigMapper mdmApprovalConfigMapper;
    @Resource
    private MdmApprovalConfigConditionService mdmApprovalConfigConditionService;

    @Override
    public PageResult<MdmApprovalConfigRespVo> findList(MdmApprovalConfigReqVo reqVo) {
        Assert.hasText((String)reqVo.getMenuCode(), (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmApprovalConfigRespVo> list = this.mdmApprovalConfigMapper.findList((Page<MdmApprovalConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmApprovalConfigRespVo queryById(String id) {
        Assert.hasText((String)id, (String)"\u7f3a\u5931id");
        MdmApprovalConfigEntity entity = (MdmApprovalConfigEntity)this.getById((Serializable)((Object)id));
        if (entity != null) {
            MdmApprovalConfigRespVo respVo = (MdmApprovalConfigRespVo)CrmBeanUtil.copy((Object)entity, MdmApprovalConfigRespVo.class);
            respVo.setConditionList(this.mdmApprovalConfigConditionService.findConditionList(respVo.getMenuCode(), respVo.getBusinessCode()));
            return respVo;
        }
        return null;
    }

    @Override
    public MdmApprovalConfigRedisVo queryForRedis(String menuCode, String businessCode) {
        Assert.hasText((String)menuCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        MdmApprovalConfigEntity entity = (MdmApprovalConfigEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmApprovalConfigEntity::getMenuCode, (Object)menuCode)).eq(MdmApprovalConfigEntity::getBusinessCode, (Object)businessCode)).one();
        if (entity != null) {
            MdmApprovalConfigRedisVo redisVo = (MdmApprovalConfigRedisVo)CrmBeanUtil.copy((Object)entity, MdmApprovalConfigRedisVo.class);
            List<MdmApprovalConfigConditionRespVo> conditionList = this.mdmApprovalConfigConditionService.findConditionList(menuCode, businessCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(conditionList)) {
                redisVo.setConditionList(CrmBeanUtil.copyList(conditionList, MdmApprovalConfigConditionRedisVo.class));
            }
            return redisVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmApprovalConfigReqVo reqVo) {
        reqVo.setId(null);
        this.verify(reqVo);
        MdmApprovalConfigEntity entity = (MdmApprovalConfigEntity)CrmBeanUtil.copy((Object)reqVo, MdmApprovalConfigEntity.class);
        this.save(entity);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getConditionList())) {
            this.mdmApprovalConfigConditionService.saveConditionList(reqVo.getMenuCode(), reqVo.getBusinessCode(), reqVo.getConditionList());
        }
        ApprovalConfigUtil.deleteCache((String)entity.getMenuCode(), (String)entity.getBusinessCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmApprovalConfigReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        this.verify(reqVo);
        MdmApprovalConfigEntity entity = (MdmApprovalConfigEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.mdmApprovalConfigConditionService.deleteConditionList(entity.getMenuCode(), entity.getBusinessCode());
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)entity);
        this.updateById(entity);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getConditionList())) {
            this.mdmApprovalConfigConditionService.saveConditionList(reqVo.getMenuCode(), reqVo.getBusinessCode(), reqVo.getConditionList());
        }
        ApprovalConfigUtil.deleteCache((String)entity.getMenuCode(), (String)entity.getBusinessCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notNull(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(item -> this.mdmApprovalConfigConditionService.deleteConditionList(item.getMenuCode(), item.getBusinessCode()));
            this.removeByIds(list.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
            list.forEach(item -> ApprovalConfigUtil.deleteCache((String)item.getMenuCode(), (String)item.getBusinessCode()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMenuCode(List<String> menuCodeList) {
        Assert.notNull(menuCodeList, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmApprovalConfigEntity::getMenuCode, menuCodeList)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            this.mdmApprovalConfigConditionService.deleteConditionListByMenuCode(list.stream().map(MdmApprovalConfigEntity::getMenuCode).distinct().collect(Collectors.toList()));
            this.deleteBatch(list.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
            list.forEach(item -> ApprovalConfigUtil.deleteCache((String)item.getMenuCode()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notNull(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(item -> item.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
            this.updateBatchById(list);
            list.forEach(item -> ApprovalConfigUtil.deleteCache((String)item.getMenuCode(), (String)item.getBusinessCode()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notNull(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(item -> item.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
            this.updateBatchById(list);
            list.forEach(item -> ApprovalConfigUtil.deleteCache((String)item.getMenuCode(), (String)item.getBusinessCode()));
        }
    }

    private void verify(MdmApprovalConfigReqVo reqVo) {
        Assert.hasText((String)reqVo.getMenuCode(), (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801");
        Assert.hasText((String)reqVo.getBusinessCode(), (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        Assert.hasText((String)reqVo.getBusinessName(), (String)"\u7f3a\u5931\u4e1a\u52a1\u540d\u79f0");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmApprovalConfigEntity::getMenuCode, (Object)reqVo.getMenuCode())).eq(MdmApprovalConfigEntity::getBusinessCode, (Object)reqVo.getBusinessCode())).ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u5df2\u5b58\u5728");
    }
}

