/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmSfaAppletLoginService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmSfaAppletLoginServiceExpandImpl"})
public class MdmSfaAppletLoginServiceImpl
implements MdmSfaAppletLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmSfaAppletLoginServiceImpl.class);
    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;
    @Autowired
    private MdmUserRelWeChatService mdmUserRelWeChatService;

    @Override
    public MdmLoginRespVo sfaAppletLogin(MdmLoginReqVo mdmLoginReqVo) {
        return this.mdmSystemLoginService.systemLogin(mdmLoginReqVo);
    }

    @Override
    public MdmLoginRespVo sfaAppletLoginByOpenId(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        return this.mdmSystemLoginService.sfaAppletLoginByOpenId(reqVo);
    }

    @Override
    public MdmLoginRespVo sfaAppletLoginAndBind(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        return this.mdmSystemLoginService.sfaAppletLoginAndBind(reqVo);
    }

    @Override
    public void sfaAppletLogout() {
        UserRedis user = UserUtils.getUser();
        if (user != null && StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
            this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        UserUtils.logout((String)LoginFromTypeEnum.APPLET_SFA.getValue());
    }
}

