/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.approval.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.approval.service.MdmApprovalConfigService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmApprovalConfigController"})
@Api(tags={"MDM-\u5ba1\u6279\u914d\u7f6e\u4e3b\u8868"})
@CrmGlobalLog
public class MdmApprovalConfigController {
    private static final Logger log = LoggerFactory.getLogger(MdmApprovalConfigController.class);
    @Autowired
    private MdmApprovalConfigService mdmApprovalConfigService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public Result<PageResult<MdmApprovalConfigRespVo>> pageList(@RequestBody MdmApprovalConfigReqVo mdmApprovalConfigReqVo) {
        PageResult<MdmApprovalConfigRespVo> result = this.mdmApprovalConfigService.findList(mdmApprovalConfigReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u7f16\u8f91\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryForUpdate"})
    public Result<MdmApprovalConfigRespVo> queryForUpdate(@RequestParam(value="id", required=true) String id) {
        MdmApprovalConfigRespVo respVo = this.mdmApprovalConfigService.queryById(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmApprovalConfigReqVo mdmApprovalConfigReqVo) {
        this.mdmApprovalConfigService.save(mdmApprovalConfigReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmApprovalConfigReqVo mdmApprovalConfigReqVo) {
        this.mdmApprovalConfigService.update(mdmApprovalConfigReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmApprovalConfigService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmApprovalConfigService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmApprovalConfigService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\uff08\u8bf7\u52ff\u8c03\u7528\uff09\u67e5\u8be2redis\u5f85\u7f13\u5b58\u6570\u636e", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="menuCode", value="\u83dc\u5355\u7f16\u7801", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="businessCode", value="\u4e1a\u52a1\u7f16\u7801", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/queryForRedis"})
    public Result<MdmApprovalConfigRedisVo> queryForRedis(@RequestParam(value="menuCode", required=true) String menuCode, @RequestParam(value="businessCode", required=true) String businessCode) {
        return Result.ok((Object)this.mdmApprovalConfigService.queryForRedis(menuCode, businessCode));
    }
}

