/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.service.MdmCategoryService;
import com.biz.crm.nebular.mdm.kms.api.KmsCategoryVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCategoryExpandImpl"})
public class MdmCategoryServiceImpl
implements MdmCategoryService {
    private static final Logger log = LoggerFactory.getLogger(MdmCategoryServiceImpl.class);
    @Autowired
    private KmsProperties kmsProperties;

    @Override
    public KmsCategoryVo add(KmsCategoryVo kmsCategoryVo) {
        if (StringUtils.isEmpty((Object)this.kmsProperties.getUserId())) {
            log.info("[\u4ea7\u54c1\u5206\u7c7b][kmsProperties]:{}", (Object)this.kmsProperties);
            return kmsCategoryVo;
        }
        Assert.hasText((String)kmsCategoryVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        kmsCategoryVo.setId(kmsCategoryVo.getId());
        kmsCategoryVo.setUserId(this.kmsProperties.getUserId());
        kmsCategoryVo.setUsername(this.kmsProperties.getUsername());
        kmsCategoryVo.setTenantryId(this.kmsProperties.getTenantryId());
        String url = this.kmsProperties.getUrl() + "/KmsProCategoryController/addProCategory?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsCategoryVo, String.class);
        log.info("[\u4ea7\u54c1\u5206\u7c7b][\u65b0\u589e]result:{}", (Object)entity);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25");
        }
        return kmsCategoryVo;
    }

    @Override
    public MdmProductLevelReqVo add(MdmProductLevelReqVo mdmProductLevelReqVo) {
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelCode(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        KmsCategoryVo kmsCategoryVo = this.convertCategory(mdmProductLevelReqVo, mdmProductLevelReqVo.getProductLevelCode());
        this.add(kmsCategoryVo);
        return mdmProductLevelReqVo;
    }

    protected KmsCategoryVo convertCategory(MdmProductLevelReqVo mdmProductLevelReqVo, String productLevelCode) {
        KmsCategoryVo kmsCategoryVo = new KmsCategoryVo();
        kmsCategoryVo.setId(productLevelCode);
        kmsCategoryVo.setPid(mdmProductLevelReqVo.getParentCode());
        kmsCategoryVo.setProCategoryDescription(mdmProductLevelReqVo.getRemarks());
        kmsCategoryVo.setProCategoryName(mdmProductLevelReqVo.getProductLevelName());
        return kmsCategoryVo;
    }

    public void update(MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.remove(mdmProductLevelReqVo.getProductLevelCode());
        this.add(mdmProductLevelReqVo);
    }

    public void remove(String productLevelCode) {
        if (StringUtils.isEmpty((Object)productLevelCode)) {
            return;
        }
        KmsCategoryVo kmsCategoryVo = new KmsCategoryVo();
        kmsCategoryVo.setId(productLevelCode);
        kmsCategoryVo.setUserId(this.kmsProperties.getUserId());
        kmsCategoryVo.setUsername(this.kmsProperties.getUsername());
        kmsCategoryVo.setTenantryId(this.kmsProperties.getTenantryId());
        String url = this.kmsProperties.getUrl() + "/KmsProCategoryController/deleteById?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsCategoryVo, String.class);
        log.info("[\u4ea7\u54c1\u5206\u7c7b][\u5220\u9664]result:{}", (Object)entity);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
    }
}

