/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionSelectRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangeHeadReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserForceChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserParentPositionSelectReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPositionSelectReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserSelectReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelWeChatRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserSelectRespVo;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmUserController"})
@Api(tags={"MDM-\u7528\u6237\u7ba1\u7406\uff08\u4f01\u4e1a\u7528\u6237\uff09"})
public class MdmUserController {
    private static final Logger log = LoggerFactory.getLogger(MdmUserController.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmUserRelWeChatService mdmUserRelWeChatService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    @CrmLog
    public Result<PageResult<MdmUserPageRespVo>> pageList(@RequestBody MdmUserPageReqVo reqVo) {
        PageResult<MdmUserPageRespVo> result = this.mdmUserService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="POST")
    @PostMapping(value={"/query"})
    @CrmLog
    @CrmDictMethod
    public Result<MdmUserRespVo> query(@RequestBody MdmUserReqVo mdmUserReqVo) {
        return Result.ok((Object)this.mdmUserService.detail(mdmUserReqVo.getId(), mdmUserReqVo.getUserName()));
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u540d", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmLog
    @CrmDictMethod
    public Result<MdmUserRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="userName", required=false) String userName) {
        return Result.ok((Object)this.mdmUserService.detail(id, userName));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody MdmUserEditReqVo reqVo) {
        this.mdmUserService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmUserEditReqVo reqVo) {
        this.mdmUserService.update(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.mdmUserService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.mdmUserService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.mdmUserService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @PostMapping(value={"/changePassword"})
    public Result changePassword(@RequestBody MdmUserChangePasswordReqVo reqVo) {
        this.mdmUserService.changePassword(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7528\u6237\u89e3\u9501", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unlock"})
    @CrmLog
    public Result unlock(@RequestBody List<String> ids) {
        this.mdmUserService.unlock(ids);
        return Result.ok((String)"\u89e3\u9501\u6210\u529f");
    }

    @ApiOperation(value="\uff08\u8fc7\u671f\uff09\u67e5\u8be2\u7528\u6237\u5173\u8054\u7684\u5fae\u4fe1\u5217\u8868", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u540d", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/findUserRelWeChatList"})
    public Result<List<MdmUserRelWeChatRespVo>> findUserRelWeChatList(@RequestParam(value="userName", required=true) String userName) {
        return Result.ok(this.mdmUserRelWeChatService.findUserRelWeChatList(new MdmUserRelWeChatReqVo().setUserName(userName)));
    }

    @ApiOperation(value="\uff08\u8fc7\u671f\uff09\u89e3\u7ed1\u6307\u5b9a\u5173\u8054\u7684\u5fae\u4fe1", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u7528\u6237\u5173\u8054\u5fae\u4fe1\u8868\u7684id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unbindUserWeChat"})
    public Result unbindUserWeChat(@RequestBody List<String> ids) {
        this.mdmUserRelWeChatService.unbindByIds(ids);
        return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
    }

    @ApiOperation(value="\u89e3\u7ed1\u7528\u6237\u5168\u90e8\u5173\u8054\u5fae\u4fe1", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u7528\u6237id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unbindWeChat"})
    public Result unbindWeChat(@RequestBody List<String> ids) {
        this.mdmUserService.unbindWeChat(ids);
        return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
    }

    @ApiOperation(value="\u5f3a\u5236\u6279\u91cf\u4fee\u6539\u5bc6\u7801", httpMethod="POST")
    @PostMapping(value={"/forceChangePassword"})
    public Result forceChangePassword(@RequestBody MdmUserForceChangePasswordReqVo reqVo) {
        this.mdmUserService.forceChangePassword(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u7528\u6237\u57fa\u672c\u4fe1\u606f\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list_detail"})
    public Result<List<MdmUserRespVo>> listDetail(@RequestBody MdmUserReqVo mdmUserReqVo) {
        return Result.ok(this.mdmUserService.listDetail(mdmUserReqVo));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4f01\u4e1a\u7528\u6237\u7684\u5f53\u524d\u804c\u4f4d\u5173\u8054\u7684\u4e2a\u4eba\u4fe1\u606f\u8be6\u60c5")
    @GetMapping(value={"/getCurUserPositionDetail"})
    public Result<MdmPositionUserOrgRespVo> getCurUserPositionDetail() {
        return Result.ok((Object)this.mdmUserService.getCurUserPositionDetail());
    }

    @ApiOperation(value="\uff08\u8fc7\u671f\uff09\u91cd\u7f6e\u4f01\u4e1a\u7528\u6237\u4e0a\u5197\u4f59\u7684\u804c\u4f4d\u7f16\u7801\u540d\u79f0")
    @PostMapping(value={"/resetUserRedundancy"})
    public Result resetUserRedundancy() {
        this.mdmUserService.resetUserRedundancy();
        return Result.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5934\u50cf")
    @PostMapping(value={"/changeUserHeadUrl"})
    public Result changeUserHeadUrl(@RequestBody MdmUserChangeHeadReqVo reqVo) {
        this.mdmUserService.changeUserHeadUrl(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\uff08\u7528\u6237\u65b0\u589e\u7f16\u8f91\u4e13\u7528\uff09\u67e5\u8be2\u5df2\u6709\u804c\u4f4d\u4e0b\u62c9\u6846\u5217\u8868", notes="\u67e5\u8be2\u975e\u4e3b\u804c\u4f4d\u6216\u8005\u672a\u5173\u8054\u7528\u6237\u7684\u4e3b\u804c\u4f4d\uff0c\u53ea\u67e5\u542f\u7528\u7684\uff0c\u7ec4\u7ec7\u76f4\u63a5\u5173\u8054\u7684")
    @PostMapping(value={"/findUserPositionSelectList"})
    public Result<List<MdmPositionSelectRespVo>> findUserPositionSelectList(@RequestBody MdmUserPositionSelectReqVo reqVo) {
        return Result.ok(this.mdmUserService.findUserPositionSelectList(reqVo));
    }

    @ApiOperation(value="\uff08\u7528\u6237\u65b0\u589e\u7f16\u8f91\u4e13\u7528\uff09\u67e5\u8be2\u4e0a\u7ea7\u804c\u4f4d\u4e0b\u62c9\u6846\u5217\u8868", notes="\u67e5\u8be2\u542f\u7528\u3001\u6392\u9664\u5f53\u524d\u7528\u6237\u3001\u6392\u9664\u7ec4\u7ec7\u4e0b\u7ea7\u3001\u6392\u9664\u804c\u4f4d\u4e0b\u7ea7\u804c\u4f4d\u5bf9\u5e94\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7")
    @PostMapping(value={"/findUserParentPositionSelectList"})
    public Result<List<MdmPositionSelectRespVo>> findUserParentPositionSelectList(@RequestBody MdmUserParentPositionSelectReqVo reqVo) {
        return Result.ok(this.mdmUserService.findUserParentPositionSelectList(reqVo));
    }

    @ApiOperation(value="\u4f01\u4e1a\u7528\u6237\u4e0b\u62c9\u6846", notes="")
    @PostMapping(value={"/findUserSelectList"})
    public Result<List<MdmUserSelectRespVo>> findUserSelectList(@RequestBody MdmUserSelectReqVo reqVo) {
        return Result.ok(this.mdmUserService.findUserSelectList(reqVo));
    }
}

