/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmProService;
import com.biz.crm.nebular.mdm.kms.api.KmsProInsertVo;
import com.biz.crm.nebular.mdm.kms.api.KmsProVo;
import com.biz.crm.nebular.mdm.kms.api.KmsUnitVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmProServiceExpandImpl"})
public class MdmProServiceImpl
implements MdmProService {
    private static final Logger log = LoggerFactory.getLogger(MdmProServiceImpl.class);
    @Value(value="${jobId:jobId}")
    private String jobId;
    @Value(value="${proBrand:proBrand}")
    private String proBrand;
    @Autowired
    private KmsProperties kmsProperties;
    @Autowired
    private MdmDictDataService mdmDictDataService;

    @Override
    public void add(KmsProVo kmsProVo) {
        KmsProInsertVo kmsProInsertVo = new KmsProInsertVo();
        kmsProInsertVo.setMap(kmsProVo);
        kmsProInsertVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsProInsertVo.setUserId(this.kmsProperties.getUserId());
        kmsProInsertVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/KmsProDetailsController/addProDetails?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsProInsertVo, String.class);
        log.info("[kms\u5546\u54c1][\u65b0\u589e]entity:{}", (Object)entity);
    }

    public void add(MdmProductReqVo mdmProductReqVo) {
        KmsProVo kmsProVo = KmsConverter.INSTANCE.product2Kms(mdmProductReqVo);
        kmsProVo.setJob(this.jobId);
        kmsProVo.setProBrand(this.proBrand);
        kmsProVo.setUnit(this.convertUnit(mdmProductReqVo));
        this.add(kmsProVo);
    }

    protected List<KmsUnitVo> convertUnit(MdmProductReqVo mdmProductReqVo) {
        String saleUnit = mdmProductReqVo.getSaleUnit();
        if (StringUtils.isEmpty((Object)saleUnit)) {
            return Collections.emptyList();
        }
        MdmDictDataEntity one = (MdmDictDataEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmDictDataService.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)"product_sale_unit")).eq(MdmDictDataEntity::getDictCode, (Object)saleUnit)).select(new SFunction[]{BaseIdEntity::getId}).one();
        if (one == null) {
            return Collections.emptyList();
        }
        KmsUnitVo kmsUnitVo = new KmsUnitVo();
        kmsUnitVo.setSupplementaryUnitId(one.getId());
        return Collections.singletonList(kmsUnitVo);
    }

    @Override
    public void update(KmsProVo kmsProVo) {
    }

    @Override
    public void update(MdmProductReqVo mdmProductReqVo) {
        String accessToken = this.kmsProperties.getAccessToken();
        log.info("[kms\u5546\u54c1][update]kmsproperties:{}", (Object)this.kmsProperties);
        if (StringUtils.isEmpty((Object)accessToken)) {
            return;
        }
        String url = this.kmsProperties.getUrl() + "/KmsProDetailsController/updateProDetails?access_token=" + this.kmsProperties.getAccessToken();
        KmsProVo kmsProVo = KmsConverter.INSTANCE.product2Kms(mdmProductReqVo);
        kmsProVo.setJob(this.jobId);
        kmsProVo.setProBrand(this.proBrand);
        kmsProVo.setUnit(this.convertUnit(mdmProductReqVo));
        KmsProInsertVo kmsProInsertVo = new KmsProInsertVo();
        kmsProInsertVo.setMap(kmsProVo);
        kmsProInsertVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsProInsertVo.setUserId(this.kmsProperties.getUserId());
        kmsProInsertVo.setUsername(this.kmsProperties.getUsername());
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsProInsertVo, String.class);
        log.info("[kms\u5546\u54c1][update]entity:{}", (Object)entity);
    }

    @Override
    public void remove(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return;
        }
        for (String id : productCodeList) {
            if (StringUtils.isEmpty((Object)id)) continue;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("tenantryId", this.kmsProperties.getTenantryId());
            paramMap.put("userId", this.kmsProperties.getUserId());
            paramMap.put("username", this.kmsProperties.getUsername());
            paramMap.put("id", id);
            String url = this.kmsProperties.getUrl() + "/KmsProDetailsController/deleteById?access_token=" + this.kmsProperties.getAccessToken();
            ResponseEntity enitty = RestTemplateUtils.postForEntity((String)url, null, paramMap, String.class);
            log.info("[kms\u5546\u54c1][\u5220\u9664]entity:{}", (Object)enitty);
        }
    }
}

