/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.service.MdmUnitService;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.kms.api.KmsUnitVo;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmUnitServiceExpandImpl"})
public class MdmUnitServiceImpl
implements MdmUnitService {
    private static final Logger log = LoggerFactory.getLogger(MdmUnitServiceImpl.class);
    @Value(value="${proUnitLevel:BASE}")
    private String proUnitLevel;
    @Autowired
    private KmsProperties kmsProperties;
    private static final String PRODUCT_SALE_UNIT = "product_sale_unit";

    @Override
    public void add(KmsUnitVo kmsUnitVo) {
        kmsUnitVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsUnitVo.setUserId(this.kmsProperties.getUserId());
        kmsUnitVo.setUsername(this.kmsProperties.getUsername());
        kmsUnitVo.setProUnitLevel(this.proUnitLevel);
        String url = this.kmsProperties.getUrl() + "/KmsProUnitController/addProUnit?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsUnitVo, String.class);
        log.info("[kms\u5355\u4f4d][add]entity:{}", (Object)entity);
    }

    @Override
    public void add(MdmDictDataReqVo mdmDictDataReqVo) {
        if (this.valid(mdmDictDataReqVo)) {
            return;
        }
        String id = mdmDictDataReqVo.getId();
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        KmsUnitVo kmsUnitVo = new KmsUnitVo();
        kmsUnitVo.setId(id);
        kmsUnitVo.setProUnitName(mdmDictDataReqVo.getDictValue());
        this.add(kmsUnitVo);
    }

    protected boolean valid(MdmDictDataReqVo mdmDictDataReqVo) {
        String accessToken = this.kmsProperties.getAccessToken();
        log.info("[kms\u5355\u4f4d][add]kmsproperties:{}", (Object)this.kmsProperties);
        if (StringUtils.isEmpty((Object)accessToken)) {
            return true;
        }
        String dictCode = mdmDictDataReqVo.getDictCode();
        return StringUtils.isEmpty((Object)dictCode) || !dictCode.equals(PRODUCT_SALE_UNIT);
    }

    @Override
    public void update(MdmDictDataReqVo mdmDictDataReqVo) {
        if (this.valid(mdmDictDataReqVo)) {
            return;
        }
        KmsUnitVo kmsUnitVo = new KmsUnitVo();
        kmsUnitVo.setId(mdmDictDataReqVo.getId());
        kmsUnitVo.setProUnitName(mdmDictDataReqVo.getDictValue());
        this.update(kmsUnitVo);
    }

    @Override
    public void update(KmsUnitVo kmsUnitVo) {
        kmsUnitVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsUnitVo.setUserId(this.kmsProperties.getUserId());
        kmsUnitVo.setUsername(this.kmsProperties.getUsername());
        kmsUnitVo.setProUnitLevel(this.proUnitLevel);
        String url = this.kmsProperties.getUrl() + "/KmsProUnitController/updateProUnit?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsUnitVo, String.class);
        log.info("[kms\u5355\u4f4d][update]entity:{}", (Object)entity);
    }

    @Override
    public void remove(List<String> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            for (String id : ids) {
                if (StringUtils.isEmpty((Object)id)) continue;
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("tenantryId", this.kmsProperties.getTenantryId());
                paramMap.put("userId", this.kmsProperties.getUserId());
                paramMap.put("username", this.kmsProperties.getUsername());
                paramMap.put("id", id);
                String url = this.kmsProperties.getUrl() + "/KmsProUnitController/deleteById?access_token=" + this.kmsProperties.getAccessToken();
                ResponseEntity enitty = RestTemplateUtils.postForEntity((String)url, null, paramMap, String.class);
                log.info("[kms\u5355\u4f4d][remove]entity:{}", (Object)enitty);
            }
        }
    }
}

