/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.employeedirectory.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.employeedirectory.mapper.MdmEmployeeDirectoryMapper;
import com.biz.crm.employeedirectory.model.MdmEmployeeDirectoryEntity;
import com.biz.crm.employeedirectory.service.MdmEmployeeDirectoryService;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryReqVo;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.utils.PinYinUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class MdmEmployeeDirectoryServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmEmployeeDirectoryMapper, MdmEmployeeDirectoryEntity>
implements MdmEmployeeDirectoryService {
    private static final Logger log = LoggerFactory.getLogger(MdmEmployeeDirectoryServiceImpl.class);
    @Autowired
    private MdmEmployeeDirectoryMapper mdmEmployeeDirectoryMapper;
    @Autowired
    private RedisService redisService;

    @Override
    public Map<String, List<MdmEmployeeDirectoryRespVo>> findList() {
        Map o = (Map)this.redisService.get("MDM_EMPLOYEE_DIRECTORY:");
        if (o != null) {
            return o;
        }
        List<String> firstName = this.mdmEmployeeDirectoryMapper.findFirstName();
        LinkedHashMap<String, List<MdmEmployeeDirectoryRespVo>> map = new LinkedHashMap<String, List<MdmEmployeeDirectoryRespVo>>();
        firstName.forEach(v -> {
            List<MdmEmployeeDirectoryRespVo> listByFirstName = this.mdmEmployeeDirectoryMapper.findListByFirstName((String)v);
            map.put((String)v, listByFirstName);
        });
        this.redisService.set("MDM_EMPLOYEE_DIRECTORY:", map);
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmEmployeeDirectoryReqVo reqVo) {
        this.doCheck(reqVo);
        String nameInitials = PinYinUtil.getPinYin(reqVo.getEmployeeName());
        char chars = nameInitials.charAt(0);
        String firstNameInitials = Character.toString(chars);
        reqVo.setFirstNameInitials(firstNameInitials);
        MdmEmployeeDirectoryEntity entity = (MdmEmployeeDirectoryEntity)CrmBeanUtil.copy((Object)reqVo, MdmEmployeeDirectoryEntity.class);
        this.save(entity);
        this.redisService.del(new String[]{"MDM_EMPLOYEE_DIRECTORY:"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteEmployeeCode(List<String> employeeCodes) {
        Assert.notNull(employeeCodes, (String)"\u7f3a\u5931\u53c2\u6570");
        List<MdmEmployeeDirectoryRespVo> list = this.mdmEmployeeDirectoryMapper.selectByEmployeeCodes(employeeCodes);
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList idList = new ArrayList();
            list.forEach(o -> idList.add(o.getId()));
            this.removeByIds(idList);
        }
        this.redisService.del(new String[]{"MDM_EMPLOYEE_DIRECTORY:"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPosCode(List<String> posCodes) {
        Assert.notNull(posCodes, (String)"\u7f3a\u5931\u53c2\u6570");
        List<MdmEmployeeDirectoryRespVo> list = this.mdmEmployeeDirectoryMapper.selectByPosCodes(posCodes);
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList idList = new ArrayList();
            list.forEach(o -> idList.add(o.getId()));
            this.removeByIds(idList);
        }
        this.redisService.del(new String[]{"MDM_EMPLOYEE_DIRECTORY:"});
    }

    public void doCheck(MdmEmployeeDirectoryReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getUserCode(), (String)"userCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getEmployeeCode(), (String)"\u5458\u5de5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getEmployeeName(), (String)"\u5458\u5de5\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u5458\u5de5\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrgName(), (String)"\u5458\u5de5\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosCode(), (String)"\u5458\u5de5\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosName(), (String)"\u5458\u5de5\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPhone(), (String)"\u5458\u5de5\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

