/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeCommentReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeCommentRespVo;
import com.biz.crm.notice.service.IMdmNoticeCommentLikesService;
import com.biz.crm.notice.service.IMdmNoticeCommentService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmNoticeCommentController"})
@Api(tags={"\u516c\u544a\u8bc4\u8bba\u7ba1\u7406"})
public class MdmNoticeCommentController {
    private static final Logger log = LoggerFactory.getLogger(MdmNoticeCommentController.class);
    @Autowired
    private IMdmNoticeCommentService mdmNoticeCommentService;
    @Autowired
    private IMdmNoticeCommentLikesService mdmNoticeCommentLikesService;

    @ApiOperation(value="\u67e5\u8be2\u8bc4\u8bba\u5217\u8868")
    @PostMapping(value={"/findCommentList"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmNoticeCommentRespVo>> findCommentList(@RequestBody MdmNoticeCommentReqVo mdmNoticeCommentReqVo) {
        PageResult<MdmNoticeCommentRespVo> commentList = this.mdmNoticeCommentService.findCommentList(mdmNoticeCommentReqVo);
        return Result.ok(commentList);
    }

    @ApiOperation(value="\u65b0\u589e\u8bc4\u8bba", httpMethod="GET")
    @GetMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestParam(value="id") String id, @RequestParam(value="commentText") String commentText) {
        this.mdmNoticeCommentService.save(id, commentText);
        return Result.ok();
    }

    @ApiOperation(value="\u8bc4\u8bba\u53ef\u89c1\u72b6\u6001", httpMethod="GET")
    @GetMapping(value={"/updateNoticeVisible"})
    @CrmLog
    public Result updateNoticeVisible(@RequestParam(value="id") String id) {
        this.mdmNoticeCommentService.updateNoticeVisible(id);
        return Result.ok();
    }

    @ApiOperation(value="\u70b9\u8d5e", httpMethod="GET")
    @GetMapping(value={"/like"})
    @CrmLog
    public Result like(@RequestParam(value="commentId") String commentId) {
        this.mdmNoticeCommentLikesService.like(commentId);
        return Result.ok();
    }

    @ApiOperation(value="\u53d6\u6d88\u70b9\u8d5e", httpMethod="GET")
    @GetMapping(value={"/cancelLike"})
    @CrmLog
    public Result cancelLike(@RequestParam(value="commentId") String commentId) {
        this.mdmNoticeCommentLikesService.cancelLike(commentId);
        return Result.ok();
    }

    @ApiOperation(value="\u662f\u5426\u70b9\u8fc7\u8d5e\u5224\u65ad", httpMethod="GET")
    @GetMapping(value={"/doCheckLike"})
    @CrmLog
    public Result doCheckLike(@RequestParam(value="commentId") String commentId) {
        boolean result = this.mdmNoticeCommentLikesService.doCheck(commentId);
        return Result.ok((Object)result);
    }
}

