/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;
import com.biz.crm.terminal.mapper.MdmTerminalElasticsearchRepository;
import com.biz.crm.terminal.model.MdmTerminalCustomerElasticsearchEntity;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class MdmTerminalElasticsearchServiceImpl
implements MdmTerminalElasticsearchService {
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private MdmTerminalElasticsearchRepository elasticsearchRepository;

    @Override
    public PageResult<MdmTerminalCustomerElasticsearchRespVo> listWithPage(MdmTerminalCustomerElasticsearchPageReqVo pageReqVo) {
        Double distance;
        Assert.hasText((String)pageReqVo.getLongitude(), (String)"\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)pageReqVo.getLatitude(), (String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)pageReqVo.getPositionCodes(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        double latitude = Double.parseDouble(pageReqVo.getLatitude());
        double longitude = Double.parseDouble(pageReqVo.getLongitude());
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!this.elasticsearchTemplate.indexExists("mdm_terminal_customer_es_index")) {
            return pageResult;
        }
        if (pageReqVo.getPageNum() == null || pageReqVo.getPageNum() == 0) {
            pageReqVo.setPageNum(Integer.valueOf(0));
        }
        if (pageReqVo.getPageSize() == null || pageReqVo.getPageSize() == 0) {
            pageReqVo.setPageSize(Integer.valueOf(25));
        }
        if ((distance = pageReqVo.getDistance()) == null || distance == 0.0) {
            distance = 1.0E9;
        }
        GeoDistanceQueryBuilder builder = QueryBuilders.geoDistanceQuery((String)"location").point(latitude, longitude).distance(distance.doubleValue(), DistanceUnit.METERS).geoDistance(GeoDistance.ARC);
        GeoDistanceSortBuilder sortBuilder = (GeoDistanceSortBuilder)SortBuilders.geoDistanceSort((String)"location", (double)Double.parseDouble(pageReqVo.getLatitude()), (double)Double.parseDouble(pageReqVo.getLongitude())).point(Double.parseDouble(pageReqVo.getLatitude()), Double.parseDouble(pageReqVo.getLongitude())).unit(DistanceUnit.METERS).order(SortOrder.ASC);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"mdm_terminal_customer_es_index"}).withQuery((QueryBuilder)QueryBuilders.matchQuery((String)"positionCodes", (Object)pageReqVo.getPositionCodes())).withPageable((Pageable)PageRequest.of((int)pageReqVo.getPageNum(), (int)pageReqVo.getPageSize())).build();
        AggregatedPage scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, MdmTerminalCustomerElasticsearchEntity.class);
        List list = scroll.getContent();
        pageResult.setData(list.stream().map(item -> ((MdmTerminalCustomerElasticsearchRespVo)CrmBeanUtil.copy((Object)item, MdmTerminalCustomerElasticsearchRespVo.class)).setDistance(Double.valueOf(GeoDistance.PLANE.calculate(Double.parseDouble(item.getLatitude()), Double.parseDouble(item.getLongitude()), latitude, longitude, DistanceUnit.METERS)))).collect(Collectors.toList()));
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    @Override
    public void add(Object object) {
        if (!this.elasticsearchTemplate.indexExists("mdm_terminal_customer_es_index")) {
            this.elasticsearchTemplate.createIndex(MdmTerminalCustomerElasticsearchEntity.class);
        }
        MdmTerminalCustomerElasticsearchEntity elasticsearchEntity = (MdmTerminalCustomerElasticsearchEntity)CrmBeanUtil.copy((Object)object, MdmTerminalCustomerElasticsearchEntity.class);
        if (object instanceof MdmTerminalVo) {
            MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)object;
            elasticsearchEntity.setName(mdmTerminalVo.getTerminalName());
            elasticsearchEntity.setCode(mdmTerminalVo.getTerminalCode());
            elasticsearchEntity.setLocation(mdmTerminalVo.getLongitude() + "," + mdmTerminalVo.getLatitude());
            if (!CollectionUtils.isEmpty((Collection)mdmTerminalVo.getContacts())) {
                elasticsearchEntity.setContactName(((MdmTerminalContactVo)mdmTerminalVo.getContacts().stream().filter(x -> x.getContactMain().equals(YesNoEnum.yesNoEnum.ONE.getValue())).collect(Collectors.toList()).get(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).getContactName());
            }
            if (!CollectionUtils.isEmpty((Collection)mdmTerminalVo.getSupplys())) {
                elasticsearchEntity.setPositionCodes(mdmTerminalVo.getSupplys().stream().map(MdmTerminalSupplyVo::getPositionCode).collect(Collectors.joining(";")));
            }
        } else if (object instanceof MdmCustomerMsgReqVo) {
            MdmCustomerMsgReqVo mdmCustomerMsgReqVo = (MdmCustomerMsgReqVo)object;
            elasticsearchEntity.setName(mdmCustomerMsgReqVo.getCustomerName());
            elasticsearchEntity.setCode(mdmCustomerMsgReqVo.getCustomerCode());
            elasticsearchEntity.setLocation(mdmCustomerMsgReqVo.getLongitude() + "," + mdmCustomerMsgReqVo.getLatitude());
            if (!CollectionUtils.isEmpty((Collection)mdmCustomerMsgReqVo.getMdmCustomerContactVos())) {
                elasticsearchEntity.setContactName(((MdmCustomerContactReqVo)mdmCustomerMsgReqVo.getMdmCustomerContactVos().stream().filter(x -> x.getContactMain().equals(YesNoEnum.yesNoEnum.ONE.getValue())).collect(Collectors.toList()).get(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).getContactName());
            }
            if (!CollectionUtils.isEmpty((Collection)mdmCustomerMsgReqVo.getMdmCustomerDockingVos())) {
                elasticsearchEntity.setPositionCodes(mdmCustomerMsgReqVo.getMdmCustomerDockingVos().stream().map(MdmCustomerDockingReqVo::getPositionCode).collect(Collectors.joining(";")));
            }
        } else {
            throw new BusinessException("\u6682\u65f6\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + object.getClass().getName());
        }
        this.elasticsearchRepository.save(elasticsearchEntity);
    }
}

