/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalDetailRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserTerminalEditReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserDetailRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserPageRespVo;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.user.mapper.MdmTerminalUserMapper;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.model.MdmTerminalRelationRoleEntity;
import com.biz.crm.user.model.MdmTerminalUserRelationTerminalEntity;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmTerminalRelRoleService;
import com.biz.crm.user.service.MdmTerminalUserService;
import com.biz.crm.user.service.MdmUserRelTerminalService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalUserServiceExpandImpl"})
public class MdmTerminalUserServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserMapper, MdmUserEntity>
implements MdmTerminalUserService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalUserServiceImpl.class);
    @Resource
    private MdmTerminalUserMapper mdmTerminalUserMapper;
    @Resource
    private MdmTerminalService mdmTerminalService;
    @Resource
    private MdmUserRelTerminalService mdmUserRelTerminalService;
    @Resource
    private MdmTerminalRelRoleService mdmTerminalRelRoleService;
    @Resource
    private MdmRoleService mdmRoleService;
    @Resource
    private MdmUserService mdmUserService;

    @Override
    public PageResult<MdmTerminalUserPageRespVo> findList(MdmTerminalUserPageReqVo reqVo) {
        reqVo.setUserType(UserTypeEnum.TERMINAL.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmTerminalUserPageRespVo> list = this.mdmTerminalUserMapper.findList((Page<MdmTerminalUserPageRespVo>)page, reqVo);
        this.setTerminalCodeName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmTerminalUserEditReqVo reqVo) {
        reqVo.setId(null);
        reqVo.setUserType(UserTypeEnum.TERMINAL.getCode());
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)CrmBeanUtil.copy((Object)reqVo, MdmUserEntity.class);
        if (StringUtils.isEmpty((String)entity.getUserCode())) {
            entity.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
        }
        entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        this.save(entity);
        this.saveOrUpdateTerminalUserRelation(reqVo, entity);
    }

    @Override
    public MdmTerminalUserDetailRespVo queryByIdOrUsername(String id, String username) {
        if (StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)username)) {
            MdmUserEntity mdmUserEntity = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((String)username), MdmUserEntity::getUserName, (Object)username)).eq(MdmUserEntity::getUserType, (Object)UserTypeEnum.TERMINAL.getCode())).one();
            if (mdmUserEntity != null) {
                MdmTerminalUserDetailRespVo mdmTerminalUserDetailRespVo = (MdmTerminalUserDetailRespVo)CrmBeanUtil.copy((Object)mdmUserEntity, MdmTerminalUserDetailRespVo.class);
                List terminalUserTerminalList = ((LambdaQueryChainWrapper)this.mdmUserRelTerminalService.lambdaQuery().eq(MdmTerminalUserRelationTerminalEntity::getUserName, (Object)mdmUserEntity.getUserName())).list();
                ArrayList<MdmTerminalDetailRespVo> mdmTerminalDetailRespVos = new ArrayList<MdmTerminalDetailRespVo>();
                if (terminalUserTerminalList != null) {
                    for (MdmTerminalUserRelationTerminalEntity mdmTerminalUserRelationTerminalEntity : terminalUserTerminalList) {
                        MdmTerminalDetailRespVo mdmTerminalDetailRespVo = (MdmTerminalDetailRespVo)CrmBeanUtil.copy((Object)((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalUserRelationTerminalEntity.getTerminalCode())).one(), MdmTerminalDetailRespVo.class);
                        mdmTerminalDetailRespVo.setPrimaryFlag(mdmTerminalUserRelationTerminalEntity.getPrimaryFlag());
                        MdmTerminalRelationRoleEntity mdmTerminalRole = (MdmTerminalRelationRoleEntity)((LambdaQueryChainWrapper)this.mdmTerminalRelRoleService.lambdaQuery().eq(MdmTerminalRelationRoleEntity::getTerminalCode, (Object)mdmTerminalUserRelationTerminalEntity.getTerminalCode())).one();
                        MdmRoleEntity role = (MdmRoleEntity)((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)mdmTerminalRole.getRoleCode())).one();
                        mdmTerminalDetailRespVo.setRoleCode(role.getRoleCode());
                        mdmTerminalDetailRespVo.setRoleName(role.getRoleName());
                        mdmTerminalDetailRespVos.add(mdmTerminalDetailRespVo);
                    }
                }
                mdmTerminalUserDetailRespVo.setTerminalList(mdmTerminalDetailRespVos);
                if (terminalUserTerminalList != null && terminalUserTerminalList.size() == 1) {
                    mdmTerminalUserDetailRespVo.setTerminalCode(((MdmTerminalDetailRespVo)mdmTerminalUserDetailRespVo.getTerminalList().get(0)).getTerminalCode());
                    mdmTerminalUserDetailRespVo.setTerminalName(((MdmTerminalDetailRespVo)mdmTerminalUserDetailRespVo.getTerminalList().get(0)).getTerminalName());
                    mdmTerminalUserDetailRespVo.setRoleCode(((MdmTerminalDetailRespVo)mdmTerminalUserDetailRespVo.getTerminalList().get(0)).getRoleCode());
                    mdmTerminalUserDetailRespVo.setRoleName(((MdmTerminalDetailRespVo)mdmTerminalUserDetailRespVo.getTerminalList().get(0)).getRoleName());
                }
                return mdmTerminalUserDetailRespVo;
            }
            return null;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmTerminalUserEditReqVo mdmTerminalUserEditReqVo) {
        mdmTerminalUserEditReqVo.setUserType(UserTypeEnum.TERMINAL.getCode());
        this.verifyData(mdmTerminalUserEditReqVo);
        MdmUserEntity entity = (MdmUserEntity)this.getById((Serializable)((Object)mdmTerminalUserEditReqVo.getId()));
        CrmBeanUtil.copyProperties((Object)mdmTerminalUserEditReqVo, (Object)entity);
        this.updateById(entity);
        this.saveOrUpdateTerminalUserRelation(mdmTerminalUserEditReqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmUserEntity mdmUser = (MdmUserEntity)this.getById((Serializable)((Object)id));
            Assert.notNull((Object)mdmUser, (String)"\u65e0\u6548\u7684\u7528\u6237");
            Assert.isTrue((boolean)UserTypeEnum.TERMINAL.getCode().equals(mdmUser.getUserType()), (String)("\u7528\u6237[" + mdmUser.getFullName() + "]\u4e0d\u662f\u7ec8\u7aef\u7528\u6237"));
            ((LambdaUpdateChainWrapper)this.mdmUserRelTerminalService.lambdaUpdate().eq(MdmTerminalUserRelationTerminalEntity::getUserName, (Object)mdmUser.getUserName())).remove();
        });
        this.removeByIds(ids);
    }

    @Override
    public List<MdmTerminalDetailRespVo> getTerminalListByCondition(MdmTerminalUserTerminalSelectReqVo reqVo) {
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            reqVo.setSelectedCodeList(Collections.singletonList(reqVo.getSelectedCode()));
        }
        return this.mdmTerminalUserMapper.getTerminalListByCondition((Page<MdmTerminalDetailRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo);
    }

    private void saveOrUpdateTerminalUserRelation(MdmTerminalUserEditReqVo reqVo, MdmUserEntity userEntity) {
        if (YesNoEnum.yesNoEnum.N.getValue().equals(ParamUtil.getParameterValue((String)"user_can_relation_many_terminal"))) {
            reqVo.setTerminalList(Collections.singletonList(new MdmUserTerminalEditReqVo().setTerminalCode(reqVo.getTerminalCode()).setRoleCode(reqVo.getRoleCode()).setTerminalPrimary(YesNoEnum.yesNoEnum.ONE.getValue())));
        }
        ((LambdaUpdateChainWrapper)this.mdmUserRelTerminalService.lambdaUpdate().eq(MdmTerminalUserRelationTerminalEntity::getUserName, (Object)userEntity.getUserName())).remove();
        for (MdmUserTerminalEditReqVo item : reqVo.getTerminalList()) {
            ((LambdaUpdateChainWrapper)this.mdmTerminalRelRoleService.lambdaUpdate().eq(MdmTerminalRelationRoleEntity::getTerminalCode, (Object)item.getTerminalCode())).remove();
            MdmTerminalEntity terminal = (MdmTerminalEntity)((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)item.getTerminalCode())).one();
            Assert.notNull((Object)terminal, (String)"\u7ec8\u7aef\u4e0d\u5b58\u5728");
            MdmTerminalUserRelationTerminalEntity terminalUserTerminal = (MdmTerminalUserRelationTerminalEntity)((LambdaQueryChainWrapper)this.mdmUserRelTerminalService.lambdaQuery().eq(MdmTerminalUserRelationTerminalEntity::getTerminalCode, (Object)item.getTerminalCode())).one();
            Assert.isNull((Object)terminalUserTerminal, (String)("\u7ec8\u7aef[" + terminal.getTerminalName() + "]\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u5173\u8054\uff01"));
            MdmTerminalUserRelationTerminalEntity addMdmTerminalUserRelationTerminalEntity = new MdmTerminalUserRelationTerminalEntity().setUserName(userEntity.getUserName()).setTerminalCode(terminal.getTerminalCode()).setPrimaryFlag(item.getTerminalPrimary());
            this.mdmUserRelTerminalService.save(addMdmTerminalUserRelationTerminalEntity);
            MdmRoleEntity role = (MdmRoleEntity)((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().eq(MdmRoleEntity::getRoleCode, (Object)item.getRoleCode())).one();
            Assert.notNull((Object)role, (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
            MdmTerminalRelationRoleEntity terminalRoleByRole = (MdmTerminalRelationRoleEntity)((LambdaQueryChainWrapper)this.mdmTerminalRelRoleService.lambdaQuery().eq(MdmTerminalRelationRoleEntity::getRoleCode, (Object)item.getRoleCode())).one();
            Assert.isNull((Object)terminalRoleByRole, (String)("\u89d2\u8272[" + role.getRoleName() + "]\u5df2\u7ecf\u88ab\u5176\u4ed6\u7ec8\u7aef\u5173\u8054\uff01"));
            MdmTerminalRelationRoleEntity terminalRoleByTerminal = (MdmTerminalRelationRoleEntity)((LambdaQueryChainWrapper)this.mdmTerminalRelRoleService.lambdaQuery().eq(MdmTerminalRelationRoleEntity::getTerminalCode, (Object)item.getTerminalCode())).one();
            if (terminalRoleByTerminal != null) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmTerminalRelRoleService.lambdaUpdate().eq(BaseIdEntity::getId, (Object)terminalRoleByTerminal.getId())).set(MdmTerminalRelationRoleEntity::getRoleCode, (Object)item.getRoleCode())).update();
                return;
            }
            MdmTerminalRelationRoleEntity mdmTerminalRelationRoleEntity = new MdmTerminalRelationRoleEntity().setRoleCode(item.getRoleCode()).setTerminalCode(item.getTerminalCode());
            this.mdmTerminalRelRoleService.save(mdmTerminalRelationRoleEntity);
        }
    }

    private void verifyData(MdmTerminalUserEditReqVo reqVo) {
        String userName = reqVo.getUserName();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFullName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserEntity one = (MdmUserEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).one();
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            Assert.isNull((Object)one, (String)("\u5e10\u53f7[" + userName + "]\u5df2\u5b58\u5728"));
            Assert.hasText((String)reqVo.getUserPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqVo.getUserPassword())) {
            reqVo.setUserPassword(one.getUserPassword());
        } else {
            reqVo.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)reqVo.getUserPassword()));
        }
        String parameterValue = ParamUtil.getParameterValue((String)"user_can_relation_many_terminal");
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(parameterValue)) {
            List terminalList = reqVo.getTerminalList();
            Assert.notEmpty((Collection)terminalList, (String)"\u7ec8\u7aef\u7528\u6237\u5fc5\u987b\u5173\u8054\u7ec8\u7aef");
            HashMap<String, MdmUserTerminalEditReqVo> terminalUniqueMap = new HashMap<String, MdmUserTerminalEditReqVo>(16);
            for (MdmUserTerminalEditReqVo item : terminalList) {
                Assert.hasText((String)item.getTerminalCode(), (String)"\u7ec8\u7aef\u4e0d\u80fd\u4e3a\u7a7a");
                if (terminalUniqueMap.containsKey(item.getTerminalCode())) {
                    throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5173\u8054\u76f8\u540c\u7ec8\u7aef");
                }
                terminalUniqueMap.put(item.getTerminalCode(), item);
            }
            ((MdmUserTerminalEditReqVo)terminalList.get(0)).setTerminalPrimary(YesNoEnum.yesNoEnum.ONE.getValue());
        } else if (YesNoEnum.yesNoEnum.N.getValue().equals(parameterValue)) {
            Assert.hasText((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            throw new BusinessException("\u5168\u5c40\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
    }

    private void setTerminalCodeName(List<MdmTerminalUserPageRespVo> terminalUserReqVoList) {
        List terminalNameList = terminalUserReqVoList.stream().map(MdmTerminalUserPageRespVo::getUserName).collect(Collectors.toList());
        Map<String, List<MdmTerminalUserRelationTerminalEntity>> terminalUserTerminal = ((LambdaQueryChainWrapper)this.mdmUserRelTerminalService.lambdaQuery().in(!CollectionUtils.isEmpty(terminalNameList), MdmTerminalUserRelationTerminalEntity::getUserName, terminalNameList)).list().stream().collect(Collectors.groupingBy(MdmTerminalUserRelationTerminalEntity::getUserName));
        List bigList = Lists.partition(terminalUserReqVoList, (int)500);
        for (List smallList : bigList) {
            smallList.forEach(item -> {
                List terminalListRelation;
                if (terminalUserTerminal.containsKey(item.getUserName()) && CollectionUtil.listNotEmptyNotSizeZero((List)(terminalListRelation = (List)terminalUserTerminal.get(item.getUserName())))) {
                    List terminalList = ((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, (Collection)terminalListRelation.stream().map(MdmTerminalUserRelationTerminalEntity::getTerminalCode).collect(Collectors.toList()))).list();
                    item.setTerminalCode(terminalList.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.joining(",")));
                    item.setTerminalName(terminalList.stream().map(MdmTerminalEntity::getTerminalName).collect(Collectors.joining(",")));
                    List mdmTerminalRelationRoleEntities = ((LambdaQueryChainWrapper)this.mdmTerminalRelRoleService.lambdaQuery().in(MdmTerminalRelationRoleEntity::getTerminalCode, (Collection)terminalList.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()))).list();
                    List mdmRoleEntities = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)mdmTerminalRelationRoleEntities.stream().map(MdmTerminalRelationRoleEntity::getRoleCode).collect(Collectors.toList()))).select(new SFunction[]{MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName}).list();
                    item.setRoleCode(mdmRoleEntities.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.joining(",")));
                    item.setRoleName(mdmRoleEntities.stream().map(MdmRoleEntity::getRoleName).collect(Collectors.joining(",")));
                }
            });
        }
    }
}

