/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerTerminalService;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCorrelatedTerminalReplaceReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCorrelatedTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalFuzzyQueryVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalRespVo;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerTerminalServiceExpandImpl"})
public class MdmCustomerTerminalServiceImpl
implements MdmCustomerTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerTerminalServiceImpl.class);
    @Autowired
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmTerminalService mdmTerminalService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbind(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        this.mdmTerminalSupplyService.unbind(mdmCustomerCorrelatedTerminalReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceCustomer(MdmCustomerCorrelatedTerminalReplaceReqVo mdmCustomerCorrelatedTerminalReplaceReqVo) {
        this.mdmTerminalSupplyService.replaceCustomer(mdmCustomerCorrelatedTerminalReplaceReqVo);
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> correlatedCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return this.mdmTerminalSupplyService.correlatedCustomerPage(mdmCustomerTerminalReqVo);
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> unCorrelatedAnyCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return this.mdmTerminalSupplyService.unCorrelatedAnyCustomerPage(mdmCustomerTerminalReqVo);
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> unCorrelatedCurrentCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return this.mdmTerminalSupplyService.unCorrelatedCurrentCustomerPage(mdmCustomerTerminalReqVo);
    }

    @Override
    public void correlatedTerminal(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        this.mdmTerminalSupplyService.customerRelationTerminal(mdmCustomerCorrelatedTerminalReqVo);
    }

    @Override
    public List<MdmCustomerTerminalFuzzyQueryVo> findCustomerTerminalFuzzyList(MdmCustomerTerminalFuzzyQueryVo reqVo) {
        List terminalList;
        List customerList;
        ArrayList<MdmCustomerTerminalFuzzyQueryVo> list = new ArrayList<MdmCustomerTerminalFuzzyQueryVo>();
        if ((reqVo.getType() == null || MdmCustomerTerminalFuzzyQueryVo.Type.CUSTOMER == reqVo.getType()) && CollectionUtil.listNotEmptyNotSizeZero((List)(customerList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).eq(StringUtils.isNotEmpty((String)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).like(StringUtils.isNotEmpty((String)reqVo.getCode()), MdmCustomerEntity::getCustomerCode, (Object)reqVo.getCode())).like(StringUtils.isNotEmpty((String)reqVo.getName()), MdmCustomerEntity::getCustomerName, (Object)reqVo.getName())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getCustomerName, CrmBaseEntity::getEnableStatus}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list()))) {
            list.addAll(customerList.stream().map(x -> {
                MdmCustomerTerminalFuzzyQueryVo fuzzyQueryVo = new MdmCustomerTerminalFuzzyQueryVo();
                fuzzyQueryVo.setCode(x.getCustomerCode());
                fuzzyQueryVo.setName(x.getCustomerName());
                fuzzyQueryVo.setEnableStatus(x.getEnableStatus());
                fuzzyQueryVo.setType(MdmCustomerTerminalFuzzyQueryVo.Type.CUSTOMER);
                return fuzzyQueryVo;
            }).collect(Collectors.toList()));
        }
        if ((reqVo.getType() == null || MdmCustomerTerminalFuzzyQueryVo.Type.TERMINAL == reqVo.getType()) && CollectionUtil.listNotEmptyNotSizeZero((List)(terminalList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).eq(StringUtils.isNotEmpty((String)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).like(StringUtils.isNotEmpty((String)reqVo.getCode()), MdmTerminalEntity::getTerminalCode, (Object)reqVo.getCode())).like(StringUtils.isNotEmpty((String)reqVo.getName()), MdmTerminalEntity::getTerminalName, (Object)reqVo.getName())).select(new SFunction[]{MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getTerminalName, CrmBaseEntity::getEnableStatus}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list()))) {
            list.addAll(terminalList.stream().map(x -> {
                MdmCustomerTerminalFuzzyQueryVo fuzzyQueryVo = new MdmCustomerTerminalFuzzyQueryVo();
                fuzzyQueryVo.setCode(x.getTerminalCode());
                fuzzyQueryVo.setName(x.getTerminalName());
                fuzzyQueryVo.setEnableStatus(x.getEnableStatus());
                fuzzyQueryVo.setType(MdmCustomerTerminalFuzzyQueryVo.Type.TERMINAL);
                return fuzzyQueryVo;
            }).collect(Collectors.toList()));
        }
        return list;
    }
}

