/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.user.req.MdmConsumerEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmConsumerRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserPageRespVo;
import com.biz.crm.user.mapper.MdmCustomerUserMapper;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmConsumerUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmConsumerUserServiceExpandImpl"})
public class MdmConsumerUserServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserMapper, MdmUserEntity>
implements MdmConsumerUserService {
    private static final Logger log = LoggerFactory.getLogger(MdmConsumerUserServiceImpl.class);
    @Resource
    private MdmCustomerUserMapper mdmCustomerUserMapper;

    @Override
    public PageResult<MdmCustomerUserPageRespVo> findList(MdmCustomerUserPageReqVo reqVo) {
        reqVo.setUserType(UserTypeEnum.CONSUMER.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCustomerUserPageRespVo> list = this.mdmCustomerUserMapper.findList((Page<MdmCustomerUserPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmConsumerRespVo query(String id, String userName) {
        MdmUserEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)userName)) && (one = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((String)userName), MdmUserEntity::getUserName, (Object)userName)).one()) != null) {
            MdmConsumerRespVo respVo = (MdmConsumerRespVo)CrmBeanUtil.copy((Object)one, MdmConsumerRespVo.class);
            respVo.setUserPassword("");
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmConsumerEditReqVo reqVo) {
        reqVo.setId(null);
        reqVo.setUserType(UserTypeEnum.CONSUMER.getCode());
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)CrmBeanUtil.copy((Object)reqVo, MdmUserEntity.class);
        if (StringUtils.isEmpty((String)entity.getUserCode())) {
            entity.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
        }
        entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmConsumerEditReqVo reqVo) {
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)this.getById((Serializable)((Object)reqVo.getId()));
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)entity);
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmUserEntity one = (MdmUserEntity)this.getById((Serializable)((Object)id));
            Assert.notNull((Object)one, (String)"\u65e0\u6548\u7684\u7528\u6237");
            Assert.isTrue((boolean)UserTypeEnum.CONSUMER.getCode().equals(one.getUserType()), (String)("\u7528\u6237[" + one.getFullName() + "]\u4e0d\u662f\u6d88\u8d39\u7528\u6237"));
        });
        this.removeByIds(ids);
    }

    private void verifyData(MdmConsumerEditReqVo reqVo) {
        List list;
        String userName = reqVo.getUserName();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserEntity one = (MdmUserEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).one();
        if (StringUtils.isNotEmpty((String)reqVo.getUserPhone())) {
            list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserPhone, (Object)reqVo.getUserPhone())).ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u88ab\u5360\u7528");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getEmail())) {
            list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getEmail, (Object)reqVo.getEmail())).ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u90ae\u7bb1\u5df2\u7ecf\u88ab\u5360\u7528");
        }
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            Assert.isNull((Object)one, (String)("\u5e10\u53f7[" + userName + "]\u5df2\u5b58\u5728"));
            Assert.hasText((String)reqVo.getUserPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqVo.getUserPassword())) {
            reqVo.setUserPassword(one.getUserPassword());
        } else {
            reqVo.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)reqVo.getUserPassword()));
        }
    }
}

