/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.config.MapperConfig;
import com.biz.crm.kms.service.MdmDirectSystemService;
import com.biz.crm.kms.service.MdmStoreService;
import com.biz.crm.nebular.mdm.kms.MdmDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsStoreReplicaVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmStoreServiceExpandImpl"})
public class MdmStoreServiceImpl
implements MdmStoreService {
    private static final Logger log = LoggerFactory.getLogger(MdmStoreServiceImpl.class);
    @Autowired
    private KmsProperties kmsProperties;
    @Autowired
    private MdmDirectSystemService mdmDirectSystemService;

    @Override
    public void add(KmsStoreReplicaVo kmsStoreReplicaVo) {
        kmsStoreReplicaVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsStoreReplicaVo.setUserId(this.kmsProperties.getUserId());
        kmsStoreReplicaVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/storeController/onlySave?access_token=" + this.kmsProperties.getAccessToken();
        ParameterizedTypeReference<KmsResultVo<Object>> reference = new ParameterizedTypeReference<KmsResultVo<Object>>(){};
        log.info("[kms\u95e8\u5e97][add]kmsStoreReplicaVo:{}", (Object)kmsStoreReplicaVo);
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsStoreReplicaVo, (ParameterizedTypeReference)reference);
        log.info("[kms\u95e8\u5e97][add]entity:{}", (Object)entity);
        Optional.of(entity).map(HttpEntity::getBody).filter(x -> "ERROR".equals(x.getCode())).ifPresent(x -> {
            throw new BusinessException(x.getMessage());
        });
    }

    @Override
    public void add(MdmTerminalVo mdmTerminalVo) {
        if (!this.valid()) {
            return;
        }
        KmsStoreReplicaVo check = this.check(mdmTerminalVo);
        if (check != null) {
            this.add(check);
        }
    }

    protected KmsStoreReplicaVo check(MdmTerminalVo mdmTerminalVo) {
        KmsStoreReplicaVo kmsStoreReplicaVo = new KmsStoreReplicaVo();
        kmsStoreReplicaVo.setId(mdmTerminalVo.getTerminalCode());
        kmsStoreReplicaVo.setStoreCode(mdmTerminalVo.getTerminalCode());
        kmsStoreReplicaVo.setStoreName(mdmTerminalVo.getTerminalName());
        kmsStoreReplicaVo.setDirectSystemId(mdmTerminalVo.getDirectSystemId());
        kmsStoreReplicaVo.setBsStoreId(mdmTerminalVo.getStoreId());
        if (StringUtils.isEmpty((Object)mdmTerminalVo.getDirectSystemId()) || StringUtils.isEmpty((Object)mdmTerminalVo.getSellPartyId())) {
            return null;
        }
        List<MdmDirectSystemVo> mdmDirectSystemVos = this.mdmDirectSystemService.directSystemSelect(new MdmDirectSystemVo());
        Assert.notEmpty(mdmDirectSystemVos, (String)"\u76f4\u8425\u4f53\u7cfb\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)mdmDirectSystemVos.stream().anyMatch(x -> mdmTerminalVo.getDirectSystemId().equals(x.getId())), (String)"\u76f4\u8425\u4f53\u7cfb\u4e0d\u5b58\u5728");
        for (MdmDirectSystemVo mdmDirectSystemVo : mdmDirectSystemVos) {
            if (!mdmTerminalVo.getDirectSystemId().equals(mdmDirectSystemVo.getId())) continue;
            kmsStoreReplicaVo.setDirectSystemName(mdmDirectSystemVo.getDirectSystemName());
        }
        return kmsStoreReplicaVo;
    }

    @Override
    public void update(MdmTerminalVo mdmTerminalVo) {
        if (!this.valid()) {
            return;
        }
        KmsStoreReplicaVo check = this.check(mdmTerminalVo);
        if (check != null) {
            this.update(check);
        }
    }

    @Override
    public void remove(List<String> ids) {
        if (!this.valid()) {
            return;
        }
        if (!CollectionUtils.isEmpty(ids)) {
            for (String id : ids) {
                if (StringUtils.isEmpty((Object)id)) continue;
                ObjectNode instance = MapperConfig.instance(this.kmsProperties);
                instance.put("storeId", id);
                String url = this.kmsProperties.getUrl() + "/storeController/deleteStore?access_token=" + this.kmsProperties.getAccessToken();
                ParameterizedTypeReference<KmsResultVo<Object>> reference = new ParameterizedTypeReference<KmsResultVo<Object>>(){};
                Optional.of(RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)instance, (ParameterizedTypeReference)reference)).map(x -> {
                    log.info("[kms\u95e8\u5e97][remove]entity:{}", x);
                    return x;
                }).map(HttpEntity::getBody).filter(x -> "ERROR".equals(x.getCode())).ifPresent(x -> {
                    throw new BusinessException(x.getMessage());
                });
            }
        }
    }

    @Override
    public void update(KmsStoreReplicaVo kmsStoreReplicaVo) {
        kmsStoreReplicaVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsStoreReplicaVo.setUserId(this.kmsProperties.getUserId());
        kmsStoreReplicaVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/storeController/saveStore?access_token=" + this.kmsProperties.getAccessToken();
        ParameterizedTypeReference<KmsResultVo<Object>> reference = new ParameterizedTypeReference<KmsResultVo<Object>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsStoreReplicaVo, (ParameterizedTypeReference)reference);
        log.info("[kms\u95e8\u5e97][add]entity:{}", (Object)entity);
        Optional.of(entity).map(HttpEntity::getBody).filter(x -> "ERROR".equals(x.getCode())).ifPresent(x -> {
            throw new BusinessException(x.getMessage());
        });
    }

    public boolean valid() {
        return !StringUtils.isEmpty((Object)this.kmsProperties.getAccessToken());
    }
}

