/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationTerminalPageRespVo;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.user.mapper.MdmUserRelationTerminalMapper;
import com.biz.crm.user.service.MdmUserRelationTerminalService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MdmUserRelationTerminalServiceImpl
implements MdmUserRelationTerminalService {
    @Resource
    private MdmUserRelationTerminalMapper mdmUserRelationTerminalMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private MdmTerminalROrgService mdmTerminalROrgService;

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateAnyUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationTerminalPageRespVo> list = this.mdmUserRelationTerminalMapper.findTerminalNotRelateAnyUser((Page<MdmUserRelationTerminalPageRespVo>)page, reqVo);
        this.setOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationTerminalPageRespVo> list = this.mdmUserRelationTerminalMapper.findTerminalNotRelateCurUser((Page<MdmUserRelationTerminalPageRespVo>)page, reqVo);
        this.setOrgName(list);
        this.setPositionCodeName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalHasRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationTerminalPageRespVo> list = this.mdmUserRelationTerminalMapper.findTerminalHasRelateCurUser((Page<MdmUserRelationTerminalPageRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setId(item.getSupplyId()));
        }
        this.setOrgName(list);
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private void setOrgName(List<MdmUserRelationTerminalPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        Map<String, List<MdmOrgRespVo>> map = this.mdmTerminalROrgService.findOrgGroupByTerminalCodeList(list.stream().map(MdmUserRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList()));
        list.forEach(item -> {
            if (map.containsKey(item.getTerminalCode())) {
                List orgList = (List)map.get(item.getTerminalCode());
                item.setOrgName(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(",")));
            }
        });
    }

    private void setPositionCodeName(List<MdmUserRelationTerminalPageRespVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List positionList;
            List terminalCodeList = list.stream().map(MdmUserRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList());
            List terminalSupplyList = ((LambdaQueryChainWrapper)this.mdmTerminalSupplyService.lambdaQuery().in(MdmTerminalSupplyEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalSupplyEntity::getTerminalCode, MdmTerminalSupplyEntity::getPositionCode}).list();
            List positionCodeList = terminalSupplyList.stream().map(MdmTerminalSupplyEntity::getPositionCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName}).list()))) {
                Map<String, MdmPositionEntity> positionMap = positionList.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
                Map collect = terminalSupplyList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionCode())).collect(Collectors.groupingBy(MdmTerminalSupplyEntity::getTerminalCode, Collectors.mapping(MdmTerminalSupplyEntity::getPositionCode, Collectors.toList())));
                list.forEach(item -> {
                    if (collect.containsKey(item.getTerminalCode())) {
                        List positionCodeListInThisTerminal = (List)collect.get(item.getTerminalCode());
                        ArrayList positionListInThisTerminal = new ArrayList();
                        for (String positionCode : positionCodeListInThisTerminal) {
                            if (!positionMap.containsKey(positionCode)) continue;
                            positionListInThisTerminal.add(positionMap.get(positionCode));
                        }
                        item.setPositionCode(positionListInThisTerminal.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.joining(",")));
                        item.setPositionName(positionListInThisTerminal.stream().map(MdmPositionEntity::getPositionName).collect(Collectors.joining(",")));
                    }
                });
            }
        }
    }
}

