/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmSfaAppletLoginService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.model.MdmUserRelWeChatEntity;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.mdm.LoginHelpUtil;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@ConditionalOnMissingBean(name={"MdmSfaAppletLoginServiceExpandImpl"})
public class MdmSfaAppletLoginServiceImpl
implements MdmSfaAppletLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmSfaAppletLoginServiceImpl.class);
    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;
    @Autowired
    private MdmUserRelWeChatService mdmUserRelWeChatService;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmUserLoginLogService mdmUserLoginLogService;
    @Resource
    private MdmUserLoginLogAsyncService mdmUserLoginLogAsyncService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo login(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        long userLockMinutes = LoginHelpUtil.getLockMinutes((String)reqVo.getUserName(), null, null);
        if (userLockMinutes != 0L) {
            throw new BusinessException("\u7528\u6237\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + userLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        MdmUserEntity user = (MdmUserEntity)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)reqVo.getUserName())).select(new SFunction[]{MdmUserEntity::getUserName, MdmUserEntity::getFullName, MdmUserEntity::getUserPassword, MdmUserEntity::getUserPhone, MdmUserEntity::getEmail, MdmUserEntity::getUserType, MdmUserEntity::getStartTime, MdmUserEntity::getEndTime, CrmBaseEntity::getEnableStatus, MdmUserEntity::getForceChangePassword}).one();
        Assert.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(user.getUserType()), (String)"\u975e\u4f01\u4e1a\u7528\u6237\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)"\u7528\u6237\u5df2\u7ecf\u505c\u7528");
        Assert.isTrue((boolean)LoginHelpUtil.checkStartEndTime((String)user.getStartTime(), (String)user.getEndTime()), (String)"\u7528\u6237\u4e0d\u5728\u6709\u6548\u671f");
        if (!Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            long userLastTimes = LoginHelpUtil.addErrorAndGetTimes((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
            if (userLastTimes != 0L) {
                throw new BusinessException("\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + userLastTimes + "\u6b21\u5c1d\u8bd5\u673a\u4f1a");
            }
            throw new BusinessException("\u5bc6\u7801\u9519\u8bef\uff0c\u8d26\u53f7\u88ab\u9501\u5b9a\uff0c\u8bf7" + LoginHelpUtil.getMaxLockMinutes() + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user.getUserName(), reqVo.getFromType(), user.getForceChangePassword(), reqVo, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhone(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        long phoneLockMinutes = LoginHelpUtil.getLockMinutes(null, (String)reqVo.getUserPhone(), null);
        if (phoneLockMinutes != 0L) {
            throw new BusinessException("\u624b\u673a\u53f7\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + phoneLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        List list = ((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserPhone, (Object)reqVo.getUserPhone())).select(new SFunction[]{MdmUserEntity::getUserName, MdmUserEntity::getFullName, MdmUserEntity::getUserPassword, MdmUserEntity::getUserPhone, MdmUserEntity::getEmail, MdmUserEntity::getUserType, MdmUserEntity::getStartTime, MdmUserEntity::getEndTime, CrmBaseEntity::getEnableStatus, MdmUserEntity::getForceChangePassword}).list();
        Assert.notEmpty((Collection)list, (String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u5bf9\u5e94\u591a\u4e2a\u8d26\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        MdmUserEntity user = (MdmUserEntity)list.get(0);
        Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(user.getUserType()), (String)"\u975e\u4f01\u4e1a\u7528\u6237\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)"\u7528\u6237\u5df2\u7ecf\u505c\u7528");
        Assert.isTrue((boolean)LoginHelpUtil.checkStartEndTime((String)user.getStartTime(), (String)user.getEndTime()), (String)"\u7528\u6237\u4e0d\u5728\u6709\u6548\u671f");
        if (!Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            long phoneLastTimes = LoginHelpUtil.addErrorAndGetTimes((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
            if (phoneLastTimes != 0L) {
                throw new BusinessException("\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + phoneLastTimes + "\u6b21\u5c1d\u8bd5\u673a\u4f1a");
            }
            throw new BusinessException("\u5bc6\u7801\u9519\u8bef\uff0c\u8d26\u53f7\u88ab\u9501\u5b9a\uff0c\u8bf7" + LoginHelpUtil.getMaxLockMinutes() + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user.getUserName(), reqVo.getFromType(), user.getForceChangePassword(), reqVo, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmail(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        long emailLockMinutes = LoginHelpUtil.getLockMinutes(null, null, (String)reqVo.getEmail());
        if (emailLockMinutes != 0L) {
            throw new BusinessException("\u90ae\u7bb1\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + emailLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        List list = ((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getEmail, (Object)reqVo.getEmail())).select(new SFunction[]{MdmUserEntity::getUserName, MdmUserEntity::getFullName, MdmUserEntity::getUserPassword, MdmUserEntity::getUserPhone, MdmUserEntity::getEmail, MdmUserEntity::getUserType, MdmUserEntity::getStartTime, MdmUserEntity::getEndTime, CrmBaseEntity::getEnableStatus, MdmUserEntity::getForceChangePassword}).list();
        Assert.notEmpty((Collection)list, (String)"\u90ae\u7bb1\u4e0d\u5b58\u5728");
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u90ae\u7bb1\u5bf9\u5e94\u591a\u4e2a\u8d26\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        MdmUserEntity user = (MdmUserEntity)list.get(0);
        Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(user.getUserType()), (String)"\u975e\u4f01\u4e1a\u7528\u6237\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)"\u7528\u6237\u5df2\u7ecf\u505c\u7528");
        Assert.isTrue((boolean)LoginHelpUtil.checkStartEndTime((String)user.getStartTime(), (String)user.getEndTime()), (String)"\u7528\u6237\u4e0d\u5728\u6709\u6548\u671f");
        if (!Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            long phoneLastTimes = LoginHelpUtil.addErrorAndGetTimes((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
            if (phoneLastTimes != 0L) {
                throw new BusinessException("\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + phoneLastTimes + "\u6b21\u5c1d\u8bd5\u673a\u4f1a");
            }
            throw new BusinessException("\u5bc6\u7801\u9519\u8bef\uff0c\u8d26\u53f7\u88ab\u9501\u5b9a\uff0c\u8bf7" + LoginHelpUtil.getMaxLockMinutes() + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user.getUserName(), reqVo.getFromType(), user.getForceChangePassword(), reqVo, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhoneVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        String userName = LoginHelpUtil.getUserNameByPhoneAndVerificationCode((String)reqVo.getFromType(), (String)reqVo.getUserPhone(), (String)reqVo.getVerificationCode());
        if (StringUtils.isEmpty((String)userName)) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        MdmUserEntity user = (MdmUserEntity)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).select(new SFunction[]{MdmUserEntity::getUserName, MdmUserEntity::getFullName, MdmUserEntity::getUserPassword, MdmUserEntity::getUserPhone, MdmUserEntity::getEmail, MdmUserEntity::getUserType, MdmUserEntity::getStartTime, MdmUserEntity::getEndTime, CrmBaseEntity::getEnableStatus, MdmUserEntity::getForceChangePassword}).one();
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)"\u7528\u6237\u5df2\u7ecf\u505c\u7528");
        Assert.isTrue((boolean)LoginHelpUtil.checkStartEndTime((String)user.getStartTime(), (String)user.getEndTime()), (String)"\u7528\u6237\u4e0d\u5728\u6709\u6548\u671f");
        return this.doLoginThisSystem(user.getUserName(), reqVo.getFromType(), user.getForceChangePassword(), reqVo, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmailVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        String userName = LoginHelpUtil.getUserNameByEmailVerificationCode((String)reqVo.getFromType(), (String)reqVo.getEmail(), (String)reqVo.getVerificationCode());
        if (StringUtils.isEmpty((String)userName)) {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        MdmUserEntity user = (MdmUserEntity)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).select(new SFunction[]{MdmUserEntity::getUserName, MdmUserEntity::getFullName, MdmUserEntity::getUserPassword, MdmUserEntity::getUserPhone, MdmUserEntity::getEmail, MdmUserEntity::getUserType, MdmUserEntity::getStartTime, MdmUserEntity::getEndTime, CrmBaseEntity::getEnableStatus, MdmUserEntity::getForceChangePassword}).one();
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)"\u7528\u6237\u5df2\u7ecf\u505c\u7528");
        Assert.isTrue((boolean)LoginHelpUtil.checkStartEndTime((String)user.getStartTime(), (String)user.getEndTime()), (String)"\u7528\u6237\u4e0d\u5728\u6709\u6548\u671f");
        return this.doLoginThisSystem(user.getUserName(), reqVo.getFromType(), user.getForceChangePassword(), reqVo, true);
    }

    @Override
    public void sendLoginVerificationCodeByMessage(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        long phoneLockMinutes = LoginHelpUtil.getLockMinutes(null, (String)reqVo.getUserPhone(), null);
        if (phoneLockMinutes != 0L) {
            throw new BusinessException("\u624b\u673a\u53f7\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + phoneLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        List list = ((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserPhone, (Object)reqVo.getUserPhone())).select(new SFunction[]{MdmUserEntity::getUserName, MdmUserEntity::getFullName, MdmUserEntity::getUserPassword, MdmUserEntity::getUserPhone, MdmUserEntity::getEmail, MdmUserEntity::getUserType, MdmUserEntity::getStartTime, MdmUserEntity::getEndTime, CrmBaseEntity::getEnableStatus, MdmUserEntity::getForceChangePassword}).list();
        Assert.notEmpty((Collection)list, (String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u5bf9\u5e94\u591a\u4e2a\u8d26\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        MdmUserEntity user = (MdmUserEntity)list.get(0);
        Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(user.getUserType()), (String)"\u975e\u4f01\u4e1a\u7528\u6237\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)"\u7528\u6237\u5df2\u7ecf\u505c\u7528");
        Assert.isTrue((boolean)LoginHelpUtil.checkStartEndTime((String)user.getStartTime(), (String)user.getEndTime()), (String)"\u7528\u6237\u4e0d\u5728\u6709\u6548\u671f");
        String verification = LoginHelpUtil.saveVerificationCodeRelUserAndPhone((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getUserPhone());
        LoginHelpUtil.sendPhoneVerificationCode((String)reqVo.getFromType(), (String)user.getUserPhone(), (String)verification);
    }

    @Override
    public void sendLoginVerificationCodeByEmail(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        long emailLockMinutes = LoginHelpUtil.getLockMinutes(null, null, (String)reqVo.getEmail());
        if (emailLockMinutes != 0L) {
            throw new BusinessException("\u90ae\u7bb1\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + emailLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        List list = ((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getEmail, (Object)reqVo.getEmail())).select(new SFunction[]{MdmUserEntity::getUserName, MdmUserEntity::getFullName, MdmUserEntity::getUserPassword, MdmUserEntity::getUserPhone, MdmUserEntity::getEmail, MdmUserEntity::getUserType, MdmUserEntity::getStartTime, MdmUserEntity::getEndTime, CrmBaseEntity::getEnableStatus, MdmUserEntity::getForceChangePassword}).list();
        Assert.notEmpty((Collection)list, (String)"\u90ae\u7bb1\u4e0d\u5b58\u5728");
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u90ae\u7bb1\u5bf9\u5e94\u591a\u4e2a\u8d26\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        MdmUserEntity user = (MdmUserEntity)list.get(0);
        Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(user.getUserType()), (String)"\u975e\u4f01\u4e1a\u7528\u6237\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)"\u7528\u6237\u5df2\u7ecf\u505c\u7528");
        Assert.isTrue((boolean)LoginHelpUtil.checkStartEndTime((String)user.getStartTime(), (String)user.getEndTime()), (String)"\u7528\u6237\u4e0d\u5728\u6709\u6548\u671f");
        String verification = LoginHelpUtil.saveVerificationCodeRelUserAndEmail((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getEmail());
        LoginHelpUtil.sendEmailVerificationCode((String)reqVo.getFromType(), (String)user.getEmail(), (String)verification);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByOpenId(MdmAppletLoginReqVo reqVo) {
        String openId = reqVo.getOpenId();
        Assert.hasText((String)openId, (String)"\u7f3a\u5931openId");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmUserRelWeChatService.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)LoginFromTypeEnum.APPLET_SFA.getValue())).eq(MdmUserRelWeChatEntity::getOpenId, (Object)openId)).list();
        Assert.notEmpty((Collection)list, (String)"\u5fae\u4fe1\u672a\u7ed1\u5b9a\u4efb\u4f55\u7528\u6237");
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u7ed1\u5b9a\u4e86\u591a\u4e2a\u7528\u6237");
        MdmUserRelWeChatEntity one = (MdmUserRelWeChatEntity)list.get(0);
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"sfa_applet_user_unique_flag"))) {
            List userRelList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmUserRelWeChatService.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)LoginFromTypeEnum.APPLET_SFA.getValue())).eq(MdmUserRelWeChatEntity::getUserName, (Object)one.getUserName())).list();
            Assert.isTrue((userRelList.size() == 1 ? 1 : 0) != 0, (String)"\u7528\u6237\u7ed1\u5b9a\u4e86\u591a\u4e2a\u5fae\u4fe1\uff0c\u8bf7\u5148\u5728\u540e\u53f0\u89e3\u7ed1");
        }
        Assert.isTrue((boolean)YesNoEnum.yesNoEnum.ONE.getValue().equals(one.getLoginStatus()), (String)"\u5904\u4e8e\u9000\u51fa\u767b\u5f55\u72b6\u6001\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55");
        long userLockMinutes = LoginHelpUtil.getLockMinutes((String)reqVo.getUserName(), null, null);
        if (userLockMinutes != 0L) {
            throw new BusinessException("\u7528\u6237\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + userLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
        }
        MdmUserEntity user = (MdmUserEntity)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)reqVo.getUserName())).select(new SFunction[]{MdmUserEntity::getUserName, MdmUserEntity::getUserPassword, MdmUserEntity::getUserPhone, MdmUserEntity::getEmail, MdmUserEntity::getUserType, CrmBaseEntity::getEnableStatus, MdmUserEntity::getForceChangePassword}).one();
        Assert.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(user.getUserType()), (String)"\u975e\u4f01\u4e1a\u7528\u6237\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(user.getEnableStatus()), (String)"\u7528\u6237\u5df2\u7ecf\u505c\u7528");
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user.getUserName(), reqVo.getFromType(), user.getForceChangePassword(), reqVo, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logout() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.logout();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logoutFromType() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.logout((String)LoginFromTypeEnum.APPLET_SFA.getValue());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logoutAll() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.deleteUser((String)user.getUsername());
        }
    }

    @Override
    public MdmLoginRespVo sfaAppletLogin(MdmLoginReqVo mdmLoginReqVo) {
        return this.mdmSystemLoginService.systemLogin(mdmLoginReqVo);
    }

    @Override
    public MdmLoginRespVo sfaAppletLoginByOpenId(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        return this.mdmSystemLoginService.sfaAppletLoginByOpenId(reqVo);
    }

    @Override
    public MdmLoginRespVo sfaAppletLoginAndBind(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        return this.mdmSystemLoginService.sfaAppletLoginAndBind(reqVo);
    }

    @Override
    public void sfaAppletLogout() {
        UserRedis user = UserUtils.getUser();
        if (user != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
            this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        UserUtils.logout((String)LoginFromTypeEnum.APPLET_SFA.getValue());
    }

    private MdmLoginRespVo doLoginThisSystem(String userName, String fromType, String forceChangePassword, MdmAppletLoginReqVo reqVo, boolean bind) {
        MdmPositionUserOrgRespVo positionUserOrg = this.mdmPositionService.getCurrentPositionByUserName(userName);
        if (bind && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getOpenId())) {
            MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
            CrmBeanUtil.copyProperties((Object)reqVo, (Object)bindReq);
            bindReq.setOriginModule(fromType);
            bindReq.setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmUserRelWeChatService.bind(bindReq);
        }
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(positionUserOrg.getUserName());
        userRedis.setRealname(positionUserOrg.getFullName());
        userRedis.setPoscode(positionUserOrg.getPositionCode());
        userRedis.setPosname(positionUserOrg.getPositionName());
        userRedis.setOrgcode(positionUserOrg.getOrgCode());
        userRedis.setOrgname(positionUserOrg.getOrgName());
        userRedis.setFromtype(fromType);
        userRedis.setOpenId(reqVo.getOpenId());
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(positionUserOrg.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(positionUserOrg.getUserName());
        mdmLoginRespVo.setFullName(positionUserOrg.getFullName());
        mdmLoginRespVo.setPositionCode(positionUserOrg.getPositionCode());
        mdmLoginRespVo.setPositionName(positionUserOrg.getPositionName());
        mdmLoginRespVo.setOrgCode(positionUserOrg.getOrgCode());
        mdmLoginRespVo.setOrgName(positionUserOrg.getOrgName());
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        if (YesNoEnum.yesNoEnum.ONE.getValue().equals(forceChangePassword)) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        MdmUserLoginLogRespVo lastLoginLog = this.mdmUserLoginLogService.getLastLoginLog(userName, null);
        mdmLoginRespVo.setLastLoginLog(lastLoginLog);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        this.mdmUserLoginLogAsyncService.saveLoginLog(request, positionUserOrg.getUserName(), positionUserOrg.getFullName(), fromType, DateUtil.dateNowHms());
        return mdmLoginRespVo;
    }
}

