/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sys.index.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.sys.MdmIndexConfigLoginTypeControlVo;
import com.biz.crm.nebular.mdm.sys.MdmIndexConfigVo;
import com.biz.crm.sys.index.entity.MdmIndexConfigEntity;
import com.biz.crm.sys.index.service.MdmIndexConfigService;
import com.biz.crm.sys.index.vo.MdmIndexConfigStopOrOpenOrDeleteVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7cfb\u7edf\u9996\u9875\u914d\u7f6e", tags={"\u7cfb\u7edf\u9996\u9875\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/sys/mdmIndexConfigController"})
public class MdmIndexConfigController {
    @Autowired
    private MdmIndexConfigService mdmIndexConfigService;
    @Autowired
    private MdmDictDataService mdmDictDataService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmIndexConfigVo>> list(@RequestBody MdmIndexConfigVo vo) {
        PageResult<MdmIndexConfigVo> result = this.mdmIndexConfigService.findList(vo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u542f\u7528\u6216\u505c\u7528")
    @PostMapping(value={"/stopOrOpen"})
    @CrmLog
    public Result stopOrOpen(@RequestBody MdmIndexConfigStopOrOpenOrDeleteVo vo) {
        this.mdmIndexConfigService.stopOrOpen(vo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmIndexConfigService.delete(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmLog
    public Result<MdmIndexConfigVo> detail(@RequestParam(value="id") String id) {
        Result result = new Result();
        MdmIndexConfigVo mdmIndexConfigVo = this.mdmIndexConfigService.detail(id);
        result.setResult((Object)mdmIndexConfigVo);
        return result;
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u8005\u4fee\u6539", httpMethod="POST")
    @PostMapping(value={"/saveOrUpdate"})
    @CrmLog
    public Result<MdmIndexConfigVo> saveOrUpdateEntity(@RequestBody MdmIndexConfigVo mdmIndexConfigVo) {
        Result result = new Result();
        this.mdmIndexConfigService.saveOrUpdateEntity(mdmIndexConfigVo);
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u914d\u7f6e", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataType", value="dataType", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/config"})
    @CrmLog
    public Result<MdmIndexConfigVo> config(@RequestParam(value="dataType") String dataType) {
        Result result = new Result();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"data_type", (Object)dataType);
        List list = this.mdmIndexConfigService.list((Wrapper)queryWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            MdmIndexConfigVo mdmIndexConfigVo = this.mdmIndexConfigService.detail(((MdmIndexConfigEntity)list.get(0)).getId());
            if (mdmIndexConfigVo != null) {
                mdmIndexConfigVo.setLoginTypeControl(this.getLoginTypeControl(dataType));
            }
            result.setResult((Object)mdmIndexConfigVo);
        } else {
            result.error500("\u672a\u914d\u7f6e\u53c2\u6570");
        }
        return result;
    }

    private MdmIndexConfigLoginTypeControlVo getLoginTypeControl(String dataType) {
        MdmIndexConfigLoginTypeControlVo controlVo = new MdmIndexConfigLoginTypeControlVo();
        try {
            Map<String, String> map = ((LambdaQueryChainWrapper)this.mdmDictDataService.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)"login_control_config")).select(new SFunction[]{MdmDictDataEntity::getDictCode, MdmDictDataEntity::getDictValue}).list().stream().collect(Collectors.toMap(MdmDictDataEntity::getDictCode, MdmDictDataEntity::getDictValue));
            if ("1".equals(dataType)) {
                controlVo.setLoginByUserName(map.get("system_login_by_user_name_pwd"));
                controlVo.setLoginByPhone(map.get("system_login_by_phone_pwd"));
                controlVo.setLoginByPhoneVerification(map.get("system_login_by_phone_verification"));
                controlVo.setLoginByEmail(map.get("system_login_by_email_pwd"));
                controlVo.setLoginByEmailVerification(map.get("system_login_by_email_verification"));
                controlVo.setLoginByWeChatWork(map.get("system_login_by_we_chat_work"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return controlVo;
    }
}

