/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmDmsMallLoginService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.mdm.LoginHelpUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDmsMallLoginServiceExpandImpl"})
public class MdmDmsMallLoginServiceImpl
implements MdmDmsMallLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmDmsMallLoginServiceImpl.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Autowired
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;
    @Resource
    private MdmUserLoginLogService mdmUserLoginLogService;
    @Resource
    private MdmUserLoginLogAsyncService mdmUserLoginLogAsyncService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo login(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        LoginHelpUtil.checkLock((String)reqVo.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(reqVo.getUserName(), null, null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        } else {
            LoginHelpUtil.addError((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhone(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        } else {
            LoginHelpUtil.addError((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        } else {
            LoginHelpUtil.addError((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhoneVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        String userName = LoginHelpUtil.checkVerificationCode((String)reqVo.getFromType(), (String)reqVo.getVerificationCode(), (String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmailVerification(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        String userName = LoginHelpUtil.checkVerificationCode((String)reqVo.getFromType(), (String)reqVo.getVerificationCode(), (String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo.getFromType(), true, false);
    }

    @Override
    public void sendVerificationForLoginByMessage(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkLock((String)user.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        LoginHelpUtil.checkLock((String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        LoginHelpUtil.sendVerificationCode((String)reqVo.getFromType(), (String)verification, (String)user.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    public void sendVerificationForLoginByEmail(MdmLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkLock((String)user.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        LoginHelpUtil.checkLock((String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        LoginHelpUtil.sendVerificationCode((String)reqVo.getFromType(), (String)verification, (String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    private MdmLoginRespVo doLoginThisSystem(MdmUserRespVo user, String fromType, boolean getLastLoginLog, boolean resetPassword) {
        MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.getUserCurrentCustomer(user.getUserName());
        if (customer == null) {
            throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u672a\u5173\u8054\u5ba2\u6237\u7528\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(user.getUserName());
        userRedis.setRealname(user.getFullName());
        userRedis.setCustcode(customer.getCustomerCode());
        userRedis.setCustname(customer.getCustomerName());
        userRedis.setFromtype(fromType);
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(user.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(user.getUserName());
        mdmLoginRespVo.setFullName(user.getFullName());
        mdmLoginRespVo.setCustomerCode(customer.getCustomerCode());
        mdmLoginRespVo.setCustomerName(customer.getCustomerName());
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
        if (getLastLoginLog) {
            MdmUserLoginLogRespVo lastLoginLog = this.mdmUserLoginLogService.getLastLoginLog(user.getUserName(), null);
            mdmLoginRespVo.setLastLoginLog(lastLoginLog);
        }
        if (resetPassword) {
            this.mdmUserService.setUserForceChangePassword(user.getUserName());
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        } else if (YesNoEnum.yesNoEnum.ONE.getValue().equals(user.getForceChangePassword())) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        this.mdmUserLoginLogAsyncService.saveLoginLog(request, user.getUserName(), user.getFullName(), fromType, DateUtil.dateNowHms());
        return mdmLoginRespVo;
    }

    protected void storeRedis(MdmUserRespVo mdmUserRespVo, MdmCustomerMsgRespVo mdmCustomerMsgRespVo, String token, List<String> orgCodeList) {
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(mdmUserRespVo.getUserName());
        userRedis.setRealname(mdmUserRespVo.getFullName());
        userRedis.setCustname(mdmCustomerMsgRespVo.getCustomerName());
        userRedis.setCustcode(mdmCustomerMsgRespVo.getCustomerCode());
        userRedis.setFromtype(LoginFromTypeEnum.WEB_DMS.getValue());
        if (!CollectionUtils.isEmpty(orgCodeList)) {
            userRedis.setOrgcode(String.join((CharSequence)",", orgCodeList));
        }
        UserUtils.setUser((String)token, (UserRedis)userRedis);
    }

    protected MdmUserRespVo validUser(MdmLoginReqVo mdmLoginReqVo) {
        String enableStatus;
        String userName = mdmLoginReqVo.getUserName();
        String password = mdmLoginReqVo.getPassword();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserReqVo mdmUserReqVo = new MdmUserReqVo();
        mdmUserReqVo.setUserName(userName);
        MdmUserRespVo mdmUserRespVo = this.mdmUserService.queryBasic(mdmUserReqVo);
        Assert.notNull((Object)mdmUserRespVo, (String)"\u5ba2\u6237\u7528\u6237\u4e0d\u5b58\u5728");
        String userType = mdmUserRespVo.getUserType();
        Assert.hasText((String)userType, (String)"\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(userType), (String)"\u5ba2\u6237\u7528\u6237\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u7528\u6237\u4fe1\u606f:{}", (Object)mdmUserRespVo);
        this.mdmSystemLoginService.validLock(mdmUserRespVo.getUserName());
        String encryPwd = Md5EncryptionAndDecryption.encryPwd((String)password);
        if (StringUtils.isEmpty((Object)encryPwd) || !encryPwd.equals(mdmUserRespVo.getUserPassword())) {
            this.mdmSystemLoginService.updateLock(mdmUserRespVo.getUserName());
        } else {
            this.mdmSystemLoginService.clearLock(mdmUserRespVo.getUserName());
        }
        String startTime = mdmUserRespVo.getStartTime();
        String endTime = mdmUserRespVo.getEndTime();
        if (!StringUtils.isEmpty((Object)startTime) && !StringUtils.isEmpty((Object)endTime)) {
            String format = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            Assert.isTrue((format.compareTo(startTime) >= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u751f\u6548");
            Assert.isTrue((format.compareTo(endTime) <= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u5df2\u5931\u6548");
        }
        Assert.isTrue((!StringUtils.isEmpty((Object)(enableStatus = mdmUserRespVo.getEnableStatus())) && CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatus) ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u542f\u7528");
        return mdmUserRespVo;
    }

    @Override
    public MdmLoginRespVo dmsMallLogin(MdmLoginReqVo mdmLoginReqVo) {
        MdmUserRespVo mdmUserRespVo = this.validUser(mdmLoginReqVo);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.validCustomer(mdmUserRespVo);
        List<String> orgCodeList = this.mdmCustomerROrgService.findOrgCodeByCustomerCode(mdmCustomerMsgRespVo.getCustomerCode());
        String token = UUID.randomUUID().toString().replace("-", "");
        this.storeRedis(mdmUserRespVo, mdmCustomerMsgRespVo, token, orgCodeList);
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(mdmUserRespVo.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(mdmUserRespVo.getUserName());
        mdmLoginRespVo.setFullName(mdmUserRespVo.getFullName());
        if (!CollectionUtils.isEmpty(orgCodeList)) {
            mdmLoginRespVo.setOrgCode(String.join((CharSequence)",", orgCodeList));
        }
        mdmLoginRespVo.setCustomerCode(mdmCustomerMsgRespVo.getCustomerCode());
        mdmLoginRespVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
        MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.query(null, mdmCustomerMsgRespVo.getCustomerCode());
        Assert.isTrue((customer != null && CrmEnableStatusEnum.ENABLE.getCode().equals(customer.getEnableStatus()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528");
        mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
        return mdmLoginRespVo;
    }

    @Override
    public void dmsMallLogout() {
        UserUtils.logout((String)LoginFromTypeEnum.WEB_DMS.getValue());
    }

    protected MdmCustomerMsgRespVo validCustomer(MdmUserRespVo mdmUserRespVo) {
        MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.getUserCurrentCustomer(mdmUserRespVo.getUserName());
        Assert.notNull((Object)customer, (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5173\u8054\u5ba2\u6237");
        log.info("[dms\u5546\u57ce\u767b\u5f55]\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)customer);
        return customer;
    }
}

