/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmSfaAppletLoginService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.user.model.MdmUserRelWeChatEntity;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.mdm.LoginHelpUtil;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmSfaAppletLoginServiceExpandImpl"})
public class MdmSfaAppletLoginServiceImpl
implements MdmSfaAppletLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmSfaAppletLoginServiceImpl.class);
    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;
    @Autowired
    private MdmUserRelWeChatService mdmUserRelWeChatService;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmUserLoginLogService mdmUserLoginLogService;
    @Resource
    private MdmUserLoginLogAsyncService mdmUserLoginLogAsyncService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo login(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(reqVo.getUserName(), null, null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        } else {
            LoginHelpUtil.addError((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhone(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        } else {
            LoginHelpUtil.addError((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmail(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        } else {
            LoginHelpUtil.addError((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhoneVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        String userName = LoginHelpUtil.checkVerificationCode((String)reqVo.getFromType(), (String)reqVo.getVerificationCode(), (String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmailVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        String userName = LoginHelpUtil.checkVerificationCode((String)reqVo.getFromType(), (String)reqVo.getVerificationCode(), (String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    public void sendVerificationForLoginByMessage(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkLock((String)user.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        LoginHelpUtil.checkLock((String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        LoginHelpUtil.sendVerificationCode((String)reqVo.getFromType(), (String)verification, (String)user.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    public void sendVerificationForLoginByEmail(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkLock((String)user.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        LoginHelpUtil.checkLock((String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        LoginHelpUtil.sendVerificationCode((String)reqVo.getFromType(), (String)verification, (String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByOpenId(MdmAppletLoginReqVo reqVo) {
        String openId = reqVo.getOpenId();
        Assert.hasText((String)openId, (String)"\u7f3a\u5931openId");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmUserRelWeChatService.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)LoginFromTypeEnum.APPLET_SFA.getValue())).eq(MdmUserRelWeChatEntity::getOpenId, (Object)openId)).list();
        Assert.notEmpty((Collection)list, (String)"\u5fae\u4fe1\u672a\u7ed1\u5b9a\u4efb\u4f55\u7528\u6237");
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u7ed1\u5b9a\u4e86\u591a\u4e2a\u7528\u6237");
        MdmUserRelWeChatEntity one = (MdmUserRelWeChatEntity)list.get(0);
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"sfa_applet_user_unique_flag"))) {
            List userRelList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmUserRelWeChatService.lambdaQuery().eq(MdmUserRelWeChatEntity::getOriginModule, (Object)LoginFromTypeEnum.APPLET_SFA.getValue())).eq(MdmUserRelWeChatEntity::getUserName, (Object)one.getUserName())).list();
            Assert.isTrue((userRelList.size() == 1 ? 1 : 0) != 0, (String)"\u7528\u6237\u7ed1\u5b9a\u4e86\u591a\u4e2a\u5fae\u4fe1\uff0c\u8bf7\u5148\u5728\u540e\u53f0\u89e3\u7ed1");
        }
        Assert.isTrue((boolean)YesNoEnum.yesNoEnum.ONE.getValue().equals(one.getLoginStatus()), (String)"\u5904\u4e8e\u9000\u51fa\u767b\u5f55\u72b6\u6001\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkLock((String)one.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(one.getUserName(), null, null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo, true, false, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logout() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.logout();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logoutFromType() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.logout((String)LoginFromTypeEnum.APPLET_SFA.getValue());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logoutAll() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.deleteUser((String)user.getUsername());
        }
    }

    @Override
    public MdmLoginRespVo sfaAppletLogin(MdmLoginReqVo mdmLoginReqVo) {
        return this.mdmSystemLoginService.systemLogin(mdmLoginReqVo);
    }

    @Override
    public MdmLoginRespVo sfaAppletLoginByOpenId(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        return this.mdmSystemLoginService.sfaAppletLoginByOpenId(reqVo);
    }

    @Override
    public MdmLoginRespVo sfaAppletLoginAndBind(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        return this.mdmSystemLoginService.sfaAppletLoginAndBind(reqVo);
    }

    @Override
    public void sfaAppletLogout() {
        UserRedis user = UserUtils.getUser();
        if (user != null && StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
            this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        UserUtils.logout((String)LoginFromTypeEnum.APPLET_SFA.getValue());
    }

    private MdmLoginRespVo doLoginThisSystem(MdmUserRespVo user, MdmAppletLoginReqVo reqVo, boolean getLastLoginLog, boolean resetPassword, boolean bind) {
        MdmPositionUserOrgRespVo positionUserOrg = this.mdmPositionService.getCurrentPositionByUserName(user.getUserName());
        if (bind && StringUtils.isNotEmpty((CharSequence)reqVo.getOpenId())) {
            MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
            CrmBeanUtil.copyProperties((Object)reqVo, (Object)bindReq);
            bindReq.setOriginModule(reqVo.getFromType());
            bindReq.setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmUserRelWeChatService.bind(bindReq);
        }
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(positionUserOrg.getUserName());
        userRedis.setRealname(positionUserOrg.getFullName());
        userRedis.setPoscode(positionUserOrg.getPositionCode());
        userRedis.setPosname(positionUserOrg.getPositionName());
        userRedis.setOrgcode(positionUserOrg.getOrgCode());
        userRedis.setOrgname(positionUserOrg.getOrgName());
        userRedis.setFromtype(reqVo.getFromType());
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(positionUserOrg.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(positionUserOrg.getUserName());
        mdmLoginRespVo.setFullName(positionUserOrg.getFullName());
        mdmLoginRespVo.setPositionCode(positionUserOrg.getPositionCode());
        mdmLoginRespVo.setPositionName(positionUserOrg.getPositionName());
        mdmLoginRespVo.setOrgCode(positionUserOrg.getOrgCode());
        mdmLoginRespVo.setOrgName(positionUserOrg.getOrgName());
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        if (getLastLoginLog) {
            MdmUserLoginLogRespVo lastLoginLog = this.mdmUserLoginLogService.getLastLoginLog(user.getUserName(), null);
            mdmLoginRespVo.setLastLoginLog(lastLoginLog);
        }
        if (resetPassword) {
            this.mdmUserService.setUserForceChangePassword(user.getUserName());
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        } else if (YesNoEnum.yesNoEnum.ONE.getValue().equals(user.getForceChangePassword())) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        this.mdmUserLoginLogAsyncService.saveLoginLog(request, positionUserOrg.getUserName(), positionUserOrg.getFullName(), reqVo.getFromType(), DateUtil.dateNowHms());
        return mdmLoginRespVo;
    }
}

