/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalCurrentAndSubVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalSelectRespVo;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.vo.UpdateTerminalCusOrgCodeVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmTerminalController"})
@Api(tags={"\u7ec8\u7aef\u4fe1\u606f"})
@CrmGlobalLog
public class MdmTerminalController {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalController.class);
    @Autowired
    private MdmTerminalService mdmTerminalService;

    @ApiOperation(value="\u7ec8\u7aef\u4fe1\u606f\u9875\u9762\u67e5\u8be2\u4e3b\u5217\u8868\uff08\u5176\u5b83\u529f\u80fd\u8bf7\u52ff\u4f7f\u7528\uff09")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmTerminalVo>> pageList(@RequestBody MdmTerminalVo mdmTerminalReqVo) {
        PageResult<MdmTerminalVo> result = this.mdmTerminalService.findList(mdmTerminalReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/page"})
    @CrmDictMethod
    public Result<PageResult<MdmTerminalVo>> page(@RequestBody MdmTerminalVo mdmTerminalReqVo) {
        mdmTerminalReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        PageResult<MdmTerminalVo> result = this.mdmTerminalService.findList(mdmTerminalReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="terminalCode", value="\u7ec8\u7aef\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/query"})
    @CrmDictMethod
    public Result<MdmTerminalVo> query(@RequestParam(value="id", required=false) String id, @RequestParam(value="terminalCode", required=false) String terminalCode) {
        MdmTerminalVo model = this.mdmTerminalService.query(id, terminalCode);
        return Result.ok((Object)model);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<Object> save(@RequestBody MdmTerminalVo mdmTerminalVo) {
        return Result.ok((String)this.mdmTerminalService.save(mdmTerminalVo));
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody MdmTerminalVo mdmTerminalVo) {
        this.mdmTerminalService.update(mdmTerminalVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result<Object> delete(@RequestBody List<String> ids) {
        this.mdmTerminalService.deleteBatch(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u542f\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result<Object> enable(@RequestBody List<String> ids) {
        this.mdmTerminalService.enableBatch(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result<Object> disable(@RequestBody List<String> ids) {
        this.mdmTerminalService.disableBatch(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u7ec8\u7aef\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/updateCusOrgCode"})
    public Result<Object> updateCusOrgCode(@RequestBody UpdateTerminalCusOrgCodeVo vo) {
        this.mdmTerminalService.updateCusOrgCode(vo);
        return Result.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="orgCodes", value="\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec8\u7aef\u7f16\u7801\u96c6\u5408", httpMethod="POST")
    @PostMapping(value={"/findByOrgCodeList"})
    public Result<List<String>> findByOrgCodeList(@RequestBody List<String> orgCodes) {
        return Result.ok(this.mdmTerminalService.findByOrgCodeList(orgCodes));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u7ec8\u7aef\u53ca\u4e3b\u8054\u7cfb\u4eba\u5217\u8868")
    @PostMapping(value={"/findTerminalAndContactList"})
    public Result<PageResult<MdmTerminalContactPageVo>> findTerminalAndContactList(@RequestBody MdmTerminalCurrentAndSubVo mdmTerminalCurrentAndSubVo) {
        return Result.ok(this.mdmTerminalService.findTerminalAndContactList(mdmTerminalCurrentAndSubVo));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u7ec8\u7aef")
    @PostMapping(value={"/findCurrentAndSubTerminalList"})
    public Result<List<MdmTerminalVo>> findCurrentAndSubTerminalList(@RequestBody List<String> orgCodes) {
        return Result.ok(this.mdmTerminalService.findCurrentAndSubTerminalList(orgCodes));
    }

    @ApiOperation(value="\u6761\u4ef6\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/listCondition"})
    public Result<List<MdmTerminalVo>> listCondition(@RequestBody MdmTerminalVo vo) {
        return Result.ok(this.mdmTerminalService.listCondition(vo));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="posId", value="\u804c\u4f4dID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="posCode", value="\u804c\u4f4d\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @ApiOperation(value="\u6839\u636e\u804c\u4f4did\u6216\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u7ec8\u7aef\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/findPositionTerminalList"})
    public Result<List<MdmTerminalVo>> findPositionTerminalList(@RequestParam(value="posId", required=false) String posId, @RequestParam(value="posCode", required=false) String posCode) {
        return Result.ok(this.mdmTerminalService.findPositionTerminalList(posId, posCode));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="posId", value="\u804c\u4f4dID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="posCode", value="\u804c\u4f4d\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @ApiOperation(value="\u6839\u636e\u804c\u4f4did\u6216\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u53ca\u6240\u6709\u4e0b\u7ea7\u804c\u4f4d\u5bf9\u5e94\u7ec8\u7aef\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/findCurrentAndSybPositionTerminalList"})
    public Result<List<MdmTerminalVo>> findCurrentAndSybPositionTerminalList(@RequestParam(value="posId", required=false) String posId, @RequestParam(value="posCode", required=false) String posCode) {
        return Result.ok(this.mdmTerminalService.findCurrentAndSybPositionTerminalList(posId, posCode));
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4e0e\u7ec8\u7aef\u5173\u8054\u7684\u4f01\u4e1a\u7ec4\u7ec7\u7f16\u7801")
    @PostMapping(value={"/batchUpdateTerminalOrg"})
    public Result batchUpdateTerminalOrg(@RequestBody MdmOrgTerminalReqVo reqVo) {
        this.mdmTerminalService.batchUpdateTerminalOrg(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u804c\u4f4d\u7ec8\u7aef\u53ca\u4e3b\u8054\u7cfb\u4eba\u5217\u8868")
    @PostMapping(value={"/userTerminalContactPage"})
    @CrmDictMethod
    public Result<PageResult<MdmTerminalContactPageVo>> userTerminalContactPage(@RequestBody MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
        PageResult<MdmTerminalContactPageVo> result = this.mdmTerminalService.userTerminalContactPage(mdmTerminalContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6839\u636e\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec8\u7aef\u53ca\u4e3b\u8054\u7cfb\u4eba\u5217\u8868")
    @PostMapping(value={"/terminalContactPage"})
    @CrmDictMethod
    public Result<PageResult<MdmTerminalContactPageVo>> terminalContactPage(@RequestBody MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
        PageResult<MdmTerminalContactPageVo> result = this.mdmTerminalService.terminalContactPage(mdmTerminalContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u7ec8\u7aef\u4e3b\u8054\u7cfb\u4eba\u53ca\u8ddd\u79bb\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/distanceContactPage"})
    @CrmDictMethod
    public Result<PageResult<MdmTerminalContactPageVo>> distanceContactPage(@RequestBody MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo) {
        PageResult<MdmTerminalContactPageVo> result = this.mdmTerminalService.distanceContactPage(mdmTerminalDistanceContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec8\u7aef\u7ec4\u7ec7\u96c6\u5408")
    @PostMapping(value={"/detailBatch"})
    public Result<List<MdmOrgRespVo>> detailBatch(@RequestBody MdmTerminalVo vo) {
        List<MdmOrgRespVo> list = this.mdmTerminalService.detailBatch(vo);
        return Result.ok(list);
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u6216\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec8\u7aef\u4fe1\u606f")
    @PostMapping(value={"/customerTerminalList"})
    public Result<List<MdmTerminalVo>> customerTerminalList(@RequestBody MdmCustomerTerminalVo mdmCustomerTerminalVo) {
        List<MdmTerminalVo> list = this.mdmTerminalService.customerTerminalList(mdmCustomerTerminalVo);
        return Result.ok(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u804c\u4f4d\u5173\u8054\u7684\u7ec8\u7aef\u6570\u91cf")
    @GetMapping(value={"/findPositionRelationTerminalCount"})
    public Result<Long> findPositionRelationTerminalCount(@RequestParam(value="positionCode") String positionCode) {
        Long count = this.mdmTerminalService.findPositionRelationTerminalCount(positionCode);
        return Result.ok((Object)count);
    }

    @ApiOperation(value="\u67e5\u8be2\u804c\u4f4d\u5173\u8054\u7684\u4e8c\u6279\u5546\u6570\u91cf")
    @GetMapping(value={"/findPositionRelationTerminalCustomerCount"})
    public Result<Long> findPositionRelationTerminalCustomerCount(@RequestParam(value="positionCode") String positionCode) {
        Long count = this.mdmTerminalService.findPositionRelationTerminalCustomerCount(positionCode);
        return Result.ok((Object)count);
    }

    @ApiOperation(value="\u6839\u636e\u8425\u4e1a\u6ce8\u518c\u53f7\u6216\u7ec8\u7aef\u540d\u79f0\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/findDetailByRegisterOrName"})
    public Result<MdmTerminalVo> findDetailByRegisterOrName(@RequestParam(value="licenseRegisterNumber", required=false) String licenseRegisterNumber, @RequestParam(value="terminalName", required=false) String terminalName) {
        MdmTerminalVo mdmTerminalVo = this.mdmTerminalService.findDetailByRegisterOrName(licenseRegisterNumber, terminalName);
        return Result.ok((Object)mdmTerminalVo);
    }

    @ApiOperation(value="\u7ec8\u7aef\u4e0b\u62c9\u6846\uff08\u9650\u5236\u6570\u91cf\uff09")
    @PostMapping(value={"/select"})
    public Result<List<MdmTerminalSelectRespVo>> select(@RequestBody MdmTerminalSelectReqVo reqVo) {
        return Result.ok(this.mdmTerminalService.findTerminalSelectList(reqVo));
    }

    @ApiOperation(value="\u63d0\u4ea4\u5de5\u4f5c\u6d41\u5ba1\u6279")
    @PostMapping(value={"/submit"})
    public Result submit(@RequestBody MdmTerminalVo reqVo) {
        this.mdmTerminalService.submit(reqVo);
        return Result.ok((String)"\u63d0\u4ea4\u5ba1\u6279\u6210\u529f");
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u56de\u8c03\u63a5\u53e3")
    @PostMapping(value={"/activityCallBack"})
    public Result callback(@RequestBody ActivitiCallBackVo reqVo) {
        this.mdmTerminalService.callback(reqVo);
        return Result.ok((String)"\u6d3b\u52a8\u5ba1\u6279\u56de\u8c03\u6210\u529f");
    }

    @ApiOperation(value="\u72b6\u6001\u5ba1\u6279\uff0c\u63d0\u4ea4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/statusApprovalSubmit"})
    public Result<Object> statusApprovalSubmit(@RequestBody List<String> ids) {
        this.mdmTerminalService.statusApprovalSubmit(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u72b6\u6001\u5ba1\u6279\uff0c\u9a73\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/statusApprovalReject"})
    public Result<Object> statusApprovalReject(@RequestBody List<String> ids) {
        this.mdmTerminalService.statusApprovalReject(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u72b6\u6001\u5ba1\u6279\uff0c\u5ba1\u6279\u901a\u8fc7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/statusApprovalAgree"})
    public Result<Object> statusApprovalAgree(@RequestBody List<String> ids) {
        this.mdmTerminalService.statusApprovalAgree(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u4f9b\u8d27\u5173\u7cfb")
    @PostMapping(value={"/findCustomerByTerminalCode"})
    public Result<List<MdmTerminalSupplyVo>> findTerminalSupply(@RequestBody MdmTerminalVo mdmTerminalVo) {
        return Result.ok(this.mdmTerminalService.findTerminalSupply(mdmTerminalVo));
    }
}

