/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.customer.manager.MdmCustomerMsgBuilder;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.model.MdmCustomerROrgEntity;
import com.biz.crm.customer.model.MdmCustomerSaleAreaEntity;
import com.biz.crm.customer.service.MdmCustomerBillService;
import com.biz.crm.customer.service.MdmCustomerContactService;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.customer.service.MdmCustomerSaleAreaService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAndOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaReqVo;
import com.biz.crm.nebular.mdm.customer.MdmPositionCustomerSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmUpdateCusOrgCodeReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.role.mode.MdmRoleCustomerEntity;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleCustomerService;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.sfa.visitdealer.SfaVisitDealerDetailFeign;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.ApprovalConfigUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerMsgServiceExpandImpl"})
public class MdmCustomerMsgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerMsgMapper, MdmCustomerEntity>
implements MdmCustomerMsgService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMsgServiceImpl.class);
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmCustomerContactService mdmCustomerContactService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmCustomerSaleAreaService mdmCustomerSaleAreaService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmCustomerSupplyService mdmCustomerSupplyService;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private MdmRoleCustomerService mdmRoleCustomerService;
    @Resource
    private MdmRoleService mdmRoleService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Resource
    private MdmCustomerBillService mdmCustomerBillService;
    @Resource
    private SfaVisitDealerDetailFeign sfaVisitDealerDetailFeign;
    @Resource
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private MdmTerminalElasticsearchService elasticsearchService;

    @Override
    public PageResult<MdmCustomerMsgRespVo> findList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List listIncludeSelf;
        Page page = PageUtil.buildPage((Integer)mdmCustomerMsgReqVo.getPageNum(), (Integer)mdmCustomerMsgReqVo.getPageSize());
        if (!com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCode())) {
            List<String> orgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, mdmCustomerMsgReqVo.getCode());
            mdmCustomerMsgReqVo.setOrgCodeList(orgCodeList);
        } else if (!com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getOrgCode())) {
            mdmCustomerMsgReqVo.setOrgCodeList(Collections.singletonList(mdmCustomerMsgReqVo.getOrgCode()));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)mdmCustomerMsgReqVo.getAllUnderOrgCodeListIncludeSelf()) && CollectionUtil.listNotEmptyNotSizeZero((List)(listIncludeSelf = OrgUtil.getChildrenOrgCodeListIncludeSelf((List)mdmCustomerMsgReqVo.getAllUnderOrgCodeListIncludeSelf())))) {
            mdmCustomerMsgReqVo.setAllUnderOrgCodeListIncludeSelf(listIncludeSelf);
        }
        List<MdmCustomerMsgRespVo> list = this.mdmCustomerMsgMapper.findList((Page<MdmCustomerMsgRespVo>)page, mdmCustomerMsgReqVo);
        this.setUpOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    protected void setUpOrgName(List<MdmCustomerMsgRespVo> list) {
        List<String> orgCodeList;
        Map<String, String> orgNameMap;
        Map<String, List<String>> customerOrgMap;
        List<String> customerCodeList;
        if (!(CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(customerCodeList = list.stream().filter(x -> !com.biz.crm.util.StringUtils.isEmpty((String)x.getCustomerCode())).map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toList())) || ObjectUtils.isEmpty(customerOrgMap = this.mdmCustomerROrgService.findOrgCodeList(customerCodeList)) || ObjectUtils.isEmpty(orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList = customerOrgMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()))))) {
            for (MdmCustomerMsgRespVo mdmCustomerMsgRespVo : list) {
                List<String> currentOrgCodeList = customerOrgMap.get(mdmCustomerMsgRespVo.getCustomerCode());
                if (CollectionUtils.isEmpty(currentOrgCodeList)) continue;
                String orgName = currentOrgCodeList.stream().filter(x -> !com.biz.crm.util.StringUtils.isEmpty((String)x)).distinct().map(orgNameMap::get).collect(Collectors.joining(","));
                mdmCustomerMsgRespVo.setOrgName(orgName);
                mdmCustomerMsgRespVo.setOrgCode(currentOrgCodeList.stream().filter(x -> !com.biz.crm.util.StringUtils.isEmpty((String)x)).distinct().collect(Collectors.joining(",")));
            }
        }
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> list(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmCustomerMsgReqVo.getPageNum(), (Integer)mdmCustomerMsgReqVo.getPageSize());
        page.setSearchCount(false);
        return this.mdmCustomerMsgMapper.list(mdmCustomerMsgReqVo, (Page<MdmCustomerMsgSelectRespVo>)page);
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(MdmCustomerMsgSelectReqVo reqVo) {
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmCustomerMsgSelectRespVo> list = new ArrayList<MdmCustomerMsgSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        if (pageSize > 0) {
            list.addAll(this.mdmCustomerMsgMapper.findCustomerSelectList((Page<MdmCustomerMsgSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, null, null));
        }
        return list;
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerNotRelateUserSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        return this.mdmCustomerMsgMapper.findCustomerNotRelateUserSelectList(null, mdmCustomerMsgReqVo);
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return this.mdmCustomerMsgMapper.findByOrgCodeList(list);
    }

    @Override
    public MdmCustomerMsgRespVo query(String id, String customerCode) {
        if (com.biz.crm.util.StringUtils.isEmpty((String)id) && com.biz.crm.util.StringUtils.isEmpty((String)customerCode)) {
            return null;
        }
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setCustomerCode(customerCode);
        mdmCustomerMsgReqVo.setId(id);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.mdmCustomerMsgMapper.query(mdmCustomerMsgReqVo);
        return Optional.ofNullable(mdmCustomerMsgRespVo).map(x -> {
            this.setUpCustomer(mdmCustomerMsgRespVo);
            this.setUpOrgName(Collections.singletonList(mdmCustomerMsgRespVo));
            return mdmCustomerMsgRespVo;
        }).orElse(null);
    }

    protected void setUpCustomer(MdmCustomerMsgRespVo mdmCustomerMsgRespVo) {
        String customerCode = mdmCustomerMsgRespVo.getCustomerCode();
        Map map = DictUtil.dictMap((String)"customer_add_section");
        if (map != null) {
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("contact_information"))) {
                mdmCustomerMsgRespVo.setMdmCustomerContactVos(this.mdmCustomerContactService.list(new MdmCustomerContactReqVo().setCustomerCode(customerCode)));
            }
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("extended_information"))) {
                mdmCustomerMsgRespVo.setMdmCustomerDockingVos(this.mdmCustomerSupplyService.findDockingListByCustomerCode(new MdmCustomerDockingReqVo().setCustomerCode(customerCode)));
            }
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("sales_area"))) {
                mdmCustomerMsgRespVo.setMdmCustomerSaleAreaVos(this.mdmCustomerSaleAreaService.listCondition(new MdmCustomerSaleAreaReqVo().setCustomerCode(customerCode)));
            }
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("customer_bill"))) {
                mdmCustomerMsgRespVo.setMdmCustomerBillVos(this.mdmCustomerBillService.listCondition(customerCode));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setUpCollateral(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgRespVo oldObject = this.query(mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getCustomerCode());
        Map map = DictUtil.dictMap((String)"customer_add_section");
        if (map != null) {
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("contact_information"))) {
                this.mdmCustomerContactService.setUpContact(mdmCustomerMsgReqVo.getMdmCustomerContactVos(), mdmCustomerMsgReqVo.getCustomerCode());
            }
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("extended_information"))) {
                this.mdmCustomerSupplyService.setUpDocking(mdmCustomerMsgReqVo);
            }
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("sales_area"))) {
                this.mdmCustomerSaleAreaService.setUpArea(mdmCustomerMsgReqVo.getMdmCustomerSaleAreaVos(), mdmCustomerMsgReqVo.getCustomerCode());
            }
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("customer_bill"))) {
                this.mdmCustomerBillService.setUp(mdmCustomerMsgReqVo);
            }
        }
        this.mdmCustomerROrgService.setUpOrg(mdmCustomerMsgReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getActApproveStatus())) {
            if (ActApproveStatusEnum.CREATE.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
            }
            if (ActApproveStatusEnum.APPROVING.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
            }
            if (ActApproveStatusEnum.APPROVED.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            }
            if (ActApproveStatusEnum.REJECTED.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
            }
            if (ActApproveStatusEnum.INTERRUPT.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
            }
            if (ActApproveStatusEnum.CLOSED.getCode().equals(mdmCustomerMsgReqVo.getActApproveStatus())) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.CLOSE.getValue());
            }
        }
        if ((com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getActApproveStatus()) || !MdmBpmStatusEnum.PASS.getValue().equals(mdmCustomerMsgReqVo.getActApproveStatus())) && com.biz.crm.util.StringUtils.isNotEmpty((String)mdmCustomerMsgReqVo.getApprovalBusinessCode())) {
            ApprovalType approvalType = ApprovalConfigUtil.checkAndGet((String)mdmCustomerMsgReqVo.getApprovalBusinessCode(), (Object)mdmCustomerMsgReqVo);
            mdmCustomerMsgReqVo.setApprovalType(approvalType.getValue());
            if (approvalType == ApprovalType.NULL) {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            } else {
                mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
            }
        }
        if (com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getApprovalType())) {
            mdmCustomerMsgReqVo.setApprovalType(ApprovalType.NULL.getValue());
            mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        }
        MdmCustomerMsgBuilder.builder(true, this, this.mdmUserService).init(mdmCustomerMsgReqVo).valid().convert().persistence().after();
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), mdmCustomerMsgReqVo.getCustomerCode(), mdmCustomerMsgReqVo.getCustomerCode(), CrmBeanUtil.copy((Object)mdmCustomerMsgReqVo, MdmCustomerMsgRespVo.class));
        }
        mdmCustomerMsgReqVo.setId(((MdmCustomerEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)mdmCustomerMsgReqVo.getCustomerCode())).one()).getId());
        this.elasticsearchService.add(null, mdmCustomerMsgReqVo);
        return mdmCustomerMsgReqVo.getCustomerCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        MdmCustomerMsgRespVo oldObject = this.query(mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getCustomerCode());
        Assert.notNull((Object)oldObject, (String)"\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e");
        MdmCustomerMsgBuilder.builder(false, this, this.mdmUserService).init(mdmCustomerMsgReqVo).valid().convert().persistence().after();
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        MdmCustomerMsgRespVo newObject = this.query(mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getCustomerCode());
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), mdmCustomerMsgReqVo.getId(), mdmCustomerMsgReqVo.getId(), (Object)oldObject, (Object)newObject);
        }
        this.elasticsearchService.add(null, mdmCustomerMsgReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Object menuCodeObj;
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        List<String> customerCodeList = list.stream().filter(x -> x != null && !com.biz.crm.util.StringUtils.isEmpty((String)x.getCustomerCode())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        List<String> sendCustomerCodeList = list.stream().filter(x -> x != null && !com.biz.crm.util.StringUtils.isEmpty((String)x.getCustomerCode()) && MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        List<String> userNameList = list.stream().filter(x -> x != null && !com.biz.crm.util.StringUtils.isEmpty((String)x.getUserName())).map(MdmCustomerEntity::getUserName).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            ((LambdaUpdateChainWrapper)this.mdmCustomerROrgService.lambdaUpdate().in(MdmCustomerROrgEntity::getCustomerCode, customerCodeList)).remove();
            ((LambdaUpdateChainWrapper)this.mdmCustomerSaleAreaService.lambdaUpdate().in(MdmCustomerSaleAreaEntity::getCustomerCode, customerCodeList)).remove();
            this.mdmCustomerSupplyService.removeByCustomerCodeList(customerCodeList);
            ((LambdaUpdateChainWrapper)this.mdmCustomerContactService.lambdaUpdate().in(MdmCustomerContactEntity::getCustomerCode, customerCodeList)).remove();
        }
        if ((menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode")) != null) {
            list.forEach(item -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), item.getId(), mdmCustomerMsgReqVo.getCustomerCode(), item));
        }
        this.removeByIds(ids);
        this.mdmUserService.updateUserCustomerRedundancyByUser(null, userNameList);
        this.sendCustomerChangeMsg(sendCustomerCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Object menuCodeObj;
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getActApproveStatus}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmCustomerMsgReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
            this.sendCustomerChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()));
        }
        if ((menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode")) != null) {
            list.forEach(item -> {
                MdmCustomerMsgRespVo oldObject = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                MdmCustomerMsgRespVo newObject = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getCustomerCode(), (Object)oldObject, (Object)newObject);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        Object menuCodeObj;
        List ids = mdmCustomerMsgReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getActApproveStatus}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)mdmCustomerMsgReqVo.getIds())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
            this.sendCustomerChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()));
        }
        if ((menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode")) != null) {
            list.forEach(item -> {
                MdmCustomerMsgRespVo oldObject = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                MdmCustomerMsgRespVo newObject = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getCustomerCode(), (Object)oldObject, (Object)newObject);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateBatch(List<MdmCustomerContactReqVo> mdmCustomerContactReqVos) {
        if (!CollectionUtils.isEmpty(mdmCustomerContactReqVos)) {
            this.mdmCustomerContactService.saveOrUpdateBatch(CrmBeanUtil.copyList(mdmCustomerContactReqVos, MdmCustomerContactEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrgCodeByCondition(MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo) {
        List customerCodeList = mdmUpdateCusOrgCodeReqVo.getCustomerCodeList();
        String customerOrgCode = mdmUpdateCusOrgCodeReqVo.getCustomerOrgCode();
        if (CollectionUtils.isEmpty((Collection)customerCodeList) || com.biz.crm.util.StringUtils.isEmpty((String)customerOrgCode)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u6216\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmCustomerEntity::getCustomerCode, (Collection)customerCodeList)).set(MdmCustomerEntity::getCustomerOrgCode, (Object)customerOrgCode)).update();
        List<String> sendCustomerCodeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getCustomerCode, (Collection)customerCodeList)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list().stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        this.sendCustomerChangeMsg(sendCustomerCodeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateCustomerOrg(MdmOrgCustomerUpdateReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getOriginOrgCode())) {
            this.mdmCustomerROrgService.replaceOrg(reqVo.getCustomerCodeList(), reqVo.getOriginOrgCode(), reqVo.getOrgCode());
        } else {
            this.mdmCustomerROrgService.setUpOrg(reqVo.getCustomerCodeList(), reqVo.getOrgCode());
        }
        List<String> sendCustomerCodeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getCustomerCode, (Collection)reqVo.getCustomerCodeList())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list().stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
        this.sendCustomerChangeMsg(sendCustomerCodeList);
    }

    @Override
    public Map<String, String> findOrgCodeByCustomerCodeList(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Collections.emptyMap();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getCustomerCode, customerCodeList)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getOrgCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(MdmCustomerEntity::getCustomerCode, MdmCustomerEntity::getOrgCode));
    }

    @Override
    public Map<String, List<String>> findOrgCodeListByCustomerCodeList(List<String> customerCodeList) {
        return this.mdmCustomerROrgService.findOrgCodeList(customerCodeList);
    }

    @Override
    public List<String> findAllCustomerCodeByUser(String userAccount) {
        if (com.biz.crm.util.StringUtils.isEmpty((String)userAccount)) {
            return Collections.emptyList();
        }
        return this.mdmCustomerMsgMapper.findAllCustomerApprovedCodeByUser(userAccount, MdmBpmStatusEnum.PASS.getValue());
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerAndOrgReqVo mdmCustomerOrgSearchReqVo) {
        Map<String, List<String>> groupOrgCodeMap;
        List orgCodeList = mdmCustomerOrgSearchReqVo.getOrgCodeList();
        List customerCodeList = mdmCustomerOrgSearchReqVo.getCustomerCodeList();
        if (CollectionUtils.isEmpty((Collection)orgCodeList) && CollectionUtils.isEmpty((Collection)customerCodeList)) {
            return Collections.emptyList();
        }
        List children = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)orgCodeList)) {
            children = OrgUtil.getChildrenOrgListIncludeSelfEnable((List)orgCodeList);
            orgCodeList = CollectionUtils.isEmpty(children) ? null : children.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            mdmCustomerOrgSearchReqVo.setOrgCodeList(orgCodeList);
        }
        List<Object> currentAndSubCustomerList = this.mdmCustomerMsgMapper.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        if (CollectionUtils.isEmpty(currentAndSubCustomerList = currentAndSubCustomerList.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList()))) {
            return Collections.emptyList();
        }
        List<String> searchCustomerCodeList = currentAndSubCustomerList.stream().map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(searchCustomerCodeList) && (groupOrgCodeMap = this.mdmCustomerROrgService.findOrgCodeList(searchCustomerCodeList)) != null && groupOrgCodeMap.size() > 0) {
            List allOrgCodeList = groupOrgCodeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            List mdmOrgRespVos = OrgUtil.getOrgByCodeList(allOrgCodeList);
            for (MdmCustomerMsgRespVo mdmCustomerMsgRespVo : currentAndSubCustomerList) {
                List<String> currentOrgCodeList = groupOrgCodeMap.get(mdmCustomerMsgRespVo.getCustomerCode());
                if (CollectionUtils.isEmpty(currentOrgCodeList)) continue;
                mdmCustomerMsgRespVo.setOrgCode(String.join((CharSequence)",", currentOrgCodeList));
                String orgName = mdmOrgRespVos.stream().filter(x -> currentOrgCodeList.contains(x.getOrgCode())).map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(","));
                mdmCustomerMsgRespVo.setOrgName(orgName);
            }
        }
        return currentAndSubCustomerList;
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        List orgCodeList;
        Integer pageSize;
        Integer pageNum = mdmCustomerOrgSearchReqVo.getPageNum();
        if (pageNum == null) {
            pageNum = 0;
        }
        if ((pageSize = mdmCustomerOrgSearchReqVo.getPageSize()) == null) {
            pageSize = 5000;
        }
        if (CollectionUtils.isEmpty((Collection)(orgCodeList = mdmCustomerOrgSearchReqVo.getOrgCodeList()))) {
            return Collections.emptyList();
        }
        List subOrgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf((List)orgCodeList);
        if (CollectionUtils.isEmpty((Collection)subOrgCodeList)) {
            return Collections.emptyList();
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        mdmCustomerOrgSearchReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        return this.mdmCustomerMsgMapper.findListByOrgCodeList((Page<MdmCustomerMsgRespVo>)page, mdmCustomerOrgSearchReqVo);
    }

    @Override
    public List<String> findCustomerCodeConditionList(CustomerCodeConditionReqVo customerCodeConditionReqVo) {
        if (CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getChannelList()) && CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getOrgCodeList())) {
            return Lists.newArrayList();
        }
        ArrayList merge = Lists.newArrayList();
        if (!CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getChannelList())) {
            merge.addAll(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getChannel, (Collection)customerCodeConditionReqVo.getChannelList())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list());
        }
        if (!CollectionUtil.listEmpty((List)customerCodeConditionReqVo.getOrgCodeList())) {
            merge.addAll(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmCustomerEntity::getOrgCode, (Collection)customerCodeConditionReqVo.getOrgCodeList())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list());
        }
        return merge.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
    }

    @Override
    public List<MdmCustomerMsgRespVo> findPositionCustomerList(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        mdmPositionCustomerSearchReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        return this.mdmCustomerMsgMapper.findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    public List<MdmCustomerMsgRespVo> queryBasic(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getId()), BaseIdEntity::getId, (Object)mdmCustomerMsgReqVo.getId())).eq(!com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerCode()), MdmCustomerEntity::getCustomerCode, (Object)mdmCustomerMsgReqVo.getCustomerCode())).eq(!com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getUserName()), MdmCustomerEntity::getUserName, (Object)mdmCustomerMsgReqVo.getUserName())).eq(!com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerPrimary()), MdmCustomerEntity::getCustomerPrimary, (Object)mdmCustomerMsgReqVo.getCustomerPrimary())).eq(!com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmCustomerMsgReqVo.getEnableStatus())).eq(!com.biz.crm.util.StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getActApproveStatus()), MdmCustomerEntity::getActApproveStatus, (Object)mdmCustomerMsgReqVo.getActApproveStatus())).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerMsgRespVo.class);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCurrentAndSubPositionCustomer(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        String positionCode = mdmPositionCustomerSearchReqVo.getPositionCode();
        Assert.hasText((String)positionCode, (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmPositionCustomerSearchReqVo.setPositionCodeList(this.mdmPositionService.findAllChildrenPositionCodeList(null, positionCode));
        return this.findPositionCustomerList(mdmPositionCustomerSearchReqVo);
    }

    @Override
    public void sendCustomerChangeMsg(List<String> customerCodeList) {
        log.info("\u901a\u77e5\u5ba2\u6237\u4fe1\u606f\u6216\u5ba2\u6237\u7684\u7ec4\u7ec7\u53d1\u751f\u53d8\u5316,\u5ba2\u6237\u7f16\u7801\u96c6\u5408:{}", customerCodeList);
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setTopic(this.topic);
            rocketMQMessageBody.setTag("CUS_AVAILBLELIST_REFRSH");
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(customerCodeList));
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> listAndContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        String positionCode = mdmCustomerContactPageReqVo.getPositionCode();
        if (!com.biz.crm.util.StringUtils.isEmpty((String)positionCode) || CollectionUtil.listNotEmptyNotSizeZero((List)mdmCustomerContactPageReqVo.getPositionCodeList())) {
            List positionCodeList;
            List list = positionCodeList = mdmCustomerContactPageReqVo.getPositionCodeList() != null ? mdmCustomerContactPageReqVo.getPositionCodeList() : new ArrayList();
            if (com.biz.crm.util.StringUtils.isNotEmpty((String)mdmCustomerContactPageReqVo.getPositionCode())) {
                if (CollectionUtil.listNotEmptyNotSizeZero((List)positionCodeList)) {
                    positionCodeList.retainAll(Collections.singletonList(positionCode));
                } else {
                    positionCodeList.add(positionCode);
                }
            }
            List<String> customerCodeList = this.mdmCustomerSupplyService.findCustomerCodeByPosition(positionCodeList);
            log.info("\u5ba2\u6237\u4fe1\u606f\uff1a\u5173\u8054\u804c\u4f4d\u7684\u5ba2\u6237:{}", customerCodeList);
            if (CollectionUtils.isEmpty(customerCodeList)) {
                return PageResult.builder().data(Collections.emptyList()).count(Long.valueOf(0L)).build();
            }
            mdmCustomerContactPageReqVo.setCustomerCodeList(customerCodeList);
        }
        Page page = PageUtil.buildPage((Integer)mdmCustomerContactPageReqVo.getPageNum(), (Integer)mdmCustomerContactPageReqVo.getPageSize());
        mdmCustomerContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmCustomerContactPageRespVo> mdmCustomerMsgRespVos = this.mdmCustomerMsgMapper.listAndContactPage((Page<MdmCustomerMsgRespVo>)page, mdmCustomerContactPageReqVo);
        mdmCustomerMsgRespVos.stream().forEach(mdm -> mdm.setCustomerCategory("\u7ecf\u9500\u5546"));
        return PageResult.builder().data(mdmCustomerMsgRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmCustomerDockingRespVo> dockingList(MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        Assert.hasText((String)mdmCustomerDockingReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<Object> list = this.mdmCustomerSupplyService.findDockingListByCustomerCode(mdmCustomerDockingReqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list = list.stream().filter(item -> com.biz.crm.util.StringUtils.isNotEmpty((String)item.getUserName())).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> customerContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmCustomerContactPageReqVo.getPageNum(), (Integer)mdmCustomerContactPageReqVo.getPageSize());
        mdmCustomerContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmCustomerContactPageRespVo> mdmCustomerMsgRespVos = this.mdmCustomerMsgMapper.listAndContactPage((Page<MdmCustomerMsgRespVo>)page, mdmCustomerContactPageReqVo);
        return PageResult.builder().data(mdmCustomerMsgRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void updateCoordinate(List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos) {
        if (CollectionUtils.isEmpty(mdmCustomerMsgReqVos)) {
            return;
        }
        for (MdmCustomerMsgReqVo mdmCustomerMsgReqVo : mdmCustomerMsgReqVos) {
            String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
            if (com.biz.crm.util.StringUtils.isEmpty((String)customerCode)) continue;
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)customerCode)).set(MdmCustomerEntity::getLongitude, (Object)mdmCustomerMsgReqVo.getLongitude())).set(MdmCustomerEntity::getLatitude, (Object)mdmCustomerMsgReqVo.getLatitude())).update();
        }
    }

    @Override
    public List<MdmCustomerMsgRespVo> getCustomerListByUserName(String userName) {
        List customerEntityList;
        ArrayList<MdmCustomerMsgRespVo> list = new ArrayList<MdmCustomerMsgRespVo>();
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero((List)(customerEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getUserName, (Object)userName)).eq(MdmCustomerEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).list()))) {
            Map<Object, Object> customerRoleListMap = new HashMap(16);
            List roleCustomerEntityList = ((LambdaQueryChainWrapper)this.mdmRoleCustomerService.lambdaQuery().in(MdmRoleCustomerEntity::getCustomerCode, (Collection)customerEntityList.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList()))).list();
            Map<Object, Object> roleTempMap = new HashMap(16);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)roleCustomerEntityList)) {
                customerRoleListMap = roleCustomerEntityList.stream().collect(Collectors.groupingBy(MdmRoleCustomerEntity::getCustomerCode));
                List roleEntityList = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)roleCustomerEntityList.stream().map(MdmRoleCustomerEntity::getRoleCode).distinct().collect(Collectors.toList()))).select(new SFunction[]{MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName}).list();
                roleTempMap = roleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, v -> v));
            }
            HashMap finalMap = customerRoleListMap;
            HashMap finalRoleMap = roleTempMap;
            list.addAll(customerEntityList.stream().map(item -> {
                MdmCustomerMsgRespVo copy = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)item, MdmCustomerMsgRespVo.class);
                ArrayList roleList = new ArrayList();
                if (finalMap.containsKey(item.getCustomerCode())) {
                    List itemRoleCustomerEntityList = (List)finalMap.get(item.getCustomerCode());
                    for (MdmRoleCustomerEntity roleCustItem : itemRoleCustomerEntityList) {
                        if (!finalRoleMap.containsKey(roleCustItem.getRoleCode())) continue;
                        roleList.add(finalRoleMap.get(roleCustItem.getRoleCode()));
                    }
                }
                copy.setRoleCode(roleList.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.joining(",")));
                copy.setRoleName(roleList.stream().map(MdmRoleEntity::getRoleName).collect(Collectors.joining(",")));
                return copy;
            }).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    public MdmCustomerMsgRespVo getUserCurrentCustomer(String userName) {
        List customerList;
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero((List)(customerList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerEntity::getUserName, (Object)userName)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list()))) {
            List primaryList = customerList.stream().filter(item -> YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getCustomerPrimary())).collect(Collectors.toList());
            if (primaryList.size() == 1) {
                return (MdmCustomerMsgRespVo)CrmBeanUtil.copy(primaryList.get(0), MdmCustomerMsgRespVo.class);
            }
            MdmCustomerEntity mdmCustomerEntity = (MdmCustomerEntity)customerList.get(0);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getUserName, (Object)userName)).set(MdmCustomerEntity::getCustomerPrimary, (Object)YesNoEnum.yesNoEnum.ZERO)).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerEntity::getCustomerCode, (Object)mdmCustomerEntity.getCustomerCode())).set(MdmCustomerEntity::getCustomerPrimary, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
            MdmCustomerMsgRespVo copy = (MdmCustomerMsgRespVo)CrmBeanUtil.copy((Object)mdmCustomerEntity, MdmCustomerMsgRespVo.class);
            copy.setCustomerPrimary(YesNoEnum.yesNoEnum.ONE.getValue());
            return copy;
        }
        return null;
    }

    @Override
    public void frozen(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmCustomerEntity::getLockState, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public void thaw(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmCustomerEntity::getLockState, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    public Integer findPositionRelationCustomerCount(String positionCode) {
        if (com.biz.crm.util.StringUtils.isEmpty((String)positionCode)) {
            return 0;
        }
        List<MdmPositionRespVo> position = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (CollectionUtils.isEmpty(position)) {
            return 0;
        }
        List positionCodeList = position.stream().filter(x -> !com.biz.crm.util.StringUtils.isEmpty((String)x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        return ((LambdaQueryChainWrapper)this.mdmCustomerSupplyService.lambdaQuery().in(MdmCustomerSupplyEntity::getPositionCode, positionCodeList)).count();
    }

    @Override
    public Integer findCurrentPositionRelationCustomerCount(String positionCode) {
        if (com.biz.crm.util.StringUtils.isEmpty((String)positionCode)) {
            return 0;
        }
        return ((LambdaQueryChainWrapper)this.mdmCustomerSupplyService.lambdaQuery().eq(MdmCustomerSupplyEntity::getPositionCode, (Object)positionCode)).count();
    }

    @Override
    public PageResult<MdmCustomerContactPageRespVo> distanceContactPage(MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmCustomerDistanceContactPageReqVo.getPageNum(), (Integer)mdmCustomerDistanceContactPageReqVo.getPageSize());
        List<MdmCustomerContactPageRespVo> list = this.mdmCustomerMsgMapper.distanceContactPage((Page<MdmCustomerContactPageRespVo>)page, mdmCustomerDistanceContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmCustomerCountRespVo fingCustomerAndVisit(MdmCustomerCountReqVo reqVo) {
        Calendar c;
        MdmCustomerCountRespVo mdmCustomerCountRespVo = new MdmCustomerCountRespVo();
        if (com.biz.crm.util.StringUtils.isEmpty((String)reqVo.getUserName())) {
            reqVo.setUserName(UserUtils.getUser().getUsername());
            reqVo.setPosCode(UserUtils.getUser().getPoscode());
        }
        if (com.biz.crm.util.StringUtils.isEmpty((String)reqVo.getTimeType())) {
            reqVo.setTimeType(WorkSignEnum.TimeType.JT.getVal());
        }
        if (WorkSignEnum.TimeType.BZ.getVal().equals(reqVo.getTimeType())) {
            this.getWeekOfDate(reqVo);
        } else if (WorkSignEnum.TimeType.BY.getVal().equals(reqVo.getTimeType())) {
            reqVo.setStartDate(DateUtil.yyyy_MM.format(new Date()) + "-01");
            c = Calendar.getInstance();
            c.setTime(new Date());
            c.set(5, c.getActualMaximum(5));
            Date end = c.getTime();
            reqVo.setEndDate(DateUtil.date_sdf.format(end));
            c.add(2, -1);
            reqVo.setThanStartDate(DateUtil.yyyy_MM.format(c.getTime()) + "-01");
            c.set(5, c.getActualMaximum(5));
            Date thanStart = c.getTime();
            reqVo.setThanEndDate(DateUtil.date_sdf.format(thanStart));
        } else {
            reqVo.setStartDate(DateUtil.date_sdf.format(new Date()));
            reqVo.setEndDate(DateUtil.date_sdf.format(new Date()));
            c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, -1);
            Date d = c.getTime();
            reqVo.setThanStartDate(DateUtil.date_sdf.format(d));
            reqVo.setThanEndDate(DateUtil.date_sdf.format(d));
        }
        BigDecimal customerNumber = this.mdmCustomerMsgMapper.fingCustomerApprovedCount(reqVo.getPosCode(), reqVo.getEndDate(), MdmBpmStatusEnum.PASS.getValue());
        if (null == customerNumber) {
            customerNumber = BigDecimal.ZERO;
        }
        mdmCustomerCountRespVo.setCustomerNumber(customerNumber);
        BigDecimal thanCustNumber = this.mdmCustomerMsgMapper.fingCustomerApprovedCount(reqVo.getPosCode(), reqVo.getThanEndDate(), MdmBpmStatusEnum.PASS.getValue());
        if (null == thanCustNumber) {
            thanCustNumber = BigDecimal.ZERO;
        }
        mdmCustomerCountRespVo.setThanCustNumber(thanCustNumber);
        BigDecimal fluctuateNumber = customerNumber.subtract(thanCustNumber);
        mdmCustomerCountRespVo.setFluctuateNumber(fluctuateNumber);
        Result result = this.sfaVisitDealerDetailFeign.findVisitNumber(reqVo);
        if (result.isSuccess() && null != result.getResult()) {
            MdmCustomerCountRespVo respVo = (MdmCustomerCountRespVo)result.getResult();
            mdmCustomerCountRespVo.setPlanVisitNumber(respVo.getPlanVisitNumber());
            mdmCustomerCountRespVo.setActualVisitNumber(respVo.getActualVisitNumber());
            mdmCustomerCountRespVo.setVisitCompletionRate(respVo.getVisitCompletionRate());
            mdmCustomerCountRespVo.setPlaceOrderNumber(respVo.getPlaceOrderNumber());
            mdmCustomerCountRespVo.setSalesReachRate(respVo.getSalesReachRate());
            mdmCustomerCountRespVo.setVisitCustNumber(respVo.getVisitCustNumber());
            BigDecimal visitCoverRate = BigDecimal.ZERO;
            if (!BigDecimal.ZERO.equals(customerNumber)) {
                visitCoverRate = mdmCustomerCountRespVo.getVisitCustNumber().compareTo(BigDecimal.ZERO) > 0 ? mdmCustomerCountRespVo.getVisitCustNumber().divide(customerNumber).multiply(new BigDecimal("100").setScale(2)) : BigDecimal.ZERO;
            }
            mdmCustomerCountRespVo.setVisitCoverRate(visitCoverRate);
            mdmCustomerCountRespVo.setVisitTotalNumber(respVo.getVisitTotalNumber());
        }
        return mdmCustomerCountRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submit(MdmCustomerMsgReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        MdmCustomerEntity entity = (MdmCustomerEntity)this.getById((Serializable)((Object)reqVo.getId()));
        if (!ApprovalType.BPM.getValue().equals(entity.getApprovalType())) {
            throw new BusinessException("\u8be5\u6761\u6570\u636e\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b\u5ba1\u6279");
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b");
        }
        if (MdmBpmStatusEnum.APPROVAL.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b");
        }
        entity.setProcessCode(reqVo.getWorkFlowKey());
        entity.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        this.updateById(entity);
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("MdmCustomerCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getCustomerCode());
        startProcessReqVo.setFileList(reqVo.getActivityFileList());
        Result result = this.taActBaseFeign.startProcess(startProcessReqVo);
        if (!result.isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void callback(ActivitiCallBackVo activitiCallBackVo) {
        MdmCustomerEntity entity = (MdmCustomerEntity)this.getById((Serializable)((Object)activitiCallBackVo.getFormNo()));
        boolean sendMq = false;
        if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            sendMq = true;
        }
        if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        }
        if (Indicator.CON_BPM_REJECT.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
        }
        this.updateById(entity);
        if (sendMq) {
            this.sendCustomerChangeMsg(Collections.singletonList(entity.getCustomerCode()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusApprovalSubmit(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        list.forEach(x -> {
            Assert.isTrue((boolean)ApprovalType.STATUS.getValue().equals(x.getApprovalType()), (String)"\u8be5\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((!MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((!MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            x.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusApprovalReject(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        list.forEach(x -> {
            Assert.isTrue((boolean)ApprovalType.STATUS.getValue().equals(x.getApprovalType()), (String)"\u8be5\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((boolean)MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u624d\u80fd\u9a73\u56de");
            x.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusApprovalAgree(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        list.forEach(x -> {
            Assert.isTrue((boolean)ApprovalType.STATUS.getValue().equals(x.getApprovalType()), (String)"\u8be5\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((boolean)MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u624d\u80fd\u901a\u8fc7");
            x.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        });
        this.updateBatchById(list);
    }

    public void getWeekOfDate(MdmCustomerCountReqVo reqVo) {
        String[] weeks = new String[]{"7", "1", "2", "3", "4", "5", "6"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int week_index = cal.get(7) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        String week = weeks[week_index];
        int days = 0;
        if ("1".equals(week)) {
            days = 0;
        } else if ("2".equals(week)) {
            days = -1;
        } else if ("3".equals(week)) {
            days = -2;
        } else if ("4".equals(week)) {
            days = -3;
        } else if ("5".equals(week)) {
            days = -4;
        } else if ("6".equals(week)) {
            days = -5;
        } else if ("7".equals(week)) {
            days = -6;
        }
        cal.add(5, days);
        Date start = cal.getTime();
        reqVo.setStartDate(DateUtil.date_sdf.format(start));
        cal.add(5, 6);
        Date end = cal.getTime();
        reqVo.setEndDate(DateUtil.date_sdf.format(end));
        cal.add(5, -7);
        Date thanEnd = cal.getTime();
        reqVo.setThanEndDate(DateUtil.date_sdf.format(thanEnd));
        cal.add(5, -6);
        Date thanStart = cal.getTime();
        reqVo.setThanStartDate(DateUtil.date_sdf.format(thanStart));
    }
}

