/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.message.ShortMessage;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.webservice.message.ShortMessageFeign;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class LoginHelpUtil {
    private static final Logger log = LoggerFactory.getLogger(LoginHelpUtil.class);
    private static RedisService redisService;
    private static ShortMessageFeign shortMessageFeign;
    private static MdmDictDataService mdmDictDataService;

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    @Autowired
    public void setShortMessageFeign(ShortMessageFeign shortMessageFeign) {
        LoginHelpUtil.shortMessageFeign = shortMessageFeign;
    }

    @Autowired
    public void setMdmDictDataService(MdmDictDataService mdmDictDataService) {
        LoginHelpUtil.mdmDictDataService = mdmDictDataService;
    }

    public static void checkLock(String account, AccountType accountType) {
        Assert.hasText((String)account, (String)"\u7a7a\u53c2\u6570");
        long userLockMinutes = LoginHelpUtil.getLockMinutes(account, accountType);
        if (userLockMinutes != 0L) {
            if (AccountType.USER_NAME == accountType) {
                throw new BusinessException("\u7528\u6237\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + userLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
            }
            if (AccountType.PHONE == accountType) {
                throw new BusinessException("\u624b\u673a\u53f7\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + userLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
            }
            if (AccountType.EMAIL == accountType) {
                throw new BusinessException("\u90ae\u7bb1\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + userLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
            }
        }
    }

    public static void addError(String userName, String phone, String email) {
        Assert.hasText((String)userName, (String)"\u7f3a\u5931\u767b\u5f55\u8d26\u53f7");
        long lastTimes = LoginHelpUtil.addErrorAndGetTimes(userName, phone, email);
        if (lastTimes != 0L) {
            throw new BusinessException("\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + lastTimes + "\u6b21\u5c1d\u8bd5\u673a\u4f1a");
        }
        throw new BusinessException("\u5bc6\u7801\u9519\u8bef\uff0c\u8d26\u53f7\u88ab\u9501\u5b9a\uff0c\u8bf7" + LoginHelpUtil.getMaxLockMinutes() + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
    }

    public static void checkUserLogin(String enableStatus, String startTime, String endTime) {
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatus), (String)"\u7528\u6237\u672a\u542f\u7528");
        String now = DateUtil.dateNowHms();
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            Assert.isTrue((now.compareTo(startTime) >= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u751f\u6548");
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            Assert.isTrue((now.compareTo(endTime) <= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u5df2\u5931\u6548");
        }
    }

    public static void checkUserType(String userType, String fromType) {
        if (LoginFromTypeEnum.CONSOLE.getValue().equals(fromType)) {
            Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(userType), (String)"\u53ea\u6709\u4f01\u4e1a\u7528\u6237\u624d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.APP_SFA.getValue().equals(fromType)) {
            Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(userType), (String)"\u53ea\u6709\u4f01\u4e1a\u7528\u6237\u624d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.APPLET_SFA.getValue().equals(fromType)) {
            Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(userType), (String)"\u53ea\u6709\u4f01\u4e1a\u7528\u6237\u624d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.WEB_DMS.getValue().equals(fromType)) {
            Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(userType), (String)"\u53ea\u6709\u5ba2\u6237\u7528\u6237\u624d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.APPLET_DMS.getValue().equals(fromType)) {
            Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(userType), (String)"\u53ea\u6709\u5ba2\u6237\u7528\u6237\u624d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.APP_DMS.getValue().equals(fromType)) {
            Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(userType), (String)"\u53ea\u6709\u5ba2\u6237\u7528\u6237\u624d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        }
    }

    public static long getLockMinutes(String account, AccountType accountType) {
        if (AccountType.USER_NAME == accountType) {
            return LoginHelpUtil.getLockMinutes("LOGIN_LOCK_USER_0319:", account);
        }
        if (AccountType.PHONE == accountType) {
            return LoginHelpUtil.getLockMinutes("LOGIN_LOCK_PHONE_0319:", account);
        }
        if (AccountType.EMAIL == accountType) {
            return LoginHelpUtil.getLockMinutes("LOGIN_LOCK_EMAIL_0319:", account);
        }
        return 0L;
    }

    public static void unlock(String userName, String phone, String email) {
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            redisService.hdel("LOGIN_LOCK_USER_0319:", new Object[]{userName});
            redisService.hdel("LOGIN_LOCK_USER_ERROR_TIMES_0319:", new Object[]{userName});
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            redisService.hdel("LOGIN_LOCK_PHONE_0319:", new Object[]{phone});
            redisService.hdel("LOGIN_LOCK_PHONE_ERROR_TIMES_0319:", new Object[]{phone});
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            redisService.hdel("LOGIN_LOCK_EMAIL_0319:", new Object[]{email});
            redisService.hdel("LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:", new Object[]{email});
        }
    }

    public static long getMaxLockMinutes() {
        long maxLockSeconds = LoginHelpUtil.getMaxLockSeconds();
        BigDecimal divide = new BigDecimal(maxLockSeconds).divide(new BigDecimal(60), 0, 0);
        return divide.longValue();
    }

    public static String saveLoginVerificationCodeRelUser(String fromType, String userName, String account, AccountType accountType, VerificationCodeType verificationCodeType) {
        String verification = LoginHelpUtil.generateVerificationCode();
        if (AccountType.PHONE == accountType) {
            if (VerificationCodeType.LOGIN == verificationCodeType) {
                redisService.hset("LOGIN_PHONE_VERIFICATION_0319:" + fromType + ":" + account, verification, (Object)userName, 300L);
            }
            if (VerificationCodeType.LOGIN_AND_RESET == verificationCodeType) {
                redisService.hset("LOGIN_PHONE_RESET_VERIFICATION_0319:" + fromType + ":" + account, verification, (Object)userName, 300L);
            }
        }
        if (AccountType.EMAIL == accountType) {
            if (VerificationCodeType.LOGIN == verificationCodeType) {
                redisService.hset("LOGIN_EMAIL_VERIFICATION_0319:" + fromType + ":" + account, verification, (Object)userName, 3600L);
            }
            if (VerificationCodeType.LOGIN_AND_RESET == verificationCodeType) {
                redisService.hset("LOGIN_EMAIL_RESET_VERIFICATION_0319:" + fromType + ":" + account, verification, (Object)userName, 3600L);
            }
        }
        return verification;
    }

    public static void sendVerificationCode(String fromType, String verificationCode, String account, AccountType accountType, VerificationCodeType verificationCodeType) {
        if (AccountType.PHONE == accountType) {
            String template;
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setPhoneNumbers(account);
            shortMessage.setTemplateParam("{\"code\":\"" + verificationCode + "\"}");
            if (VerificationCodeType.LOGIN == verificationCodeType) {
                template = mdmDictDataService.getDictDataMap("message_template").get("system_login");
                Assert.hasText((String)template, (String)"\u672a\u914d\u7f6e\u624b\u673a\u9a8c\u8bc1\u7801\u767b\u5f55\u77ed\u4fe1\u6a21\u677f");
                shortMessage.setTemplateCode(template);
            }
            if (VerificationCodeType.LOGIN_AND_RESET == verificationCodeType) {
                template = mdmDictDataService.getDictDataMap("message_template").get("system_login_and_reset");
                Assert.hasText((String)template, (String)"\u672a\u914d\u7f6e\u624b\u673a\u9a8c\u8bc1\u7801\u91cd\u7f6e\u5bc6\u7801\u77ed\u4fe1\u6a21\u677f");
                shortMessage.setTemplateCode(template);
            }
            shortMessageFeign.sendMessage(shortMessage);
        }
        if (AccountType.EMAIL == accountType) {
            if (VerificationCodeType.LOGIN == verificationCodeType) {
                // empty if block
            }
            if (VerificationCodeType.LOGIN_AND_RESET == verificationCodeType) {
                // empty if block
            }
        }
        log.debug("\u53d1\u9001\u9a8c\u8bc1\u7801\u6210\u529f\uff1a\u767b\u5f55\u7cfb\u7edf\uff1a{}\uff0c\u90ae\u7bb1/\u624b\u673a\u53f7\uff1a{}\uff0c\u9a8c\u8bc1\u7801\uff1a{}", new Object[]{LoginFromTypeEnum.getDesc((String)fromType), account, verificationCode});
    }

    public static Set<String> checkAndGetLockUserName(Set<String> userNameSet) {
        Map hmget;
        HashSet<String> lockUserNameSet = new HashSet<String>(16);
        if (!userNameSet.isEmpty() && (hmget = redisService.hmget("LOGIN_LOCK_USER_0319:")) != null) {
            lockUserNameSet.addAll(hmget.keySet().stream().map(x -> (String)x).filter(userNameSet::contains).collect(Collectors.toSet()));
        }
        return lockUserNameSet;
    }

    public static String checkVerificationCode(String fromType, String verificationCode, String account, AccountType accountType, VerificationCodeType verificationCodeType) {
        Object hget;
        String userName = null;
        if (AccountType.PHONE == accountType) {
            if (VerificationCodeType.LOGIN == verificationCodeType && (hget = redisService.hget("LOGIN_PHONE_VERIFICATION_0319:" + fromType + ":" + account, verificationCode)) != null) {
                redisService.del(new String[]{"LOGIN_PHONE_VERIFICATION_0319:" + fromType + ":" + account});
                userName = (String)hget;
            }
            if (VerificationCodeType.LOGIN_AND_RESET == verificationCodeType && (hget = redisService.hget("LOGIN_PHONE_RESET_VERIFICATION_0319:" + fromType + ":" + account, verificationCode)) != null) {
                redisService.del(new String[]{"LOGIN_PHONE_RESET_VERIFICATION_0319:" + fromType + ":" + account});
                userName = (String)hget;
            }
        }
        if (AccountType.EMAIL == accountType) {
            if (VerificationCodeType.LOGIN == verificationCodeType && (hget = redisService.hget("LOGIN_EMAIL_VERIFICATION_0319:" + fromType + ":" + account, verificationCode)) != null) {
                redisService.del(new String[]{"LOGIN_EMAIL_VERIFICATION_0319:" + fromType + ":" + account});
                userName = (String)hget;
            }
            if (VerificationCodeType.LOGIN_AND_RESET == verificationCodeType && (hget = redisService.hget("LOGIN_EMAIL_RESET_VERIFICATION_0319:" + fromType + ":" + account, verificationCode)) != null) {
                redisService.del(new String[]{"LOGIN_EMAIL_RESET_VERIFICATION_0319:" + fromType + ":" + account});
                userName = (String)hget;
            }
        }
        Assert.hasText(userName, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        return userName;
    }

    private static long addErrorAndGetTimes(String userName, String phone, String email) {
        long maxErrorTimes;
        Assert.hasText((String)userName, (String)"\u7f3a\u5931\u767b\u5f55\u8d26\u53f7");
        long lastTimes = maxErrorTimes = LoginHelpUtil.getMaxErrorTimes();
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            Object lockObj = redisService.hget("LOGIN_LOCK_USER_0319:", userName);
            if (lockObj != null) {
                lastTimes = 0L;
            } else {
                Object errorTimesObj = redisService.hget("LOGIN_LOCK_USER_ERROR_TIMES_0319:", userName);
                if (maxErrorTimes == 1L) {
                    LoginHelpUtil.lock(userName, phone, email);
                    lastTimes = 0L;
                } else {
                    int thisAfterAddTimes = 1;
                    if (errorTimesObj != null) {
                        thisAfterAddTimes += ((Integer)errorTimesObj).intValue();
                    }
                    if ((long)thisAfterAddTimes >= maxErrorTimes) {
                        LoginHelpUtil.lock(userName, phone, email);
                        lastTimes = 0L;
                    } else {
                        LoginHelpUtil.setErrorTimes(userName, phone, email, thisAfterAddTimes);
                        lastTimes = maxErrorTimes - (long)thisAfterAddTimes;
                    }
                }
            }
        }
        return lastTimes;
    }

    private static void lock(String userName, String phone, String email) {
        long lockSeconds = LoginHelpUtil.getMaxLockSeconds();
        long unlockDateTime = System.currentTimeMillis() + lockSeconds * 1000L;
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            redisService.hset("LOGIN_LOCK_USER_0319:", userName, (Object)unlockDateTime, lockSeconds);
            redisService.hdel("LOGIN_LOCK_USER_ERROR_TIMES_0319:", new Object[]{userName});
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            redisService.hset("LOGIN_LOCK_PHONE_0319:", phone, (Object)unlockDateTime, lockSeconds);
            redisService.hdel("LOGIN_LOCK_PHONE_ERROR_TIMES_0319:", new Object[]{phone});
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            redisService.hset("LOGIN_LOCK_EMAIL_0319:", email, (Object)unlockDateTime, lockSeconds);
            redisService.hdel("LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:", new Object[]{email});
        }
    }

    private static void setErrorTimes(String userName, String phone, String email, int times) {
        long errorResetSeconds = LoginHelpUtil.getErrorResetSeconds();
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            redisService.hset("LOGIN_LOCK_USER_ERROR_TIMES_0319:", userName, (Object)times, errorResetSeconds);
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            redisService.hset("LOGIN_LOCK_PHONE_ERROR_TIMES_0319:", phone, (Object)times, errorResetSeconds);
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            redisService.hset("LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:", email, (Object)times, errorResetSeconds);
        }
    }

    private static long getLockMinutes(String lockKey, String name) {
        Long unlockDateTimeLong;
        long l;
        Object obj;
        if (StringUtils.isNotEmpty((CharSequence)name) && (obj = redisService.hget(lockKey, name)) != null && (l = (unlockDateTimeLong = (Long)obj) - System.currentTimeMillis()) > 0L) {
            BigDecimal divide = new BigDecimal(l).divide(new BigDecimal(60000L), 0, 0);
            return divide.longValue();
        }
        return 0L;
    }

    private static long getErrorResetSeconds() {
        try {
            String parameterValue = ParamUtil.getParameterValueNoException((String)"login_password_error_reset_minutes");
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                return new BigDecimal(parameterValue).multiply(new BigDecimal("60")).setScale(0, RoundingMode.HALF_UP).longValue();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bc6\u7801\u9519\u8bef\u91cd\u7f6e\u65f6\u95f4\u5931\u8d25");
        }
        return 64800L;
    }

    private static long getMaxErrorTimes() {
        try {
            String parameterValue = ParamUtil.getParameterValueNoException((String)"login_error_frequency");
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                return Long.valueOf(parameterValue);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u5bc6\u7801\u6700\u5927\u8f93\u5165\u9519\u8bef\u6b21\u6570\u5931\u8d25");
        }
        return 5L;
    }

    private static long getMaxLockSeconds() {
        try {
            String parameterValue = ParamUtil.getParameterValueNoException((String)"login_lock_time");
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                return new BigDecimal(parameterValue).multiply(new BigDecimal("60")).setScale(0, RoundingMode.HALF_UP).longValue();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u6700\u5927\u9501\u5b9a\u65f6\u957f\u5931\u8d25");
        }
        return 900L;
    }

    private static String generateVerificationCode() {
        int length = 6;
        double random = Math.random();
        return String.format("%0" + length + "d", new BigDecimal(random).multiply(new BigDecimal(Math.pow(10.0, length))).setScale(0, RoundingMode.HALF_UP).longValue());
    }

    public static enum VerificationCodeType {
        LOGIN,
        LOGIN_AND_RESET;

    }

    public static enum AccountType {
        USER_NAME,
        PHONE,
        EMAIL;

    }
}

