/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.coderule.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.coderule.mapper.MdmCodeRuleMapper;
import com.biz.crm.coderule.model.MdmCodeRuleEntity;
import com.biz.crm.coderule.service.MdmCodeRuleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.coderule.req.MdmCodeRuleReqVo;
import com.biz.crm.nebular.mdm.coderule.resp.MdmCodeRuleRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmCodeRuleServiceExpandImpl"})
public class MdmCodeRuleServiceImpl
extends ServiceImpl<MdmCodeRuleMapper, MdmCodeRuleEntity>
implements MdmCodeRuleService {
    private static final Logger log = LoggerFactory.getLogger(MdmCodeRuleServiceImpl.class);
    @Resource
    private MdmCodeRuleMapper mdmCodeRuleMapper;

    @Override
    public PageResult<MdmCodeRuleRespVo> findList(MdmCodeRuleReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmCodeRuleRespVo> list = this.mdmCodeRuleMapper.findList((Page<MdmCodeRuleRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmCodeRuleRespVo query(MdmCodeRuleReqVo reqVo) {
        MdmCodeRuleEntity one;
        MdmCodeRuleRespVo respVo = new MdmCodeRuleRespVo();
        if ((StringUtils.isNotEmpty((String)reqVo.getId()) || StringUtils.isNotEmpty((String)reqVo.getRuleCode())) && (one = (MdmCodeRuleEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(StringUtils.isNotEmpty((String)reqVo.getRuleCode()), MdmCodeRuleEntity::getRuleCode, (Object)reqVo.getRuleCode())).one()) != null) {
            respVo = (MdmCodeRuleRespVo)CrmBeanUtil.copy((Object)one, MdmCodeRuleRespVo.class);
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmCodeRuleReqVo reqVo) {
        UserRedis user;
        Assert.notNull((Object)reqVo, (String)"\u7a7a\u53c2\u6570");
        reqVo.setId(null);
        this.verify(reqVo);
        MdmCodeRuleEntity one = (MdmCodeRuleEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCodeRuleEntity::getRuleCode, (Object)reqVo.getRuleCode())).one();
        Assert.isTrue((one == null ? 1 : 0) != 0, (String)"\u7f16\u7801\u89c4\u5219key\u5df2\u5b58\u5728");
        MdmCodeRuleEntity entity = (MdmCodeRuleEntity)CrmBeanUtil.copy((Object)reqVo, MdmCodeRuleEntity.class);
        if (entity.getCurrentValue() == null) {
            entity.setCurrentValue(Integer.valueOf(entity.getInitialValue() - 1));
        }
        entity.setCreateName((user = UserUtils.getUser()) != null ? user.getRealname() : "");
        entity.setCreateDate(DateUtil.dateNow2Str());
        entity.setCreateDateSecond(DateUtil.dateNowStrHms());
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmCodeRuleReqVo reqVo) {
        Assert.notNull((Object)reqVo, (String)"\u7a7a\u53c2\u6570");
        Assert.hasText((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.verify(reqVo);
        MdmCodeRuleEntity entity = (MdmCodeRuleEntity)this.getById((Serializable)((Object)reqVo.getId()));
        Assert.isTrue((entity != null ? 1 : 0) != 0, (String)"\u65e0\u6548\u7684id");
        if (reqVo.getCurrentValue() != null) {
            Assert.isTrue((reqVo.getCurrentValue() >= entity.getCurrentValue() ? 1 : 0) != 0, (String)"\u5f53\u524d\u503c\u4e0d\u80fd\u6539\u5c0f");
        }
        Assert.isTrue((boolean)entity.getRuleCode().equals(reqVo.getRuleCode()), (String)"\u7f16\u7801\u89c4\u5219key\u4e0d\u80fd\u4fee\u6539");
        entity.setPrefix(reqVo.getPrefix());
        entity.setDateFormat(reqVo.getDateFormat());
        entity.setCodeLength(reqVo.getCodeLength());
        entity.setInitialValue(reqVo.getInitialValue());
        entity.setCurrentValue(reqVo.getCurrentValue() != null ? reqVo.getCurrentValue() : entity.getCurrentValue());
        entity.setRuleDescription(reqVo.getRuleDescription());
        entity.setRuleModule(reqVo.getRuleModule());
        UserRedis user = UserUtils.getUser();
        entity.setUpdateName(user != null ? user.getRealname() : "");
        entity.setUpdateDate(DateUtil.dateNow2Str());
        entity.setUpdateDateSecond(DateUtil.dateNowStrHms());
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        org.springframework.util.Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reset(MdmCodeRuleReqVo reqVo) {
        Assert.notNull((Object)reqVo, (String)"\u7a7a\u53c2\u6570");
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"\u7f3a\u5931\u53c2\u6570");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u8be5\u64cd\u4f5c\u5f71\u54cd\u8f83\u5927\uff0c\u6682\u4e0d\u652f\u6301\u6279\u91cf\u91cd\u7f6e");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmCodeRuleEntity one = (MdmCodeRuleEntity)this.getById((Serializable)((Object)id));
            Assert.notNull((Object)one, (String)"\u65e0\u6548\u7684id");
            one.setCurrentValue(Integer.valueOf(one.getInitialValue() - 1));
            this.updateById(one);
        });
    }

    private void verify(MdmCodeRuleReqVo reqVo) {
        Assert.hasText((String)reqVo.getRuleCode(), (String)"\u7f16\u7801\u89c4\u5219key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqVo.getCodeLength(), (String)"\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((reqVo.getCodeLength() <= 32 ? 1 : 0) != 0, (String)"\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
        Assert.notNull((Object)reqVo.getInitialValue(), (String)"\u8d77\u59cb\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((reqVo.getInitialValue() > 0 ? 1 : 0) != 0, (String)"\u8d77\u59cb\u503c\u5fc5\u987b\u5927\u4e8e0");
        int lengthWithoutNumber = (StringUtils.isEmpty((String)reqVo.getPrefix()) ? 0 : reqVo.getPrefix().length()) + (StringUtils.isEmpty((String)reqVo.getDateFormat()) ? 0 : reqVo.getDateFormat().length());
        Assert.isTrue((reqVo.getCodeLength() > lengthWithoutNumber ? 1 : 0) != 0, (String)"\u7f16\u7801\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u524d\u7f00\u548c\u65f6\u95f4\u6233\u957f\u5ea6\u4e4b\u548c");
        if (StringUtils.isNotEmpty((String)reqVo.getDateFormat())) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(reqVo.getDateFormat());
            }
            catch (Exception e) {
                throw new BusinessException("\u65f6\u95f4\u6233\u683c\u5f0f" + reqVo.getDateFormat() + "\u4e0d\u5408\u6cd5");
            }
        }
    }
}

