/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.org.req.MdmOrgPageSelectReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSelectReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRegionRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgReloadRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.org.mapper.MdmOrgMapper;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgRegionService;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmOrgServiceExpandImpl"})
public class MdmOrgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmOrgMapper, MdmOrgEntity>
implements MdmOrgService {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgServiceImpl.class);
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmOrgRegionService mdmOrgRegionService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Resource
    private MdmTerminalROrgService mdmTerminalROrgService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<MdmOrgRespVo> findList(MdmOrgReqVo reqVo) {
        MdmOrgEntity one;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (!StringUtils.isEmpty((String)reqVo.getCode()) && (one = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getCode())).one()) != null) {
            reqVo.setRuleCode(one.getRuleCode());
        }
        List<MdmOrgRespVo> list = this.mdmOrgMapper.findList((Page<MdmOrgRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmOrgRespVo> pageSelectList(MdmOrgPageSelectReqVo reqVo) {
        List listExcludeAnySelf;
        List listExcludeSelf;
        List listIncludeSelf;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAllUnderOrgCodeListIncludeSelf()) && CollectionUtil.listNotEmptyNotSizeZero((List)(listIncludeSelf = OrgUtil.getChildrenOrgCodeListIncludeSelf((List)reqVo.getAllUnderOrgCodeListIncludeSelf())))) {
            reqVo.setAllUnderOrgCodeListIncludeSelf(listIncludeSelf);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAllUnderOrgCodeListExcludeSelf()) && CollectionUtil.listNotEmptyNotSizeZero((List)(listExcludeSelf = OrgUtil.getChildrenOrgCodeListExcludeSelf((List)reqVo.getAllUnderOrgCodeListExcludeSelf())))) {
            reqVo.setAllUnderOrgCodeListExcludeSelf(listExcludeSelf);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getAllUnderOrgCodeListExcludeAnySelf()) && CollectionUtil.listNotEmptyNotSizeZero((List)(listExcludeAnySelf = OrgUtil.getChildrenOrgCodeListExcludeAnySelf((List)reqVo.getAllUnderOrgCodeListExcludeAnySelf())))) {
            reqVo.setAllUnderOrgCodeListExcludeAnySelf(listExcludeAnySelf);
        }
        List<MdmOrgRespVo> list = this.mdmOrgMapper.pageSelectList((Page<MdmOrgRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmOrgRespVo detail(String id, String orgCode) {
        MdmOrgEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)orgCode)) && (one = (MdmOrgEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one()) != null) {
            MdmOrgEntity parent;
            MdmOrgRespVo org = (MdmOrgRespVo)CrmBeanUtil.copy((Object)one, MdmOrgRespVo.class);
            if (StringUtils.isNotEmpty((String)org.getParentCode()) && (parent = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)org.getParentCode())).select(new SFunction[]{MdmOrgEntity::getOrgName}).one()) != null) {
                org.setParentName(parent.getOrgName());
            }
            return org;
        }
        return null;
    }

    @Override
    public MdmOrgRespVo queryByOrgCode(String orgCode) {
        MdmOrgEntity one;
        if (StringUtils.isNotEmpty((String)orgCode) && (one = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)orgCode)).one()) != null) {
            return (MdmOrgRespVo)CrmBeanUtil.copy((Object)one, MdmOrgRespVo.class);
        }
        return null;
    }

    @Override
    public String getOrgRuleCode(String orgCode) {
        MdmOrgEntity one;
        if (StringUtils.isNotEmpty((String)orgCode) && (one = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            return one.getRuleCode();
        }
        return null;
    }

    @Override
    public List<MdmOrgRespVo> detailBatch(List<String> ids, List<String> orgCodeList) {
        List entityList;
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).or()).in(CollectionUtil.listNotEmptyNotSizeZero(orgCodeList), MdmOrgEntity::getOrgCode, orgCodeList)).list()))) {
            List parentList;
            List list = CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class);
            List parentCodeList = entityList.stream().map(MdmOrgEntity::getParentCode).distinct().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(parentCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, parentCodeList)).select(new SFunction[]{MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName}).list()))) {
                Map<String, String> collect = parentList.stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName));
                list.forEach(item -> {
                    if (StringUtils.isNotEmpty((String)item.getParentCode())) {
                        item.setParentName((String)collect.get(item.getParentCode()));
                    }
                });
            }
            return list;
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    @Override
    public List<MdmOrgRedisVo> findRedisListByOrgCodeList(List<String> orgCodeList) {
        List<MdmOrgRespVo> list = this.detailBatch(null, orgCodeList);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return CrmBeanUtil.copyList(list, MdmOrgRedisVo.class);
        }
        return new ArrayList<MdmOrgRedisVo>();
    }

    @Override
    public List<MdmOrgParentChildrenRedisVo> findRedisOrgParentListByCodeList(List<String> orgCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{MdmOrgEntity::getOrgCode, CrmTreeTenEntity::getRuleCode}).list()))) {
            Set parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()));
            List parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)parentRuleCodes)).list();
            Set collect = parentList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode())).map(MdmOrgEntity::getParentCode).collect(Collectors.toSet());
            HashMap<String, String> parentOrgCodeNameMap = new HashMap<String, String>(16);
            if (!collect.isEmpty()) {
                parentOrgCodeNameMap.putAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, collect)).select(new SFunction[]{MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName}).list().stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName)));
            }
            List parentRedisVoList = parentList.stream().map(item -> {
                MdmOrgRedisVo copy = (MdmOrgRedisVo)CrmBeanUtil.copy((Object)item, MdmOrgRedisVo.class);
                if (StringUtils.isNotEmpty((String)copy.getParentCode()) && parentOrgCodeNameMap.containsKey(copy.getParentCode())) {
                    copy.setParentName((String)parentOrgCodeNameMap.get(copy.getParentCode()));
                }
                return copy;
            }).collect(Collectors.toList());
            ArrayList<MdmOrgParentChildrenRedisVo> result = new ArrayList<MdmOrgParentChildrenRedisVo>();
            for (MdmOrgEntity item2 : parentList) {
                MdmOrgParentChildrenRedisVo redisVo = new MdmOrgParentChildrenRedisVo();
                redisVo.setOrgCode(item2.getOrgCode());
                redisVo.setList(parentRedisVoList.stream().filter(x -> item2.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
                result.add(redisVo);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MdmOrgParentChildrenRedisVo> findRedisOrgChildrenListByCodeList(List<String> orgCodeList) {
        List<String> likeRightRuleCodeList;
        List<MdmOrgRespVo> childrenList;
        List orgList;
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{MdmOrgEntity::getOrgCode, CrmTreeTenEntity::getRuleCode}).list())) && CollectionUtil.listNotEmptyNotSizeZero(childrenList = this.mdmOrgMapper.findOrgChildrenByRuleCodeList(likeRightRuleCodeList = orgList.stream().map(item -> item.getRuleCode() + "%").collect(Collectors.toList())))) {
            List redisList = CrmBeanUtil.copyList(childrenList, MdmOrgRedisVo.class);
            ArrayList<MdmOrgParentChildrenRedisVo> resultList = new ArrayList<MdmOrgParentChildrenRedisVo>();
            for (MdmOrgEntity item2 : orgList) {
                MdmOrgParentChildrenRedisVo redisVo = new MdmOrgParentChildrenRedisVo();
                redisVo.setOrgCode(item2.getOrgCode());
                redisVo.setList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item2.getRuleCode())).collect(Collectors.toList()));
                resultList.add(redisVo);
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MdmOrgReloadRedisVo> findRedisReloadList() {
        List all = this.lambdaQuery().list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)all)) {
            Map<String, String> orgCodeNameMap = all.stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName));
            List redisList = all.stream().map(item -> {
                MdmOrgRedisVo copy = (MdmOrgRedisVo)CrmBeanUtil.copy((Object)item, MdmOrgRedisVo.class);
                if (StringUtils.isNotEmpty((String)copy.getParentCode())) {
                    copy.setParentName((String)orgCodeNameMap.get(copy.getParentCode()));
                }
                return copy;
            }).collect(Collectors.toList());
            return redisList.stream().map(item -> {
                MdmOrgReloadRedisVo redisVo = new MdmOrgReloadRedisVo();
                redisVo.setOrgCode(item.getOrgCode());
                redisVo.setSelf(item);
                redisVo.setParentList(redisList.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
                redisVo.setChildrenList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item.getRuleCode())).collect(Collectors.toList()));
                return redisVo;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmOrgReqVo reqVo) {
        reqVo.setId(null);
        Assert.hasText((String)reqVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmOrgEntity entity = (MdmOrgEntity)CrmBeanUtil.copy((Object)reqVo, MdmOrgEntity.class);
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)reqVo.getParentCode())) {
            MdmOrgEntity parent = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getParentCode())).one();
            Assert.notNull((Object)parent, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u88ab\u7981\u7528");
            levelNum = parent.getLevelNum() + 1;
        }
        entity.setRuleCode(this.generateRuleCodeByParentCode(entity.getParentCode()));
        entity.setLevelNum(Integer.valueOf(levelNum));
        if (StringUtils.isEmpty((String)entity.getOrgCode())) {
            entity.setOrgCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ORG_CODE.getCode()));
        } else {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getOrgCode())).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u7ec4\u7ec7\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        this.save(entity);
        OrgUtil.deleteAllCache();
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            this.crmLogSendUtil.sendForAdd((String)menuObject, entity.getId(), entity.getOrgName(), CrmBeanUtil.copy((Object)reqVo, MdmOrgRespVo.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmOrgReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmOrgEntity entity = (MdmOrgEntity)this.getById((Serializable)((Object)id));
        MdmOrgEntity old = new MdmOrgEntity();
        CrmBeanUtil.copyProperties((Object)entity, (Object)old);
        Assert.notNull((Object)entity, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)entity.getOrgCode().equals(reqVo.getOrgCode()), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        String parentCode = reqVo.getParentCode();
        boolean reloadRuleCode = false;
        int levelNum = 1;
        String enableStatusChangeTo = "";
        if (StringUtils.isNotEmpty((String)parentCode)) {
            Assert.isTrue((!entity.getOrgCode().equals(parentCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u5f53\u524d\u7ec4\u7ec7");
            MdmOrgEntity parent = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)parentCode)).one();
            Assert.notNull((Object)parent, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            Assert.isTrue((!parent.getRuleCode().startsWith(entity.getRuleCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u7ec4\u7ec7");
            levelNum = parent.getLevelNum() + 1;
        }
        if (!(entity.getParentCode() == null ? "" : entity.getParentCode()).equals(reqVo.getParentCode() == null ? "" : reqVo.getParentCode())) {
            reloadRuleCode = true;
        }
        if (!entity.getEnableStatus().equals(reqVo.getEnableStatus())) {
            enableStatusChangeTo = reqVo.getEnableStatus();
        }
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)entity);
        this.updateById(entity);
        if (reloadRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(reqVo.getParentCode());
            this.updateCurAndChildren(entity.getOrgCode(), ruleCode, levelNum);
        }
        if (StringUtils.isNotEmpty((String)enableStatusChangeTo)) {
            if (CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatusChangeTo)) {
                this.enableBatch(new MdmOrgReqVo().setIds(Collections.singletonList(entity.getId())));
            } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(enableStatusChangeTo)) {
                this.disableBatch(new MdmOrgReqVo().setIds(Collections.singletonList(entity.getId())));
            } else {
                throw new BusinessException("\u542f\u7528\u72b6\u6001\u6709\u8bef");
            }
        }
        OrgUtil.deleteAllCache();
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            this.crmLogSendUtil.sendForUpdate((String)menuObject, entity.getId(), entity.getOrgName(), CrmBeanUtil.copy((Object)old, MdmOrgRespVo.class), CrmBeanUtil.copy((Object)entity, MdmOrgRespVo.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId, MdmOrgEntity::getOrgCode, CrmTreeTenEntity::getRuleCode}).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684\u53c2\u6570");
        List<String> orgCodeList = list.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toList());
        List children = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getParentCode, orgCodeList)).notIn(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)children), (String)"\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5220\u9664");
        List<MdmPositionRespVo> positionList = this.mdmPositionService.queryBatchByOrgCodeList(orgCodeList);
        Assert.isTrue((boolean)CollectionUtils.isEmpty(positionList), (String)"\u5b58\u5728\u5173\u8054\u804c\u4f4d\u65e0\u6cd5\u5220\u9664");
        List<String> terminalRelList = this.mdmTerminalROrgService.findTerminalCodeByOrg(orgCodeList);
        Assert.isTrue((boolean)CollectionUtils.isEmpty(terminalRelList), (String)"\u5b58\u5728\u5173\u8054\u7ec8\u7aef\u65e0\u6cd5\u5220\u9664");
        List<String> customerRelList = this.mdmCustomerROrgService.findCustomerByOrgCodeList(orgCodeList);
        Assert.isTrue((boolean)CollectionUtils.isEmpty(customerRelList), (String)"\u5b58\u5728\u5173\u8054\u5ba2\u6237\u65e0\u6cd5\u5220\u9664");
        List<MdmOrgRegionRespVo> orgRegionList = this.mdmOrgRegionService.findOrgRegionByOrgCodeList(orgCodeList);
        Assert.isTrue((boolean)CollectionUtils.isEmpty(orgRegionList), (String)"\u5b58\u5728\u5173\u8054\u884c\u653f\u533a\u57df\u65e0\u6cd5\u5220\u9664");
        this.removeByIds(ids);
        OrgUtil.deleteAllCache();
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            for (String id : ids) {
                MdmOrgRespVo detail = this.detail(id, null);
                if (detail == null) continue;
                this.crmLogSendUtil.sendForDel((String)menuObject, detail.getId(), detail.getOrgName(), CrmBeanUtil.copy((Object)detail, MdmOrgRespVo.class));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u53c2\u6570");
        this.deleteBatch(reqVo.getIds());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List parentDisableList;
        Set parentRuleCodes;
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list) && !(parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodesExcludeAnySelf(list.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()))).isEmpty() && CollectionUtil.listNotEmptyNotSizeZero((List)(parentDisableList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).in(CrmTreeTenEntity::getRuleCode, (Collection)parentRuleCodes)).select(new SFunction[]{MdmOrgEntity::getOrgName}).list()))) {
            throw new BusinessException("\u5b58\u5728\u672a\u542f\u7528\u7684\u7ec4\u7ec7[" + ((MdmOrgEntity)parentDisableList.get(0)).getOrgName() + "],\u4e0d\u80fd\u542f\u7528\u5f53\u524d\u7ec4\u7ec7");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        OrgUtil.deleteAllCache();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u53c2\u6570");
        this.disableBatch(reqVo.getIds());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List<String> childrenCodeList = this.findAllChildrenOrgCodeListByList(ids, null);
        if (CollectionUtil.listNotEmptyNotSizeZero(childrenCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmOrgEntity::getOrgCode, childrenCodeList)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
            OrgUtil.deleteAllCache();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u53c2\u6570");
        this.disableBatch(reqVo.getIds());
    }

    @Override
    public List<MdmOrgSelectRespVo> findOrgSelectList(MdmOrgSelectReqVo reqVo) {
        MdmOrgEntity one;
        ArrayList<MdmOrgSelectRespVo> list = new ArrayList<MdmOrgSelectRespVo>();
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        String underThisRuleCode = null;
        String notUnderThisRuleCode = null;
        if (StringUtils.isNotEmpty((String)reqVo.getUnderThisOrgCode()) && (one = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getUnderThisOrgCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            underThisRuleCode = one.getRuleCode();
        }
        if (StringUtils.isNotEmpty((String)reqVo.getNotUnderThisOrgCode()) && (one = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getNotUnderThisOrgCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            notUnderThisRuleCode = one.getRuleCode();
        }
        HashSet<String> codeList = new HashSet<String>(16);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmOrgMapper.findOrgSelectList((Page<MdmOrgSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, underThisRuleCode, notUnderThisRuleCode));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findAllChildrenOrgList(String orgId, String orgCode) {
        MdmOrgEntity org;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (MdmOrgEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)org.getRuleCode())).list();
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findAllChildrenOrgListByList(List<String> ids, List<String> orgCodeList) {
        List orgEntityList;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).in(CollectionUtil.listNotEmptyNotSizeZero(orgCodeList), MdmOrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).list()))) {
            List<String> collect = orgEntityList.stream().map(item -> item.getRuleCode() + "%").collect(Collectors.toList());
            return this.mdmOrgMapper.findOrgChildrenByRuleCodeList(collect);
        }
        return list;
    }

    @Override
    public List<String> findAllChildrenOrgCodeList(String orgId, String orgCode) {
        MdmOrgEntity org;
        ArrayList<String> list = new ArrayList<String>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (MdmOrgEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)org.getRuleCode())).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
            list.addAll(entityList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    public List<String> findAllChildrenOrgCodeListByList(List<String> ids, List<String> orgCodeList) {
        List<String> collect;
        List<MdmOrgRespVo> orgChildrenList;
        List list;
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).in(CollectionUtil.listNotEmptyNotSizeZero(orgCodeList), MdmOrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).list())) && CollectionUtil.listNotEmptyNotSizeZero(orgChildrenList = this.mdmOrgMapper.findOrgChildrenByRuleCodeList(collect = list.stream().map(item -> item.getRuleCode() + "%").collect(Collectors.toList())))) {
            return orgChildrenList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<MdmOrgRespVo> findSingleChildrenOrgList(String orgId, String orgCode) {
        MdmOrgEntity org;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (MdmOrgEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one()) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)org.getOrgCode())).list();
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findAllParentOrgList(String orgId, String orgCode) {
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        MdmOrgEntity one = (MdmOrgEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one();
        if (one != null) {
            Set ruleCodes = TreeRuleCodeUtil.splitParentRuleCodes((String)one.getRuleCode());
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)ruleCodes)).list();
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class));
        }
        return list;
    }

    @Override
    public List<String> findAllParentOrgCodeList(String orgId, String orgCode) {
        List<MdmOrgRespVo> allParentOrgList = this.findAllParentOrgList(orgId, orgCode);
        if (CollectionUtils.isEmpty(allParentOrgList)) {
            return Collections.emptyList();
        }
        return allParentOrgList.stream().filter(x -> !StringUtils.isEmpty((String)x.getOrgCode())).map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
    }

    @Override
    public MdmOrgRespVo findSingleParentOrg(String orgId, String orgCode) {
        MdmOrgEntity parent;
        MdmOrgEntity one;
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (one = (MdmOrgEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one()) != null && StringUtils.isNotEmpty((String)one.getParentCode()) && (parent = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)one.getParentCode())).one()) != null) {
            return (MdmOrgRespVo)CrmBeanUtil.copy((Object)parent, MdmOrgRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    public void resetRuleCode2() {
        long l = System.currentTimeMillis();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u5f00\u59cb-----------");
        this.mdmOrgMapper.copyIdToRuleCode();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f-----------");
        this.mdmOrgMapper.setNullNotExistParentCode();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f-----------");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmOrgEntity::getParentCode)).or()).eq(MdmOrgEntity::getParentCode, (Object)"")).list();
        for (int i = 0; i < list.size(); ++i) {
            this.updateCurAndChildren(((MdmOrgEntity)list.get(i)).getOrgCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
        }
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f16\u7801\u91cd\u65b0\u751f\u6210\u6210\u529f-----------");
        OrgUtil.deleteAllCache();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f13\u5b58\u6e05\u9664\u6210\u529f-----------");
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7ed3\u675f-----------");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    public void resetRuleCode() {
        long l = System.currentTimeMillis();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u5f00\u59cb-----------");
        this.mdmOrgMapper.copyIdToRuleCode();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f-----------");
        this.mdmOrgMapper.setNullNotExistParentCode();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f-----------");
        List<MdmOrgTreeRespVo> orgTree = this.getOrgTreeForResetRuleCode();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u6811\u5f62\u7ed3\u6784\u6784\u5efa\u6210\u529f-----------");
        this.updateCurAndChildren2(orgTree, "", 1);
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f16\u7801\u66f4\u65b0\u6210\u529f-----------");
        OrgUtil.deleteAllCache();
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f13\u5b58\u6e05\u9664\u6210\u529f-----------");
        log.info("-----------\u91cd\u7f6e\u4f01\u4e1a\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801_" + l + "_\u7ed3\u675f-----------");
    }

    @Override
    public List<MdmOrgWithPositionRespVo> findOrgWithAllPositionList(List<String> orgCodeList) {
        List orgList;
        List<Object> list = new ArrayList<MdmOrgWithPositionRespVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, orgCodeList)).list()))) {
            list = CrmBeanUtil.copyList((List)orgList, MdmOrgWithPositionRespVo.class);
            list.forEach(item -> {
                MdmPositionUserOrgReqVo reqVo = new MdmPositionUserOrgReqVo();
                reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                reqVo.setAllUnderThisOrgCode(item.getOrgCode());
                item.setPositionList(this.mdmPositionService.findPositionUserOrgList(reqVo));
            });
        }
        return list;
    }

    @Override
    public List<MdmOrgWithPositionRespVo> findOrgWithSinglePositionList(List<String> orgCodeList) {
        List orgList;
        List<Object> list = new ArrayList<MdmOrgWithPositionRespVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, orgCodeList)).list()))) {
            MdmPositionUserOrgReqVo reqVo = new MdmPositionUserOrgReqVo();
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            reqVo.setOrgCodeList(orgCodeList);
            List<MdmPositionUserOrgRespVo> positionUserOrgList = this.mdmPositionService.findPositionUserOrgList(reqVo);
            list = CrmBeanUtil.copyList((List)orgList, MdmOrgWithPositionRespVo.class);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionUserOrgList)) {
                Map<String, List<MdmPositionUserOrgRespVo>> collect = positionUserOrgList.stream().collect(Collectors.groupingBy(MdmPositionUserOrgRespVo::getOrgCode));
                list.forEach(item -> item.setPositionList((List)collect.get(item.getOrgCode())));
            }
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findOrgAndChildrenList(MdmOrgSearchReqVo reqVo) {
        List orgList;
        ArrayList<String> rightLikeOrgRuleCodeList = new ArrayList<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getUnderOrgCodeList()) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, (Collection)reqVo.getUnderOrgCodeList())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).list()))) {
            rightLikeOrgRuleCodeList.addAll(orgList.stream().map(k -> k.getRuleCode() + "%").collect(Collectors.toList()));
        }
        if (reqVo.getPageSize() == null || reqVo.getPageSize() == 0) {
            reqVo.setPageSize(Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size")));
        }
        return this.mdmOrgMapper.findOrgAndChildrenList((Page<MdmOrgRespVo>)new Page(1L, (long)reqVo.getPageSize().intValue(), false), reqVo, rightLikeOrgRuleCodeList);
    }

    private String generateRuleCodeByParentCode(String parentCode) {
        MdmOrgEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((String)parentCode) && (parent = (MdmOrgEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)parentCode)).one()) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmOrgEntity::getParentCode)).or()).eq(MdmOrgEntity::getParentCode, (Object)"")).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)parentCode)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmOrgEntity item : list) {
                if (!StringUtils.isNotEmpty((String)item.getRuleCode())) continue;
                try {
                    Integer integer = TreeRuleCodeUtil.getCurLevelCodeValue((String)item.getRuleCode());
                    set.add(integer);
                }
                catch (BusinessException e) {
                    throw new BusinessException("\u4f01\u4e1a\u7ec4\u7ec7" + e.getMsg());
                }
            }
            int maxRuleCodeValueInLevel = TreeRuleCodeUtil.getMaxRuleCodeValueInLevel();
            for (int i = 1; i <= maxRuleCodeValueInLevel; ++i) {
                if (i == maxRuleCodeValueInLevel) {
                    throw new BusinessException("\u964d\u7ef4\u7f16\u7801\u8d8a\u754c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                }
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)i);
                break;
            }
        }
        return ruleCode;
    }

    private void updateCurAndChildren(String orgCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmOrgEntity::getOrgCode, (Object)orgCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)orgCode)).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmOrgEntity)list.get(i)).getOrgCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }

    private void updateCurAndChildren2(List<MdmOrgTreeRespVo> list, String parentRuleCode, int curLevelNum) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            for (int i = 0; i < list.size(); ++i) {
                MdmOrgTreeRespVo item = list.get(i);
                item.setRuleCode(parentRuleCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)));
                item.setLevelNum(Integer.valueOf(curLevelNum));
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmOrgEntity::getOrgCode, (Object)item.getOrgCode())).set(CrmTreeTenEntity::getRuleCode, (Object)item.getRuleCode())).set(CrmTreeTenEntity::getLevelNum, (Object)item.getLevelNum())).update();
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)item.getChildren())) continue;
                this.updateCurAndChildren2(item.getChildren(), item.getRuleCode(), item.getLevelNum() + 1);
            }
        }
    }

    @Override
    public List<MdmOrgRespVo> listCondition(MdmOrgReqVo reqVo) {
        if (CollectionUtil.collectionNotEmpty((Collection)reqVo.getOrgCodeList())) {
            List mdmOrgEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, reqVo.getOrgCodeList())).list();
            return CrmBeanUtil.copyList((List)mdmOrgEntities, MdmOrgRespVo.class);
        }
        return Lists.emptyList();
    }

    @Override
    public List<MdmOrgRespVo> findOrgList(MdmOrgReqVo reqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).eq(StringUtils.isNotEmpty((String)reqVo.getOrgType()), MdmOrgEntity::getOrgType, (Object)reqVo.getOrgType())).eq(StringUtils.isNotEmpty((String)reqVo.getParentCode()), MdmOrgEntity::getParentCode, (Object)reqVo.getParentCode())).like(StringUtils.isNotEmpty((String)reqVo.getOrgCode()), MdmOrgEntity::getOrgCode, (Object)reqVo.getOrgCode())).like(StringUtils.isNotEmpty((String)reqVo.getOrgName()), MdmOrgEntity::getOrgName, (Object)reqVo.getOrgName())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return CrmBeanUtil.copyList((List)list, MdmOrgRespVo.class);
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    @Override
    public List<MdmOrgTreeRespVo> getOrgTree() {
        List list = this.lambdaQuery().list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List totalList = CrmBeanUtil.copyList((List)list, MdmOrgTreeRespVo.class);
            ArrayList<MdmOrgTreeRespVo> treeList = new ArrayList<MdmOrgTreeRespVo>();
            ArrayList<Object> curLevelList = new ArrayList<Object>();
            ArrayList<Object> restList = new ArrayList<Object>();
            Map<String, MdmOrgTreeRespVo> totalMap = totalList.stream().collect(Collectors.toMap(MdmOrgTreeRespVo::getOrgCode, v -> v));
            for (MdmOrgTreeRespVo item : totalList) {
                if (StringUtils.isEmpty((String)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                    treeList.add(item);
                    curLevelList.add(item);
                    continue;
                }
                restList.add(item);
            }
            while (curLevelList.size() > 0 && restList.size() > 0) {
                ArrayList<MdmOrgTreeRespVo> restTempList = new ArrayList<MdmOrgTreeRespVo>();
                ArrayList<MdmOrgTreeRespVo> curLevelTempList = new ArrayList<MdmOrgTreeRespVo>();
                Set curLevelSet = curLevelList.stream().map(MdmOrgTreeRespVo::getOrgCode).collect(Collectors.toSet());
                HashMap curLevelChildrenMap = new HashMap();
                for (MdmOrgTreeRespVo mdmOrgTreeRespVo : restList) {
                    if (curLevelSet.contains(mdmOrgTreeRespVo.getParentCode())) {
                        curLevelTempList.add(mdmOrgTreeRespVo);
                        ArrayList<MdmOrgTreeRespVo> childrenList = new ArrayList<MdmOrgTreeRespVo>();
                        if (curLevelChildrenMap.containsKey(mdmOrgTreeRespVo.getParentCode())) {
                            childrenList.addAll((Collection)curLevelChildrenMap.get(mdmOrgTreeRespVo.getParentCode()));
                        }
                        childrenList.add(mdmOrgTreeRespVo);
                        curLevelChildrenMap.put(mdmOrgTreeRespVo.getParentCode(), childrenList);
                        continue;
                    }
                    restTempList.add(mdmOrgTreeRespVo);
                }
                for (MdmOrgTreeRespVo mdmOrgTreeRespVo : curLevelList) {
                    if (!curLevelChildrenMap.containsKey(mdmOrgTreeRespVo.getOrgCode())) continue;
                    mdmOrgTreeRespVo.setChildren((List)curLevelChildrenMap.get(mdmOrgTreeRespVo.getOrgCode()));
                }
                curLevelList.clear();
                curLevelList.addAll(curLevelTempList);
                restList.clear();
                restList.addAll(restTempList);
            }
            return treeList;
        }
        return new ArrayList<MdmOrgTreeRespVo>();
    }

    @Override
    public List<String> findAllParentOrgCodeExcludeSelf(List<String> orgCodeList) {
        Set strings;
        List orgList;
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).list())) && !(strings = TreeRuleCodeUtil.splitParentRuleCodesExcludeSelf(orgList.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()))).isEmpty()) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)strings)).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list().stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, String> findOrgNameMap(List<String> orgCodeList) {
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return Collections.emptyMap();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName}).list().stream().filter(x -> !StringUtils.isEmpty((String)x.getOrgCode())).collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName));
    }

    @Override
    public List<String> findAllChildrenOrgCodeListOfPositionChildrenList(List<String> positionCodeList) {
        Set orgCodeSet;
        List allChildrenPositionList;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(allChildrenPositionList = PositionUtil.getChildrenPositionListExcludeSelf(positionCodeList))) && !(orgCodeSet = allChildrenPositionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionRespVo::getOrgCode).collect(Collectors.toSet())).isEmpty()) {
            return OrgUtil.getChildrenOrgCodeListExcludeSelf(new ArrayList(orgCodeSet));
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> findAllParentOrgCodeListOfPositionParentList(List<String> positionCodeList) {
        Set orgRuleCode;
        Set parentOrgRuleCode;
        Set parentPositionOrgCodeSet;
        Set parentRuleCodesExcludeSelf;
        List positionList;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getParentCode, CrmTreeTenEntity::getRuleCode}).list())) && !(parentRuleCodesExcludeSelf = TreeRuleCodeUtil.splitParentRuleCodesExcludeSelf(positionList.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()))).isEmpty() && !(parentPositionOrgCodeSet = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(CrmTreeTenEntity::getRuleCode, (Collection)parentRuleCodesExcludeSelf)).select(new SFunction[]{MdmPositionEntity::getOrgCode}).list().stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionEntity::getOrgCode).collect(Collectors.toSet())).isEmpty() && !(parentOrgRuleCode = TreeRuleCodeUtil.splitParentRuleCodesExcludeSelf(new ArrayList(orgRuleCode = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, parentPositionOrgCodeSet)).select(new SFunction[]{MdmOrgEntity::getOrgCode, CrmTreeTenEntity::getRuleCode}).list().stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toSet())))).isEmpty()) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)parentOrgRuleCode)).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list().stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<MdmOrgTreeRespVo> orgSearchTree(MdmOrgReqVo mdmOrgReqVo) {
        ArrayList<MdmOrgTreeRespVo> tree = new ArrayList<MdmOrgTreeRespVo>();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((String)mdmOrgReqVo.getOrgName()), MdmOrgEntity::getOrgName, (Object)mdmOrgReqVo.getOrgName())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Set set;
            if (StringUtils.isNotEmpty((String)mdmOrgReqVo.getOrgName()) && !(set = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()))).isEmpty()) {
                list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)set)).list();
            }
            List collect = CrmBeanUtil.copyList((List)list, MdmOrgTreeRespVo.class);
            Map orgTypeMap = DictUtil.dictMap((String)"mdm_org_type");
            if (orgTypeMap != null && orgTypeMap.size() > 0) {
                for (MdmOrgTreeRespVo mdmOrgTreeRespVo : collect) {
                    String orgType = mdmOrgTreeRespVo.getOrgType();
                    if (StringUtils.isEmpty((String)orgType)) continue;
                    mdmOrgTreeRespVo.setOrgTypeName((String)orgTypeMap.get(orgType));
                }
            }
            for (MdmOrgTreeRespVo mdmOrgTreeRespVo : collect) {
                ArrayList<MdmOrgTreeRespVo> children;
                if (StringUtils.isEmpty((String)mdmOrgTreeRespVo.getParentCode())) {
                    tree.add(mdmOrgTreeRespVo);
                }
                if ((children = mdmOrgTreeRespVo.getChildren()) == null) {
                    children = new ArrayList<MdmOrgTreeRespVo>();
                }
                for (MdmOrgTreeRespVo orgTreeRespVo : collect) {
                    if (!mdmOrgTreeRespVo.getOrgCode().equals(orgTreeRespVo.getParentCode())) continue;
                    children.add(orgTreeRespVo);
                }
                mdmOrgTreeRespVo.setChildren(children);
            }
        }
        return tree;
    }

    private List<MdmOrgTreeRespVo> getOrgTreeForResetRuleCode() {
        List list = this.lambdaQuery().select(new SFunction[]{BaseIdEntity::getId, MdmOrgEntity::getOrgCode, MdmOrgEntity::getParentCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List totalList = CrmBeanUtil.copyList((List)list, MdmOrgTreeRespVo.class);
            ArrayList<MdmOrgTreeRespVo> treeList = new ArrayList<MdmOrgTreeRespVo>();
            ArrayList<Object> curLevelList = new ArrayList<Object>();
            ArrayList<Object> restList = new ArrayList<Object>();
            Set totalCodeSet = totalList.stream().map(MdmOrgTreeRespVo::getOrgCode).collect(Collectors.toSet());
            for (MdmOrgTreeRespVo item : totalList) {
                if (StringUtils.isEmpty((String)item.getParentCode()) || !totalCodeSet.contains(item.getParentCode())) {
                    treeList.add(item);
                    curLevelList.add(item);
                    continue;
                }
                restList.add(item);
            }
            while (curLevelList.size() > 0 && restList.size() > 0) {
                ArrayList<MdmOrgTreeRespVo> restTempList = new ArrayList<MdmOrgTreeRespVo>();
                ArrayList<MdmOrgTreeRespVo> curLevelTempList = new ArrayList<MdmOrgTreeRespVo>();
                Set curLevelCodeSet = curLevelList.stream().map(MdmOrgTreeRespVo::getOrgCode).collect(Collectors.toSet());
                HashMap curLevelChildrenMap = new HashMap();
                for (MdmOrgTreeRespVo mdmOrgTreeRespVo : restList) {
                    if (curLevelCodeSet.contains(mdmOrgTreeRespVo.getParentCode())) {
                        curLevelTempList.add(mdmOrgTreeRespVo);
                        ArrayList<MdmOrgTreeRespVo> childrenList = new ArrayList<MdmOrgTreeRespVo>();
                        if (curLevelChildrenMap.containsKey(mdmOrgTreeRespVo.getParentCode())) {
                            childrenList.addAll((Collection)curLevelChildrenMap.get(mdmOrgTreeRespVo.getParentCode()));
                        }
                        childrenList.add(mdmOrgTreeRespVo);
                        curLevelChildrenMap.put(mdmOrgTreeRespVo.getParentCode(), childrenList);
                        continue;
                    }
                    restTempList.add(mdmOrgTreeRespVo);
                }
                for (MdmOrgTreeRespVo mdmOrgTreeRespVo : curLevelList) {
                    if (!curLevelChildrenMap.containsKey(mdmOrgTreeRespVo.getOrgCode())) continue;
                    mdmOrgTreeRespVo.setChildren((List)curLevelChildrenMap.get(mdmOrgTreeRespVo.getOrgCode()));
                }
                curLevelList.clear();
                curLevelList.addAll(curLevelTempList);
                restList.clear();
                restList.addAll(restTempList);
            }
            return treeList;
        }
        return new ArrayList<MdmOrgTreeRespVo>();
    }
}

